/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.test;

import io.rsocket.Payload;
import java.util.concurrent.CountDownLatch;
import org.reactivestreams.Subscription;
import reactor.core.publisher.BaseSubscriber;

class CountdownBaseSubscriber
extends BaseSubscriber<Payload> {
    private CountDownLatch latch = new CountDownLatch(0);
    private int count = 0;

    CountdownBaseSubscriber() {
    }

    public void expect(int count) {
        this.latch = new CountDownLatch((int)this.latch.getCount() + count);
        if (this.upstream() != null) {
            this.request(count);
        }
    }

    protected void hookOnNext(Payload value) {
        ++this.count;
        this.latch.countDown();
    }

    protected void hookOnSubscribe(Subscription subscription) {
        long count = this.latch.getCount();
        if (count > 0L) {
            subscription.request(count);
        }
    }

    public void await() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public int count() {
        return this.count;
    }
}

