/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.DuplexConnection;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.core.PayloadValidationUtils;
import io.rsocket.core.ReassemblyUtils;
import io.rsocket.core.RequesterResponderSupport;
import io.rsocket.core.ResponderFrameHandler;
import io.rsocket.core.SendUtils;
import io.rsocket.exceptions.CanceledException;
import io.rsocket.frame.ErrorFrameCodec;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.PayloadFrameCodec;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.plugins.RequestInterceptor;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class RequestResponseResponderSubscriber
implements ResponderFrameHandler,
CoreSubscriber<Payload> {
    static final Logger logger = LoggerFactory.getLogger(RequestResponseResponderSubscriber.class);
    final int streamId;
    final ByteBufAllocator allocator;
    final PayloadDecoder payloadDecoder;
    final int mtu;
    final int maxFrameLength;
    final int maxInboundPayloadSize;
    final RequesterResponderSupport requesterResponderSupport;
    final DuplexConnection connection;
    final RSocket handler;
    @Nullable
    final RequestInterceptor requestInterceptor;
    boolean done;
    CompositeByteBuf frames;
    volatile Subscription s;
    static final AtomicReferenceFieldUpdater<RequestResponseResponderSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(RequestResponseResponderSubscriber.class, Subscription.class, "s");

    public RequestResponseResponderSubscriber(int streamId, ByteBuf firstFrame, RequesterResponderSupport requesterResponderSupport, RSocket handler) {
        this.streamId = streamId;
        this.allocator = requesterResponderSupport.getAllocator();
        this.mtu = requesterResponderSupport.getMtu();
        this.maxFrameLength = requesterResponderSupport.getMaxFrameLength();
        this.maxInboundPayloadSize = requesterResponderSupport.getMaxInboundPayloadSize();
        this.requesterResponderSupport = requesterResponderSupport;
        this.connection = requesterResponderSupport.getDuplexConnection();
        this.payloadDecoder = requesterResponderSupport.getPayloadDecoder();
        this.requestInterceptor = requesterResponderSupport.getRequestInterceptor();
        this.handler = handler;
        this.frames = ReassemblyUtils.addFollowingFrame(this.allocator.compositeBuffer(), firstFrame, true, this.maxInboundPayloadSize);
    }

    public RequestResponseResponderSubscriber(int streamId, RequesterResponderSupport requesterResponderSupport) {
        this.streamId = streamId;
        this.allocator = requesterResponderSupport.getAllocator();
        this.mtu = requesterResponderSupport.getMtu();
        this.maxFrameLength = requesterResponderSupport.getMaxFrameLength();
        this.maxInboundPayloadSize = requesterResponderSupport.getMaxInboundPayloadSize();
        this.requesterResponderSupport = requesterResponderSupport;
        this.connection = requesterResponderSupport.getDuplexConnection();
        this.requestInterceptor = requesterResponderSupport.getRequestInterceptor();
        this.payloadDecoder = null;
        this.handler = null;
        this.frames = null;
    }

    public void onSubscribe(Subscription subscription) {
        if (Operators.validate((Subscription)this.s, (Subscription)subscription)) {
            S.lazySet(this, subscription);
            subscription.request(Long.MAX_VALUE);
        }
    }

    public void onNext(@Nullable Payload p) {
        block14: {
            if (this.done) {
                if (p != null) {
                    p.release();
                }
                return;
            }
            Subscription currentSubscription = this.s;
            if (currentSubscription == Operators.cancelledSubscription() || !S.compareAndSet(this, currentSubscription, Operators.cancelledSubscription())) {
                if (p != null) {
                    p.release();
                }
                return;
            }
            this.done = true;
            int streamId = this.streamId;
            DuplexConnection connection = this.connection;
            ByteBufAllocator allocator = this.allocator;
            this.requesterResponderSupport.remove(streamId, this);
            if (p == null) {
                ByteBuf completeFrame = PayloadFrameCodec.encodeComplete(allocator, streamId);
                connection.sendFrame(streamId, completeFrame);
                RequestInterceptor requestInterceptor = this.requestInterceptor;
                if (requestInterceptor != null) {
                    requestInterceptor.onTerminate(streamId, FrameType.REQUEST_RESPONSE, null);
                }
                return;
            }
            int mtu = this.mtu;
            try {
                if (!PayloadValidationUtils.isValid(mtu, this.maxFrameLength, p, false)) {
                    currentSubscription.cancel();
                    p.release();
                    CanceledException e = new CanceledException(String.format("The payload is too big to be send as a single frame with a max frame length %s. Consider enabling fragmentation.", this.maxFrameLength));
                    ByteBuf errorFrame = ErrorFrameCodec.encode(allocator, streamId, e);
                    connection.sendFrame(streamId, errorFrame);
                    RequestInterceptor requestInterceptor = this.requestInterceptor;
                    if (requestInterceptor != null) {
                        requestInterceptor.onTerminate(streamId, FrameType.REQUEST_RESPONSE, e);
                    }
                    return;
                }
            }
            catch (IllegalReferenceCountException e) {
                currentSubscription.cancel();
                ByteBuf errorFrame = ErrorFrameCodec.encode(allocator, streamId, new CanceledException("Failed to validate payload. Cause" + e.getMessage()));
                connection.sendFrame(streamId, errorFrame);
                RequestInterceptor requestInterceptor = this.requestInterceptor;
                if (requestInterceptor != null) {
                    requestInterceptor.onTerminate(streamId, FrameType.REQUEST_RESPONSE, e);
                }
                return;
            }
            try {
                SendUtils.sendReleasingPayload(streamId, FrameType.NEXT_COMPLETE, mtu, p, connection, allocator, false);
                RequestInterceptor requestInterceptor = this.requestInterceptor;
                if (requestInterceptor != null) {
                    requestInterceptor.onTerminate(streamId, FrameType.REQUEST_RESPONSE, null);
                }
            }
            catch (Throwable t) {
                currentSubscription.cancel();
                RequestInterceptor requestInterceptor = this.requestInterceptor;
                if (requestInterceptor == null) break block14;
                requestInterceptor.onTerminate(streamId, FrameType.REQUEST_RESPONSE, t);
            }
        }
    }

    public void onError(Throwable t) {
        if (this.done) {
            logger.debug("Dropped error", t);
            return;
        }
        Subscription currentSubscription = this.s;
        if (currentSubscription == Operators.cancelledSubscription() || !S.compareAndSet(this, currentSubscription, Operators.cancelledSubscription())) {
            logger.debug("Dropped error", t);
            return;
        }
        this.done = true;
        int streamId = this.streamId;
        this.requesterResponderSupport.remove(streamId, this);
        ByteBuf errorFrame = ErrorFrameCodec.encode(this.allocator, streamId, t);
        this.connection.sendFrame(streamId, errorFrame);
        RequestInterceptor requestInterceptor = this.requestInterceptor;
        if (requestInterceptor != null) {
            requestInterceptor.onTerminate(streamId, FrameType.REQUEST_RESPONSE, t);
        }
    }

    public void onComplete() {
        this.onNext(null);
    }

    @Override
    public void handleCancel() {
        Subscription currentSubscription = this.s;
        if (currentSubscription == Operators.cancelledSubscription()) {
            return;
        }
        if (currentSubscription == null) {
            RequestInterceptor requestInterceptor;
            S.lazySet(this, Operators.cancelledSubscription());
            int streamId = this.streamId;
            this.requesterResponderSupport.remove(streamId, this);
            CompositeByteBuf frames = this.frames;
            if (frames != null) {
                this.frames = null;
                frames.release();
            }
            if ((requestInterceptor = this.requestInterceptor) != null) {
                requestInterceptor.onCancel(streamId, FrameType.REQUEST_RESPONSE);
            }
            return;
        }
        if (!S.compareAndSet(this, currentSubscription, Operators.cancelledSubscription())) {
            return;
        }
        int streamId = this.streamId;
        this.requesterResponderSupport.remove(streamId, this);
        currentSubscription.cancel();
        RequestInterceptor requestInterceptor = this.requestInterceptor;
        if (requestInterceptor != null) {
            requestInterceptor.onCancel(streamId, FrameType.REQUEST_RESPONSE);
        }
    }

    @Override
    public void handleNext(ByteBuf frame, boolean hasFollows, boolean isLastPayload) {
        CompositeByteBuf frames = this.frames;
        if (frames == null) {
            return;
        }
        try {
            ReassemblyUtils.addFollowingFrame(frames, frame, hasFollows, this.maxInboundPayloadSize);
        }
        catch (IllegalStateException t) {
            S.lazySet(this, Operators.cancelledSubscription());
            this.requesterResponderSupport.remove(this.streamId, this);
            this.frames = null;
            frames.release();
            logger.debug("Reassembly has failed", (Throwable)t);
            int streamId = this.streamId;
            ByteBuf errorFrame = ErrorFrameCodec.encode(this.allocator, streamId, new CanceledException("Failed to reassemble payload. Cause: " + t.getMessage()));
            this.connection.sendFrame(streamId, errorFrame);
            RequestInterceptor requestInterceptor = this.requestInterceptor;
            if (requestInterceptor != null) {
                requestInterceptor.onTerminate(streamId, FrameType.REQUEST_RESPONSE, t);
            }
            return;
        }
        if (!hasFollows) {
            Payload payload;
            this.frames = null;
            try {
                payload = (Payload)this.payloadDecoder.apply(frames);
                frames.release();
            }
            catch (Throwable t) {
                S.lazySet(this, Operators.cancelledSubscription());
                int streamId = this.streamId;
                this.requesterResponderSupport.remove(streamId, this);
                ReferenceCountUtil.safeRelease((Object)frames);
                logger.debug("Reassembly has failed", t);
                ByteBuf errorFrame = ErrorFrameCodec.encode(this.allocator, streamId, new CanceledException("Failed to reassemble payload. Cause: " + t.getMessage()));
                this.connection.sendFrame(streamId, errorFrame);
                RequestInterceptor requestInterceptor = this.requestInterceptor;
                if (requestInterceptor != null) {
                    requestInterceptor.onTerminate(streamId, FrameType.REQUEST_RESPONSE, t);
                }
                return;
            }
            Mono<Payload> source = this.handler.requestResponse(payload);
            source.subscribe((CoreSubscriber)this);
        }
    }

    public Context currentContext() {
        return SendUtils.DISCARD_CONTEXT;
    }
}

