/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.loadbalance;

import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.core.RSocketClient;
import io.rsocket.core.RSocketConnector;
import io.rsocket.loadbalance.LoadbalanceStrategy;
import io.rsocket.loadbalance.LoadbalanceTarget;
import io.rsocket.loadbalance.RSocketPool;
import io.rsocket.loadbalance.RoundRobinLoadbalanceStrategy;
import io.rsocket.loadbalance.WeightedLoadbalanceStrategy;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class LoadbalanceRSocketClient
implements RSocketClient {
    private final RSocketPool rSocketPool;

    private LoadbalanceRSocketClient(RSocketPool rSocketPool) {
        this.rSocketPool = rSocketPool;
    }

    @Override
    public Mono<RSocket> source() {
        return Mono.fromSupplier(this.rSocketPool::select);
    }

    @Override
    public Mono<Void> fireAndForget(Mono<Payload> payloadMono) {
        return payloadMono.flatMap(p -> this.rSocketPool.select().fireAndForget((Payload)p));
    }

    @Override
    public Mono<Payload> requestResponse(Mono<Payload> payloadMono) {
        return payloadMono.flatMap(p -> this.rSocketPool.select().requestResponse((Payload)p));
    }

    @Override
    public Flux<Payload> requestStream(Mono<Payload> payloadMono) {
        return payloadMono.flatMapMany(p -> this.rSocketPool.select().requestStream((Payload)p));
    }

    @Override
    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        return this.rSocketPool.select().requestChannel(payloads);
    }

    @Override
    public Mono<Void> metadataPush(Mono<Payload> payloadMono) {
        return payloadMono.flatMap(p -> this.rSocketPool.select().metadataPush((Payload)p));
    }

    public void dispose() {
        this.rSocketPool.dispose();
    }

    public static LoadbalanceRSocketClient create(RSocketConnector connector, Publisher<List<LoadbalanceTarget>> targetPublisher) {
        return LoadbalanceRSocketClient.builder(targetPublisher).connector(connector).build();
    }

    public static Builder builder(Publisher<List<LoadbalanceTarget>> targetPublisher) {
        return new Builder(targetPublisher);
    }

    public static class Builder {
        private final Publisher<List<LoadbalanceTarget>> targetPublisher;
        @Nullable
        private RSocketConnector connector;
        @Nullable
        LoadbalanceStrategy loadbalanceStrategy;

        Builder(Publisher<List<LoadbalanceTarget>> targetPublisher) {
            this.targetPublisher = targetPublisher;
        }

        public Builder connector(RSocketConnector connector) {
            this.connector = connector;
            return this;
        }

        public Builder roundRobinLoadbalanceStrategy() {
            this.loadbalanceStrategy = new RoundRobinLoadbalanceStrategy();
            return this;
        }

        public Builder weightedLoadbalanceStrategy() {
            this.loadbalanceStrategy = new WeightedLoadbalanceStrategy();
            return this;
        }

        public Builder loadbalanceStrategy(LoadbalanceStrategy strategy) {
            this.loadbalanceStrategy = strategy;
            return this;
        }

        public LoadbalanceRSocketClient build() {
            return new LoadbalanceRSocketClient(new RSocketPool(this.initConnector(), this.targetPublisher, this.initLoadbalanceStrategy()));
        }

        private RSocketConnector initConnector() {
            return this.connector != null ? this.connector : RSocketConnector.create();
        }

        private LoadbalanceStrategy initLoadbalanceStrategy() {
            return this.loadbalanceStrategy != null ? this.loadbalanceStrategy : new RoundRobinLoadbalanceStrategy();
        }
    }
}

