/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.IllegalReferenceCountException;
import io.rsocket.Payload;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.RequestFlyweight;

public class RequestFireAndForgetFrameFlyweight {
    private static final RequestFlyweight FLYWEIGHT = new RequestFlyweight(FrameType.REQUEST_FNF);

    private RequestFireAndForgetFrameFlyweight() {
    }

    public static ByteBuf encodeReleasingPayload(ByteBufAllocator allocator, int streamId, Payload payload) {
        ByteBuf data;
        boolean hasMetadata = payload.hasMetadata();
        ByteBuf metadata = hasMetadata ? payload.metadata().retain() : null;
        try {
            data = payload.data().retain();
        }
        catch (IllegalReferenceCountException | NullPointerException e) {
            if (hasMetadata) {
                metadata.release();
            }
            throw e;
        }
        try {
            payload.release();
        }
        catch (IllegalReferenceCountException e) {
            data.release();
            if (hasMetadata) {
                metadata.release();
            }
            throw e;
        }
        return FLYWEIGHT.encode(allocator, streamId, false, metadata, data);
    }

    public static ByteBuf encode(ByteBufAllocator allocator, int streamId, boolean fragmentFollows, ByteBuf metadata, ByteBuf data) {
        return FLYWEIGHT.encode(allocator, streamId, fragmentFollows, metadata, data);
    }

    public static ByteBuf data(ByteBuf byteBuf) {
        return FLYWEIGHT.data(byteBuf);
    }

    public static ByteBuf metadata(ByteBuf byteBuf) {
        return FLYWEIGHT.metadata(byteBuf);
    }
}

