/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.collection.IntObjectMap;
import io.rsocket.DuplexConnection;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.core.PayloadValidationUtils;
import io.rsocket.core.StreamIdSupplier;
import io.rsocket.exceptions.ConnectionErrorException;
import io.rsocket.frame.CancelFrameFlyweight;
import io.rsocket.frame.ErrorFrameFlyweight;
import io.rsocket.frame.FrameHeaderFlyweight;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.MetadataPushFrameFlyweight;
import io.rsocket.frame.PayloadFrameFlyweight;
import io.rsocket.frame.RequestChannelFrameFlyweight;
import io.rsocket.frame.RequestFireAndForgetFrameFlyweight;
import io.rsocket.frame.RequestNFrameFlyweight;
import io.rsocket.frame.RequestResponseFrameFlyweight;
import io.rsocket.frame.RequestStreamFrameFlyweight;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.internal.SynchronizedIntObjectHashMap;
import io.rsocket.internal.UnboundedProcessor;
import io.rsocket.internal.UnicastMonoEmpty;
import io.rsocket.internal.UnicastMonoProcessor;
import io.rsocket.keepalive.KeepAliveFramesAcceptor;
import io.rsocket.keepalive.KeepAliveHandler;
import io.rsocket.keepalive.KeepAliveSupport;
import io.rsocket.lease.RequesterLeaseHandler;
import io.rsocket.util.MonoLifecycleHandler;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.UnicastProcessor;
import reactor.util.concurrent.Queues;

class RSocketRequester
implements RSocket {
    private static final AtomicReferenceFieldUpdater<RSocketRequester, Throwable> TERMINATION_ERROR = AtomicReferenceFieldUpdater.newUpdater(RSocketRequester.class, Throwable.class, "terminationError");
    private static final Exception CLOSED_CHANNEL_EXCEPTION = new ClosedChannelException();
    private static final Consumer<ReferenceCounted> DROPPED_ELEMENTS_CONSUMER = referenceCounted -> {
        if (referenceCounted.refCnt() > 0) {
            try {
                referenceCounted.release();
            }
            catch (IllegalReferenceCountException illegalReferenceCountException) {
                // empty catch block
            }
        }
    };
    private final DuplexConnection connection;
    private final PayloadDecoder payloadDecoder;
    private final Consumer<Throwable> errorConsumer;
    private final StreamIdSupplier streamIdSupplier;
    private final IntObjectMap<Subscription> senders;
    private final IntObjectMap<Processor<Payload, Payload>> receivers;
    private final UnboundedProcessor<ByteBuf> sendProcessor;
    private final int mtu;
    private final RequesterLeaseHandler leaseHandler;
    private final ByteBufAllocator allocator;
    private final KeepAliveFramesAcceptor keepAliveFramesAcceptor;
    private volatile Throwable terminationError;
    private final MonoProcessor<Void> onClose;

    RSocketRequester(DuplexConnection connection, PayloadDecoder payloadDecoder, Consumer<Throwable> errorConsumer, StreamIdSupplier streamIdSupplier, int mtu, int keepAliveTickPeriod, int keepAliveAckTimeout, @Nullable KeepAliveHandler keepAliveHandler, RequesterLeaseHandler leaseHandler) {
        this.connection = connection;
        this.allocator = connection.alloc();
        this.payloadDecoder = payloadDecoder;
        this.errorConsumer = errorConsumer;
        this.streamIdSupplier = streamIdSupplier;
        this.mtu = mtu;
        this.leaseHandler = leaseHandler;
        this.senders = new SynchronizedIntObjectHashMap<Subscription>();
        this.receivers = new SynchronizedIntObjectHashMap<Processor<Payload, Payload>>();
        this.onClose = MonoProcessor.create();
        this.sendProcessor = new UnboundedProcessor();
        connection.onClose().or(this.onClose).subscribe(null, this::tryTerminateOnConnectionError, this::tryTerminateOnConnectionClose);
        connection.send((Publisher<ByteBuf>)this.sendProcessor).subscribe(null, this::handleSendProcessorError);
        connection.receive().subscribe(this::handleIncomingFrames, errorConsumer);
        if (keepAliveTickPeriod != 0 && keepAliveHandler != null) {
            KeepAliveSupport.ClientKeepAliveSupport keepAliveSupport = new KeepAliveSupport.ClientKeepAliveSupport(this.allocator, keepAliveTickPeriod, keepAliveAckTimeout);
            this.keepAliveFramesAcceptor = keepAliveHandler.start(keepAliveSupport, this.sendProcessor::onNextPrioritized, this::tryTerminateOnKeepAlive);
        } else {
            this.keepAliveFramesAcceptor = null;
        }
    }

    @Override
    public Mono<Void> fireAndForget(Payload payload) {
        return this.handleFireAndForget(payload);
    }

    @Override
    public Mono<Payload> requestResponse(Payload payload) {
        return this.handleRequestResponse(payload);
    }

    @Override
    public Flux<Payload> requestStream(Payload payload) {
        return this.handleRequestStream(payload);
    }

    @Override
    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        return this.handleChannel((Flux<Payload>)Flux.from(payloads));
    }

    @Override
    public Mono<Void> metadataPush(Payload payload) {
        return this.handleMetadataPush(payload);
    }

    @Override
    public double availability() {
        return Math.min(this.connection.availability(), this.leaseHandler.availability());
    }

    public void dispose() {
        this.tryTerminate(() -> new CancellationException("Disposed"));
    }

    public boolean isDisposed() {
        return this.onClose.isDisposed();
    }

    @Override
    public Mono<Void> onClose() {
        return this.onClose;
    }

    private Mono<Void> handleFireAndForget(Payload payload) {
        Throwable err = this.checkAvailable();
        if (err != null) {
            payload.release();
            return Mono.error((Throwable)err);
        }
        if (!PayloadValidationUtils.isValid(this.mtu, payload)) {
            payload.release();
            return Mono.error((Throwable)new IllegalArgumentException("The payload is too big to send as a single frame with a 24-bit encoded length. Consider enabling fragmentation via RSocketFactory."));
        }
        int streamId = this.streamIdSupplier.nextStreamId(this.receivers);
        return UnicastMonoEmpty.newInstance(() -> {
            ByteBuf requestFrame = RequestFireAndForgetFrameFlyweight.encodeReleasingPayload(this.allocator, streamId, payload);
            this.sendProcessor.onNext(requestFrame);
        });
    }

    private Mono<Payload> handleRequestResponse(final Payload payload) {
        Throwable err = this.checkAvailable();
        if (err != null) {
            payload.release();
            return Mono.error((Throwable)err);
        }
        if (!PayloadValidationUtils.isValid(this.mtu, payload)) {
            payload.release();
            return Mono.error((Throwable)new IllegalArgumentException("The payload is too big to send as a single frame with a 24-bit encoded length. Consider enabling fragmentation via RSocketFactory."));
        }
        final int streamId = this.streamIdSupplier.nextStreamId(this.receivers);
        final UnboundedProcessor<ByteBuf> sendProcessor = this.sendProcessor;
        UnicastMonoProcessor<Payload> receiver = UnicastMonoProcessor.create(new MonoLifecycleHandler<Payload>(){

            @Override
            public void doOnSubscribe() {
                ByteBuf requestFrame = RequestResponseFrameFlyweight.encodeReleasingPayload(RSocketRequester.this.allocator, streamId, payload);
                sendProcessor.onNext(requestFrame);
            }

            @Override
            public void doOnTerminal(@Nonnull SignalType signalType, @Nullable Payload element, @Nullable Throwable e) {
                if (signalType == SignalType.CANCEL) {
                    sendProcessor.onNext(CancelFrameFlyweight.encode(RSocketRequester.this.allocator, streamId));
                }
                RSocketRequester.this.removeStreamReceiver(streamId);
            }
        });
        this.receivers.put(streamId, receiver);
        return receiver.doOnDiscard(ReferenceCounted.class, DROPPED_ELEMENTS_CONSUMER);
    }

    private Flux<Payload> handleRequestStream(final Payload payload) {
        Throwable err = this.checkAvailable();
        if (err != null) {
            payload.release();
            return Flux.error((Throwable)err);
        }
        if (!PayloadValidationUtils.isValid(this.mtu, payload)) {
            payload.release();
            return Flux.error((Throwable)new IllegalArgumentException("The payload is too big to send as a single frame with a 24-bit encoded length. Consider enabling fragmentation via RSocketFactory."));
        }
        final int streamId = this.streamIdSupplier.nextStreamId(this.receivers);
        final UnboundedProcessor<ByteBuf> sendProcessor = this.sendProcessor;
        final UnicastProcessor receiver = UnicastProcessor.create();
        final AtomicInteger wip = new AtomicInteger(0);
        this.receivers.put(streamId, (Object)receiver);
        return receiver.doOnRequest(new LongConsumer(){
            boolean firstRequest = true;

            @Override
            public void accept(long n) {
                if (this.firstRequest) {
                    this.firstRequest = false;
                    if (wip.getAndIncrement() != 0) {
                        return;
                    }
                    int missed = 1;
                    boolean firstHasBeenSent = false;
                    do {
                        if (firstHasBeenSent) {
                            sendProcessor.onNext(CancelFrameFlyweight.encode(RSocketRequester.this.allocator, streamId));
                            return;
                        }
                        sendProcessor.onNext(RequestStreamFrameFlyweight.encodeReleasingPayload(RSocketRequester.this.allocator, streamId, n, payload));
                        firstHasBeenSent = true;
                    } while ((missed = wip.addAndGet(-missed)) != 0);
                    return;
                }
                if (!receiver.isDisposed()) {
                    sendProcessor.onNext(RequestNFrameFlyweight.encode(RSocketRequester.this.allocator, streamId, n));
                }
            }
        }).doOnCancel(() -> {
            if (wip.getAndIncrement() != 0) {
                return;
            }
            if (payload.refCnt() > 0) {
                payload.release();
            } else {
                sendProcessor.onNext(CancelFrameFlyweight.encode(this.allocator, streamId));
            }
        }).doFinally(s -> this.removeStreamReceiver(streamId)).doOnDiscard(ReferenceCounted.class, DROPPED_ELEMENTS_CONSUMER);
    }

    private Flux<Payload> handleChannel(Flux<Payload> request) {
        Throwable err = this.checkAvailable();
        if (err != null) {
            return Flux.error((Throwable)err);
        }
        return request.switchOnFirst((s, flux) -> {
            Payload payload = (Payload)s.get();
            if (payload != null) {
                if (!PayloadValidationUtils.isValid(this.mtu, payload)) {
                    payload.release();
                    IllegalArgumentException t = new IllegalArgumentException("The payload is too big to send as a single frame with a 24-bit encoded length. Consider enabling fragmentation via RSocketFactory.");
                    this.errorConsumer.accept(t);
                    return Mono.error((Throwable)t);
                }
                return this.handleChannel(payload, (Flux<Payload>)flux);
            }
            return flux;
        }, false).doOnDiscard(ReferenceCounted.class, DROPPED_ELEMENTS_CONSUMER);
    }

    private Flux<? extends Payload> handleChannel(final Payload initialPayload, Flux<Payload> inboundFlux) {
        final UnboundedProcessor<ByteBuf> sendProcessor = this.sendProcessor;
        final int streamId = this.streamIdSupplier.nextStreamId(this.receivers);
        final AtomicInteger wip = new AtomicInteger(0);
        final UnicastProcessor receiver = UnicastProcessor.create();
        BaseSubscriber<Payload> upstreamSubscriber = new BaseSubscriber<Payload>(){
            boolean first = true;

            protected void hookOnSubscribe(Subscription subscription) {
            }

            protected void hookOnNext(Payload payload) {
                if (this.first) {
                    this.first = false;
                    this.request(1L);
                    return;
                }
                if (!PayloadValidationUtils.isValid(RSocketRequester.this.mtu, payload)) {
                    payload.release();
                    this.cancel();
                    IllegalArgumentException t = new IllegalArgumentException("The payload is too big to send as a single frame with a 24-bit encoded length. Consider enabling fragmentation via RSocketFactory.");
                    RSocketRequester.this.errorConsumer.accept(t);
                    sendProcessor.onNext(CancelFrameFlyweight.encode(RSocketRequester.this.allocator, streamId));
                    receiver.onError((Throwable)t);
                    return;
                }
                ByteBuf frame = PayloadFrameFlyweight.encodeNextReleasingPayload(RSocketRequester.this.allocator, streamId, payload);
                sendProcessor.onNext(frame);
            }

            protected void hookOnComplete() {
                ByteBuf frame = PayloadFrameFlyweight.encodeComplete(RSocketRequester.this.allocator, streamId);
                sendProcessor.onNext(frame);
            }

            protected void hookOnError(Throwable t) {
                ByteBuf frame = ErrorFrameFlyweight.encode(RSocketRequester.this.allocator, streamId, t);
                sendProcessor.onNext(frame);
                receiver.onError(t);
            }

            protected void hookFinally(SignalType type) {
                RSocketRequester.this.senders.remove((Object)streamId, (Object)this);
            }
        };
        return receiver.doOnRequest(new LongConsumer((BaseSubscriber)upstreamSubscriber, receiver, inboundFlux, sendProcessor){
            boolean firstRequest = true;
            final /* synthetic */ BaseSubscriber val$upstreamSubscriber;
            final /* synthetic */ UnicastProcessor val$receiver;
            final /* synthetic */ Flux val$inboundFlux;
            final /* synthetic */ UnboundedProcessor val$sendProcessor;
            {
                this.val$upstreamSubscriber = baseSubscriber;
                this.val$receiver = unicastProcessor;
                this.val$inboundFlux = flux;
                this.val$sendProcessor = unboundedProcessor;
            }

            @Override
            public void accept(long n) {
                if (this.firstRequest) {
                    this.firstRequest = false;
                    if (wip.getAndIncrement() != 0) {
                        return;
                    }
                    int missed = 1;
                    boolean firstHasBeenSent = false;
                    do {
                        ByteBuf frame;
                        if (!firstHasBeenSent) {
                            try {
                                frame = RequestChannelFrameFlyweight.encodeReleasingPayload(RSocketRequester.this.allocator, streamId, false, n, initialPayload);
                            }
                            catch (IllegalReferenceCountException e) {
                                return;
                            }
                        } else {
                            RSocketRequester.this.senders.remove((Object)streamId, (Object)this.val$upstreamSubscriber);
                            RSocketRequester.this.receivers.remove((Object)streamId, (Object)this.val$receiver);
                            this.val$sendProcessor.onNext(CancelFrameFlyweight.encode(RSocketRequester.this.allocator, streamId));
                            return;
                        }
                        RSocketRequester.this.senders.put(streamId, (Object)this.val$upstreamSubscriber);
                        RSocketRequester.this.receivers.put(streamId, (Object)this.val$receiver);
                        this.val$inboundFlux.limitRate(Queues.SMALL_BUFFER_SIZE).doOnDiscard(ReferenceCounted.class, DROPPED_ELEMENTS_CONSUMER).subscribe((CoreSubscriber)this.val$upstreamSubscriber);
                        this.val$sendProcessor.onNext(frame);
                        firstHasBeenSent = true;
                    } while ((missed = wip.addAndGet(-missed)) != 0);
                    return;
                }
                this.val$sendProcessor.onNext(RequestNFrameFlyweight.encode(RSocketRequester.this.allocator, streamId, n));
            }
        }).doOnError(arg_0 -> this.lambda$handleChannel$6((BaseSubscriber)upstreamSubscriber, streamId, receiver, arg_0)).doOnComplete(() -> this.receivers.remove((Object)streamId, (Object)receiver)).doOnCancel(() -> this.lambda$handleChannel$8((BaseSubscriber)upstreamSubscriber, wip, streamId, receiver, sendProcessor));
    }

    private Mono<Void> handleMetadataPush(Payload payload) {
        Throwable err = this.terminationError;
        if (err != null) {
            payload.release();
            return Mono.error((Throwable)err);
        }
        if (!PayloadValidationUtils.isValid(this.mtu, payload)) {
            payload.release();
            return Mono.error((Throwable)new IllegalArgumentException("The payload is too big to send as a single frame with a 24-bit encoded length. Consider enabling fragmentation via RSocketFactory."));
        }
        return UnicastMonoEmpty.newInstance(() -> {
            ByteBuf metadataPushFrame = MetadataPushFrameFlyweight.encodeReleasingPayload(this.allocator, payload);
            this.sendProcessor.onNextPrioritized(metadataPushFrame);
        });
    }

    @Nullable
    private Throwable checkAvailable() {
        Throwable err = this.terminationError;
        if (err != null) {
            return err;
        }
        RequesterLeaseHandler lh = this.leaseHandler;
        if (!lh.useLease()) {
            return lh.leaseError();
        }
        return null;
    }

    private boolean contains(int streamId) {
        return this.receivers.containsKey(streamId);
    }

    private void handleIncomingFrames(ByteBuf frame) {
        try {
            int streamId = FrameHeaderFlyweight.streamId(frame);
            FrameType type = FrameHeaderFlyweight.frameType(frame);
            if (streamId == 0) {
                this.handleStreamZero(type, frame);
            } else {
                this.handleFrame(streamId, type, frame);
            }
            frame.release();
        }
        catch (Throwable t) {
            ReferenceCountUtil.safeRelease((Object)frame);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    private void handleStreamZero(FrameType type, ByteBuf frame) {
        switch (type) {
            case ERROR: {
                this.tryTerminateOnZeroError(frame);
                break;
            }
            case LEASE: {
                this.leaseHandler.receive(frame);
                break;
            }
            case KEEPALIVE: {
                if (this.keepAliveFramesAcceptor == null) break;
                this.keepAliveFramesAcceptor.receive(frame);
                break;
            }
            default: {
                this.errorConsumer.accept(new IllegalStateException("Client received supported frame on stream 0: " + frame.toString()));
            }
        }
    }

    private void handleFrame(int streamId, FrameType type, ByteBuf frame) {
        Subscriber receiver = (Subscriber)this.receivers.get(streamId);
        switch (type) {
            case NEXT: {
                if (receiver == null) {
                    this.handleMissingResponseProcessor(streamId, type, frame);
                    return;
                }
                receiver.onNext(this.payloadDecoder.apply(frame));
                break;
            }
            case NEXT_COMPLETE: {
                if (receiver == null) {
                    this.handleMissingResponseProcessor(streamId, type, frame);
                    return;
                }
                receiver.onNext(this.payloadDecoder.apply(frame));
                receiver.onComplete();
                break;
            }
            case COMPLETE: {
                if (receiver == null) {
                    this.handleMissingResponseProcessor(streamId, type, frame);
                    return;
                }
                receiver.onComplete();
                this.receivers.remove(streamId);
                break;
            }
            case ERROR: {
                if (receiver == null) {
                    this.handleMissingResponseProcessor(streamId, type, frame);
                    return;
                }
                receiver.onError((Throwable)io.rsocket.exceptions.Exceptions.from(streamId, frame));
                this.receivers.remove(streamId);
                break;
            }
            case CANCEL: {
                Subscription sender = (Subscription)this.senders.remove(streamId);
                if (sender == null) break;
                sender.cancel();
                break;
            }
            case REQUEST_N: {
                Subscription sender = (Subscription)this.senders.get(streamId);
                if (sender == null) break;
                long n = RequestNFrameFlyweight.requestN(frame);
                sender.request(n);
                break;
            }
            default: {
                throw new IllegalStateException("Client received supported frame on stream " + streamId + ": " + frame.toString());
            }
        }
    }

    private void handleMissingResponseProcessor(int streamId, FrameType type, ByteBuf frame) {
        if (!this.streamIdSupplier.isBeforeOrCurrent(streamId)) {
            if (type == FrameType.ERROR) {
                String errorMessage = ErrorFrameFlyweight.dataUtf8(frame);
                throw new IllegalStateException("Client received error for non-existent stream: " + streamId + " Message: " + errorMessage);
            }
            throw new IllegalStateException("Client received message for non-existent stream: " + streamId + ", frame type: " + (Object)((Object)type));
        }
    }

    private void tryTerminateOnKeepAlive(KeepAliveSupport.KeepAlive keepAlive) {
        this.tryTerminate(() -> new ConnectionErrorException(String.format("No keep-alive acks for %d ms", keepAlive.getTimeout().toMillis())));
    }

    private void tryTerminateOnConnectionError(Throwable e) {
        this.tryTerminate(() -> e);
    }

    private void tryTerminateOnConnectionClose() {
        this.tryTerminate(() -> CLOSED_CHANNEL_EXCEPTION);
    }

    private void tryTerminateOnZeroError(ByteBuf errorFrame) {
        this.tryTerminate(() -> io.rsocket.exceptions.Exceptions.from(0, errorFrame));
    }

    private void tryTerminate(Supplier<Throwable> errorSupplier) {
        Throwable e;
        if (this.terminationError == null && TERMINATION_ERROR.compareAndSet(this, null, e = errorSupplier.get())) {
            this.terminate(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate(Throwable e) {
        this.connection.dispose();
        this.leaseHandler.dispose();
        IntObjectMap<Processor<Payload, Payload>> intObjectMap = this.receivers;
        synchronized (intObjectMap) {
            this.receivers.values().forEach(receiver -> {
                try {
                    receiver.onError(e);
                }
                catch (Throwable t) {
                    this.errorConsumer.accept(t);
                }
            });
        }
        intObjectMap = this.senders;
        synchronized (intObjectMap) {
            this.senders.values().forEach(sender -> {
                try {
                    sender.cancel();
                }
                catch (Throwable t) {
                    this.errorConsumer.accept(t);
                }
            });
        }
        this.senders.clear();
        this.receivers.clear();
        this.sendProcessor.dispose();
        this.errorConsumer.accept(e);
        this.onClose.onError(e);
    }

    private void removeStreamReceiver(int streamId) {
        if (this.terminationError == null) {
            this.receivers.remove(streamId);
        }
    }

    private void handleSendProcessorError(Throwable t) {
        this.connection.dispose();
    }

    private /* synthetic */ void lambda$handleChannel$8(BaseSubscriber upstreamSubscriber, AtomicInteger wip, int streamId, UnicastProcessor receiver, UnboundedProcessor sendProcessor) {
        upstreamSubscriber.cancel();
        if (wip.getAndIncrement() != 0) {
            return;
        }
        if (this.receivers.remove((Object)streamId, (Object)receiver)) {
            sendProcessor.onNext(CancelFrameFlyweight.encode(this.allocator, streamId));
        }
    }

    private /* synthetic */ void lambda$handleChannel$6(BaseSubscriber upstreamSubscriber, int streamId, UnicastProcessor receiver, Throwable t) {
        upstreamSubscriber.cancel();
        this.receivers.remove((Object)streamId, (Object)receiver);
    }

    static {
        CLOSED_CHANNEL_EXCEPTION.setStackTrace(new StackTraceElement[0]);
    }
}

