/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.resume;

import io.netty.buffer.ByteBuf;
import io.rsocket.resume.RSocketSession;
import io.rsocket.resume.ServerRSocketSession;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class SessionManager {
    private volatile boolean isDisposed;
    private final Map<ByteBuf, ServerRSocketSession> sessions = new ConcurrentHashMap<ByteBuf, ServerRSocketSession>();

    public ServerRSocketSession save(ServerRSocketSession session) {
        if (this.isDisposed) {
            session.dispose();
        } else {
            ByteBuf token = session.token().retain();
            session.onClose().doOnSuccess(v -> {
                if (this.isDisposed || this.sessions.get(token) == session) {
                    this.sessions.remove(token);
                }
                token.release();
            }).subscribe();
            ServerRSocketSession prevSession = this.sessions.remove(token);
            if (prevSession != null) {
                prevSession.dispose();
            }
            this.sessions.put(token, session);
        }
        return session;
    }

    @Nullable
    public ServerRSocketSession get(ByteBuf resumeToken) {
        return this.sessions.get(resumeToken);
    }

    public void dispose() {
        this.isDisposed = true;
        this.sessions.values().forEach(RSocketSession::dispose);
    }
}

