/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.internal;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.stream.Stream;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;
import reactor.util.function.Tuple2;

public class UnicastMonoProcessor<O>
extends Mono<O>
implements Processor<O, O>,
CoreSubscriber<O>,
Disposable,
Subscription,
Scannable {
    static final AtomicIntegerFieldUpdater<UnicastMonoProcessor> ONCE = AtomicIntegerFieldUpdater.newUpdater(UnicastMonoProcessor.class, "once");
    private final MonoProcessor<O> processor = MonoProcessor.create();
    private volatile int once;

    private UnicastMonoProcessor() {
    }

    public static <O> UnicastMonoProcessor<O> create() {
        return new UnicastMonoProcessor<O>();
    }

    public Stream<? extends Scannable> actuals() {
        return this.processor.actuals();
    }

    public boolean isScanAvailable() {
        return this.processor.isScanAvailable();
    }

    public String name() {
        return this.processor.name();
    }

    public String stepName() {
        return this.processor.stepName();
    }

    public Stream<String> steps() {
        return this.processor.steps();
    }

    public Stream<? extends Scannable> parents() {
        return this.processor.parents();
    }

    @Nullable
    public <T> T scan(Scannable.Attr<T> key) {
        return (T)this.processor.scan(key);
    }

    public <T> T scanOrDefault(Scannable.Attr<T> key, T defaultValue) {
        return (T)this.processor.scanOrDefault(key, defaultValue);
    }

    public Stream<Tuple2<String, String>> tags() {
        return this.processor.tags();
    }

    public void onSubscribe(Subscription s) {
        this.processor.onSubscribe(s);
    }

    public void onNext(O o) {
        this.processor.onNext(o);
    }

    public void onError(Throwable t) {
        this.processor.onError(t);
    }

    @Nullable
    public Throwable getError() {
        return this.processor.getError();
    }

    public boolean isCancelled() {
        return this.processor.isCancelled();
    }

    public boolean isError() {
        return this.processor.isError();
    }

    public boolean isSuccess() {
        return this.processor.isSuccess();
    }

    public boolean isTerminated() {
        return this.processor.isTerminated();
    }

    @Nullable
    public O peek() {
        return (O)this.processor.peek();
    }

    public long downstreamCount() {
        return this.processor.downstreamCount();
    }

    public boolean hasDownstreams() {
        return this.processor.hasDownstreams();
    }

    public void onComplete() {
        this.processor.onComplete();
    }

    public void request(long n) {
        this.processor.request(n);
    }

    public void cancel() {
        this.processor.cancel();
    }

    public void dispose() {
        this.processor.dispose();
    }

    public Context currentContext() {
        return this.processor.currentContext();
    }

    public boolean isDisposed() {
        return this.processor.isDisposed();
    }

    public Object scanUnsafe(Scannable.Attr key) {
        return this.processor.scanUnsafe(key);
    }

    public void subscribe(CoreSubscriber<? super O> actual) {
        Objects.requireNonNull(actual, "subscribe");
        if (this.once == 0 && ONCE.compareAndSet(this, 0, 1)) {
            this.processor.subscribe(actual);
        } else {
            Operators.error(actual, (Throwable)new IllegalStateException("UnicastMonoProcessor allows only a single Subscriber"));
        }
    }
}

