/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.buffer;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

abstract class BufferUtil {
    private static final Unsafe UNSAFE;
    private static final long BYTE_BUFFER_ADDRESS_FIELD_OFFSET;

    static ByteBuffer allocateDirectAligned(int capacity, int alignment) {
        if (alignment == 0) {
            return ByteBuffer.allocateDirect(capacity);
        }
        if (!BufferUtil.isPowerOfTwo(alignment)) {
            throw new IllegalArgumentException("Must be a power of 2: alignment=" + alignment);
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(capacity + alignment);
        long address = UNSAFE.getLong(buffer, BYTE_BUFFER_ADDRESS_FIELD_OFFSET);
        int remainder = (int)(address & (long)(alignment - 1));
        int offset = alignment - remainder;
        buffer.limit(capacity + offset);
        buffer.position(offset);
        return buffer.slice();
    }

    private static boolean isPowerOfTwo(int value) {
        return value > 0 && (value & ~value + 1) == value;
    }

    private BufferUtil() {
    }

    static {
        Unsafe unsafe;
        try {
            PrivilegedExceptionAction<Unsafe> action = () -> {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                return (Unsafe)f.get(null);
            };
            unsafe = AccessController.doPrivileged(action);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        UNSAFE = unsafe;
        try {
            BYTE_BUFFER_ADDRESS_FIELD_OFFSET = UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("address"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

