/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.lease;

import io.rsocket.lease.Lease;
import io.rsocket.lease.LeaseStats;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.publisher.Flux;

public class Leases<T extends LeaseStats> {
    private static final Function<?, Flux<Lease>> noopLeaseSender = leaseStats -> Flux.never();
    private static final Consumer<Flux<Lease>> noopLeaseReceiver = leases -> {};
    private Function<?, Flux<Lease>> leaseSender = noopLeaseSender;
    private Consumer<Flux<Lease>> leaseReceiver = noopLeaseReceiver;
    private Optional<T> stats = Optional.empty();

    public static <T extends LeaseStats> Leases<T> create() {
        return new Leases<T>();
    }

    public Leases<T> sender(Function<Optional<T>, Flux<Lease>> leaseSender) {
        this.leaseSender = leaseSender;
        return this;
    }

    public Leases<T> receiver(Consumer<Flux<Lease>> leaseReceiver) {
        this.leaseReceiver = leaseReceiver;
        return this;
    }

    public Leases<T> stats(T stats) {
        this.stats = Optional.of(Objects.requireNonNull(stats));
        return this;
    }

    public Function<Optional<LeaseStats>, Flux<Lease>> sender() {
        return this.leaseSender;
    }

    public Consumer<Flux<Lease>> receiver() {
        return this.leaseReceiver;
    }

    public Optional<LeaseStats> stats() {
        return this.stats;
    }
}

