/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.frame.FrameType;

public final class FrameHeaderFlyweight {
    public static final int FLAGS_I = 512;
    public static final int FLAGS_M = 256;
    public static final int FLAGS_F = 128;
    public static final int FLAGS_C = 64;
    public static final int FLAGS_N = 32;
    public static final String DISABLE_FRAME_TYPE_CHECK = "io.rsocket.frames.disableFrameTypeCheck";
    private static final int FRAME_FLAGS_MASK = 1023;
    private static final int FRAME_TYPE_BITS = 6;
    private static final int FRAME_TYPE_SHIFT = 10;
    private static final int HEADER_SIZE = 6;
    private static boolean disableFrameTypeCheck = Boolean.getBoolean("io.rsocket.frames.disableFrameTypeCheck");

    private FrameHeaderFlyweight() {
    }

    static ByteBuf encodeStreamZero(ByteBufAllocator allocator, FrameType frameType, int flags) {
        return FrameHeaderFlyweight.encode(allocator, 0, frameType, flags);
    }

    public static ByteBuf encode(ByteBufAllocator allocator, int streamId, FrameType frameType, int flags) {
        if (!frameType.canHaveMetadata() && (flags & 0x100) == 256) {
            throw new IllegalStateException("bad value for metadata flag");
        }
        short typeAndFlags = (short)(frameType.getEncodedType() << 10 | (short)flags);
        return allocator.buffer().writeInt(streamId).writeShort((int)typeAndFlags);
    }

    public static boolean hasFollows(ByteBuf byteBuf) {
        return (FrameHeaderFlyweight.flags(byteBuf) & 0x80) == 128;
    }

    public static int streamId(ByteBuf byteBuf) {
        byteBuf.markReaderIndex();
        int streamId = byteBuf.readInt();
        byteBuf.resetReaderIndex();
        return streamId;
    }

    public static int flags(ByteBuf byteBuf) {
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(4);
        short typeAndFlags = byteBuf.readShort();
        byteBuf.resetReaderIndex();
        return typeAndFlags & 0x3FF;
    }

    public static boolean hasMetadata(ByteBuf byteBuf) {
        return (FrameHeaderFlyweight.flags(byteBuf) & 0x100) == 256;
    }

    public static FrameType nativeFrameType(ByteBuf byteBuf) {
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(4);
        int typeAndFlags = byteBuf.readShort() & 0xFFFF;
        FrameType result = FrameType.fromEncodedType(typeAndFlags >> 10);
        byteBuf.resetReaderIndex();
        return result;
    }

    public static FrameType frameType(ByteBuf byteBuf) {
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(4);
        int typeAndFlags = byteBuf.readShort() & 0xFFFF;
        FrameType result = FrameType.fromEncodedType(typeAndFlags >> 10);
        if (FrameType.PAYLOAD == result) {
            boolean next;
            int flags = typeAndFlags & 0x3FF;
            boolean complete = 64 == (flags & 0x40);
            boolean bl = next = 32 == (flags & 0x20);
            if (next && complete) {
                result = FrameType.NEXT_COMPLETE;
            } else if (complete) {
                result = FrameType.COMPLETE;
            } else if (next) {
                result = FrameType.NEXT;
            } else {
                throw new IllegalArgumentException("Payload must set either or both of NEXT and COMPLETE.");
            }
        }
        byteBuf.resetReaderIndex();
        return result;
    }

    public static void ensureFrameType(FrameType frameType, ByteBuf byteBuf) {
        FrameType typeInFrame;
        if (!disableFrameTypeCheck && (typeInFrame = FrameHeaderFlyweight.frameType(byteBuf)) != frameType) {
            throw new AssertionError((Object)("expected " + (Object)((Object)frameType) + ", but saw " + (Object)((Object)typeInFrame)));
        }
    }

    public static int size() {
        return 6;
    }
}

