/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.resume;

import java.util.Objects;

class ResumptionState {
    private final long pos;
    private final long impliedPos;

    ResumptionState(long pos, long impliedPos) {
        this.pos = pos;
        this.impliedPos = impliedPos;
    }

    public static ResumptionState fromServer(long impliedPos) {
        return new ResumptionState(-1L, impliedPos);
    }

    public static ResumptionState fromClient(long pos, long impliedPos) {
        return new ResumptionState(pos, impliedPos);
    }

    public boolean isServer() {
        return this.pos < 0L;
    }

    public long position() {
        return this.pos;
    }

    public long impliedPosition() {
        return this.impliedPos;
    }

    public String toString() {
        return "ResumptionState{pos=" + this.pos + ", impliedPos=" + this.impliedPos + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResumptionState that = (ResumptionState)o;
        return this.pos == that.pos && this.impliedPos == that.impliedPos;
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.impliedPos);
    }
}

