/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.rsocket.DuplexConnection;
import io.rsocket.keepalive.KeepAliveConnection;
import io.rsocket.resume.ClientRSocketSession;
import io.rsocket.resume.ResumableFramesStore;
import io.rsocket.resume.ResumeStrategy;
import java.time.Duration;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public interface ClientSetup {
    public DuplexConnection wrappedConnection(KeepAliveConnection var1);

    public ByteBuf resumeToken();

    public static class ResumableClientSetup
    implements ClientSetup {
        private final ByteBuf resumeToken;
        private final ByteBufAllocator allocator;
        private final Mono<KeepAliveConnection> newConnectionFactory;
        private final Duration resumeSessionDuration;
        private final Supplier<ResumeStrategy> resumeStrategySupplier;
        private final ResumableFramesStore resumableFramesStore;
        private final Duration resumeStreamTimeout;
        private final boolean cleanupStoreOnKeepAlive;

        public ResumableClientSetup(ByteBufAllocator allocator, Mono<KeepAliveConnection> newConnectionFactory, ByteBuf resumeToken, ResumableFramesStore resumableFramesStore, Duration resumeSessionDuration, Duration resumeStreamTimeout, Supplier<ResumeStrategy> resumeStrategySupplier, boolean cleanupStoreOnKeepAlive) {
            this.allocator = allocator;
            this.newConnectionFactory = newConnectionFactory;
            this.resumeToken = resumeToken;
            this.resumeSessionDuration = resumeSessionDuration;
            this.resumeStrategySupplier = resumeStrategySupplier;
            this.resumableFramesStore = resumableFramesStore;
            this.resumeStreamTimeout = resumeStreamTimeout;
            this.cleanupStoreOnKeepAlive = cleanupStoreOnKeepAlive;
        }

        @Override
        public DuplexConnection wrappedConnection(KeepAliveConnection connection) {
            ClientRSocketSession rSocketSession = new ClientRSocketSession(connection, this.allocator, this.resumeSessionDuration, this.resumeStrategySupplier, this.resumableFramesStore, this.resumeStreamTimeout, this.cleanupStoreOnKeepAlive).continueWith(this.newConnectionFactory).resumeToken(this.resumeToken);
            return rSocketSession.resumableConnection();
        }

        @Override
        public ByteBuf resumeToken() {
            return this.resumeToken;
        }
    }

    public static class DefaultClientSetup
    implements ClientSetup {
        @Override
        public DuplexConnection wrappedConnection(KeepAliveConnection connection) {
            return connection;
        }

        @Override
        public ByteBuf resumeToken() {
            return Unpooled.EMPTY_BUFFER;
        }
    }
}

