/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.fragmentation;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.DuplexConnection;
import io.rsocket.fragmentation.FrameFragmenter;
import io.rsocket.fragmentation.FrameReassembler;
import io.rsocket.frame.FrameHeaderFlyweight;
import io.rsocket.frame.FrameLengthFlyweight;
import io.rsocket.frame.FrameType;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;

public final class FragmentationDuplexConnection
implements DuplexConnection {
    private static final int MIN_MTU_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(FragmentationDuplexConnection.class);
    private final DuplexConnection delegate;
    private final int mtu;
    private final ByteBufAllocator allocator;
    private final FrameReassembler frameReassembler;
    private final boolean encodeLength;

    public FragmentationDuplexConnection(DuplexConnection delegate, ByteBufAllocator allocator, int mtu, boolean encodeLength) {
        Objects.requireNonNull(delegate, "delegate must not be null");
        Objects.requireNonNull(allocator, "byteBufAllocator must not be null");
        if (mtu < 64) {
            throw new IllegalArgumentException("smallest allowed mtu size is 64 bytes");
        }
        this.encodeLength = encodeLength;
        this.allocator = allocator;
        this.delegate = delegate;
        this.mtu = mtu;
        this.frameReassembler = new FrameReassembler(allocator);
        delegate.onClose().doFinally(s -> this.frameReassembler.dispose()).subscribe();
    }

    private boolean shouldFragment(FrameType frameType, int readableBytes) {
        return frameType.isFragmentable() && readableBytes > this.mtu;
    }

    @Override
    public Mono<Void> send(Publisher<ByteBuf> frames) {
        return Flux.from(frames).concatMap(this::sendOne).then();
    }

    @Override
    public Mono<Void> sendOne(ByteBuf frame) {
        int readableBytes;
        FrameType frameType = FrameHeaderFlyweight.frameType(frame);
        if (this.shouldFragment(frameType, readableBytes = frame.readableBytes())) {
            return this.delegate.send(FrameFragmenter.fragmentFrame(this.allocator, this.mtu, frame, frameType, this.encodeLength));
        }
        return this.delegate.sendOne(this.encode(frame));
    }

    private ByteBuf encode(ByteBuf frame) {
        if (this.encodeLength) {
            return FrameLengthFlyweight.encode(this.allocator, frame.readableBytes(), frame).retain();
        }
        return frame;
    }

    private ByteBuf decode(ByteBuf frame) {
        if (this.encodeLength) {
            return FrameLengthFlyweight.frame(frame).retain();
        }
        return frame;
    }

    @Override
    public Flux<ByteBuf> receive() {
        return this.delegate.receive().handle((byteBuf, sink) -> {
            ByteBuf decode = this.decode((ByteBuf)byteBuf);
            this.frameReassembler.reassembleFrame(decode, (SynchronousSink<ByteBuf>)sink);
        });
    }

    @Override
    public Mono<Void> onClose() {
        return this.delegate.onClose();
    }

    public void dispose() {
        this.delegate.dispose();
    }
}

