/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.resume;

import io.netty.buffer.ByteBuf;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;

class ResumeFramesSubscriber
implements Subscriber<ByteBuf>,
Disposable {
    private final Flux<Long> requests;
    private final Consumer<ByteBuf> onNext;
    private final Consumer<Throwable> onError;
    private final Runnable onComplete;
    private final AtomicBoolean disposed = new AtomicBoolean();
    private volatile Disposable requestsDisposable;
    private volatile Subscription subscription;

    public ResumeFramesSubscriber(Flux<Long> requests, Consumer<ByteBuf> onNext, Consumer<Throwable> onError, Runnable onComplete) {
        this.requests = requests;
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
    }

    public void onSubscribe(Subscription s) {
        if (this.isDisposed()) {
            s.cancel();
        } else {
            this.subscription = s;
            this.requestsDisposable = this.requests.subscribe(arg_0 -> ((Subscription)s).request(arg_0));
        }
    }

    public void onNext(ByteBuf frame) {
        this.onNext.accept(frame);
    }

    public void onError(Throwable t) {
        this.onError.accept(t);
        this.requestsDisposable.dispose();
    }

    public void onComplete() {
        this.onComplete.run();
        this.requestsDisposable.dispose();
    }

    public void dispose() {
        if (this.disposed.compareAndSet(false, true) && this.subscription != null) {
            this.subscription.cancel();
            this.requestsDisposable.dispose();
        }
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }
}

