/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.frame.FrameHeaderFlyweight;
import io.rsocket.frame.FrameType;

public class MetadataPushFrameFlyweight {
    public static ByteBuf encode(ByteBufAllocator allocator, ByteBuf metadata) {
        ByteBuf header = FrameHeaderFlyweight.encodeStreamZero(allocator, FrameType.METADATA_PUSH, 256);
        return allocator.compositeBuffer(2).addComponents(true, new ByteBuf[]{header, metadata});
    }

    public static ByteBuf metadata(ByteBuf byteBuf) {
        byteBuf.markReaderIndex();
        int headerSize = FrameHeaderFlyweight.size();
        int metadataLength = byteBuf.readableBytes() - headerSize;
        byteBuf.skipBytes(headerSize);
        ByteBuf metadata = byteBuf.readSlice(metadataLength);
        byteBuf.resetReaderIndex();
        return metadata;
    }
}

