/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.rsocket.framing.Frame;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import reactor.util.annotation.Nullable;

public interface MetadataFrame
extends Frame {
    default public Optional<String> getMetadataAsUtf8() {
        return Optional.ofNullable(this.getUnsafeMetadataAsUtf8());
    }

    default public Optional<Integer> getMetadataLength() {
        return Optional.ofNullable(this.getUnsafeMetadataLength());
    }

    @Nullable
    public ByteBuf getUnsafeMetadata();

    @Nullable
    default public String getUnsafeMetadataAsUtf8() {
        ByteBuf byteBuf = this.getUnsafeMetadata();
        return byteBuf == null ? null : byteBuf.toString(StandardCharsets.UTF_8);
    }

    @Nullable
    default public Integer getUnsafeMetadataLength() {
        ByteBuf byteBuf = this.getUnsafeMetadata();
        return byteBuf == null ? null : Integer.valueOf(byteBuf.readableBytes());
    }

    default public <T> Optional<T> mapMetadata(Function<ByteBuf, T> function) {
        Objects.requireNonNull(function, "function must not be null");
        return Optional.ofNullable(this.getUnsafeMetadata()).map(function);
    }
}

