/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.Recycler;
import io.rsocket.framing.AbstractRecyclableFrame;
import io.rsocket.framing.LengthUtils;
import io.rsocket.framing.MetadataAndDataFrame;
import java.util.Objects;
import reactor.util.annotation.Nullable;

abstract class AbstractRecyclableMetadataAndDataFrame<SELF extends AbstractRecyclableMetadataAndDataFrame<SELF>>
extends AbstractRecyclableFrame<SELF>
implements MetadataAndDataFrame {
    private static final int FLAG_METADATA = 256;

    AbstractRecyclableMetadataAndDataFrame(Recycler.Handle<SELF> handle) {
        super(handle);
    }

    static ByteBuf appendData(ByteBuf byteBuf, @Nullable ByteBuf data) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        if (data == null) {
            return byteBuf;
        }
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{byteBuf, data.retain()});
    }

    static ByteBuf appendMetadata(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, @Nullable ByteBuf metadata) {
        Objects.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        if (metadata == null) {
            return byteBuf.writeMedium(0);
        }
        ByteBuf frame = AbstractRecyclableMetadataAndDataFrame.setFlag(byteBuf, 256).writeMedium(LengthUtils.getLengthAsUnsignedMedium(metadata));
        frame = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{frame, metadata.retain(), byteBufAllocator.buffer()});
        return frame;
    }

    final ByteBuf getData(int metadataLengthOffset) {
        int dataOffset = this.getDataOffset(metadataLengthOffset);
        ByteBuf byteBuf = this.getByteBuf();
        return byteBuf.slice(dataOffset, byteBuf.readableBytes() - dataOffset).asReadOnly();
    }

    @Nullable
    final ByteBuf getMetadata(int metadataLengthOffset) {
        if (!this.isFlagSet(256)) {
            return null;
        }
        ByteBuf byteBuf = this.getByteBuf();
        return byteBuf.slice(AbstractRecyclableMetadataAndDataFrame.getMetadataOffset(metadataLengthOffset), this.getMetadataLength(metadataLengthOffset)).asReadOnly();
    }

    private static int getMetadataOffset(int metadataLengthOffset) {
        return metadataLengthOffset + 3;
    }

    private int getDataOffset(int metadataLengthOffset) {
        return AbstractRecyclableMetadataAndDataFrame.getMetadataOffset(metadataLengthOffset) + this.getMetadataLength(metadataLengthOffset);
    }

    private int getMetadataLength(int metadataLengthOffset) {
        return this.getByteBuf().getUnsignedMedium(metadataLengthOffset);
    }
}

