/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.framing.AbstractRecyclableFragmentableFrame;
import io.rsocket.framing.FrameType;
import io.rsocket.util.RecyclerFactory;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class RequestResponseFrame
extends AbstractRecyclableFragmentableFrame<RequestResponseFrame> {
    private static final int OFFSET_METADATA_LENGTH = 2;
    private static final Recycler<RequestResponseFrame> RECYCLER = RecyclerFactory.createRecycler(RequestResponseFrame::new);

    private RequestResponseFrame(Recycler.Handle<RequestResponseFrame> handle) {
        super(handle);
    }

    public static RequestResponseFrame createRequestResponseFrame(ByteBuf byteBuf) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        return (RequestResponseFrame)((RequestResponseFrame)RECYCLER.get()).setByteBuf(byteBuf.retain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestResponseFrame createRequestResponseFrame(ByteBufAllocator byteBufAllocator, boolean follows, @Nullable String metadata, @Nullable String data) {
        ByteBuf metadataByteBuf = RequestResponseFrame.getUtf8AsByteBuf(metadata);
        ByteBuf dataByteBuf = RequestResponseFrame.getUtf8AsByteBuf(data);
        try {
            RequestResponseFrame requestResponseFrame = RequestResponseFrame.createRequestResponseFrame(byteBufAllocator, follows, metadataByteBuf, dataByteBuf);
            return requestResponseFrame;
        }
        finally {
            ReferenceCountUtil.release((Object)metadataByteBuf);
            ReferenceCountUtil.release((Object)dataByteBuf);
        }
    }

    public static RequestResponseFrame createRequestResponseFrame(ByteBufAllocator byteBufAllocator, boolean follows, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
        ByteBuf byteBuf = RequestResponseFrame.createFrameTypeAndFlags(byteBufAllocator, FrameType.REQUEST_RESPONSE);
        if (follows) {
            byteBuf = RequestResponseFrame.setFollowsFlag(byteBuf);
        }
        byteBuf = RequestResponseFrame.appendMetadata(byteBufAllocator, byteBuf, metadata);
        byteBuf = RequestResponseFrame.appendData(byteBuf, data);
        return (RequestResponseFrame)((RequestResponseFrame)RECYCLER.get()).setByteBuf(byteBuf);
    }

    @Override
    public RequestResponseFrame createFragment(ByteBufAllocator byteBufAllocator, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
        return RequestResponseFrame.createRequestResponseFrame(byteBufAllocator, true, metadata, data);
    }

    @Override
    public RequestResponseFrame createNonFragment(ByteBufAllocator byteBufAllocator, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
        return RequestResponseFrame.createRequestResponseFrame(byteBufAllocator, false, metadata, data);
    }

    @Override
    public ByteBuf getUnsafeData() {
        return this.getData(2);
    }

    @Override
    @Nullable
    public ByteBuf getUnsafeMetadata() {
        return this.getMetadata(2);
    }

    public String toString() {
        return "RequestResponseFrame{follows=" + this.isFollowsFlagSet() + ", metadata=" + this.mapMetadata(ByteBufUtil::hexDump) + ", data=" + (String)this.mapData(ByteBufUtil::hexDump) + '}';
    }
}

