/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;

public class LimitableRequestPublisher<T>
extends Flux<T>
implements Subscription {
    private final Publisher<T> source;
    private final AtomicBoolean canceled;
    private final long prefetch;
    private long internalRequested;
    private long externalRequested;
    private volatile boolean subscribed;
    @Nullable
    private volatile Subscription internalSubscription;

    private LimitableRequestPublisher(Publisher<T> source, long prefetch) {
        this.source = source;
        this.prefetch = prefetch;
        this.canceled = new AtomicBoolean();
    }

    public static <T> LimitableRequestPublisher<T> wrap(Publisher<T> source, long prefetch) {
        return new LimitableRequestPublisher<T>(source, prefetch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(CoreSubscriber<? super T> destination) {
        LimitableRequestPublisher limitableRequestPublisher = this;
        synchronized (limitableRequestPublisher) {
            if (this.subscribed) {
                throw new IllegalStateException("only one subscriber at a time");
            }
            this.subscribed = true;
        }
        destination.onSubscribe((Subscription)new InnerSubscription());
        this.source.subscribe((Subscriber)new InnerSubscriber((Subscriber)destination));
        this.increaseInternalLimit(this.prefetch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseRequestLimit(long n) {
        LimitableRequestPublisher limitableRequestPublisher = this;
        synchronized (limitableRequestPublisher) {
            this.externalRequested = Operators.addCap((long)n, (long)this.externalRequested);
        }
        this.requestN();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseInternalLimit(long n) {
        LimitableRequestPublisher limitableRequestPublisher = this;
        synchronized (limitableRequestPublisher) {
            this.internalRequested = Operators.addCap((long)n, (long)this.internalRequested);
        }
        this.requestN();
    }

    public void request(long n) {
        this.increaseRequestLimit(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestN() {
        long r;
        LimitableRequestPublisher limitableRequestPublisher = this;
        synchronized (limitableRequestPublisher) {
            if (this.internalSubscription == null) {
                return;
            }
            if (this.externalRequested != Long.MAX_VALUE || this.internalRequested != Long.MAX_VALUE) {
                r = Math.min(this.internalRequested, this.externalRequested);
                if (this.externalRequested != Long.MAX_VALUE) {
                    this.externalRequested -= r;
                }
                if (this.internalRequested != Long.MAX_VALUE) {
                    this.internalRequested -= r;
                }
            } else {
                r = Long.MAX_VALUE;
            }
        }
        if (r > 0L) {
            this.internalSubscription.request(r);
        }
    }

    public void cancel() {
        if (this.canceled.compareAndSet(false, true) && this.internalSubscription != null) {
            this.internalSubscription.cancel();
            this.internalSubscription = null;
            this.subscribed = false;
        }
    }

    private class InnerSubscription
    implements Subscription {
        private InnerSubscription() {
        }

        public void request(long n) {
        }

        public void cancel() {
            LimitableRequestPublisher.this.cancel();
        }
    }

    private class InnerSubscriber
    implements Subscriber<T> {
        Subscriber<? super T> destination;

        private InnerSubscriber(Subscriber<? super T> destination) {
            this.destination = destination;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSubscribe(Subscription s) {
            LimitableRequestPublisher limitableRequestPublisher = LimitableRequestPublisher.this;
            synchronized (limitableRequestPublisher) {
                LimitableRequestPublisher.this.internalSubscription = s;
                if (LimitableRequestPublisher.this.canceled.get()) {
                    s.cancel();
                    LimitableRequestPublisher.this.subscribed = false;
                    LimitableRequestPublisher.this.internalSubscription = null;
                }
            }
            LimitableRequestPublisher.this.requestN();
        }

        public void onNext(T t) {
            try {
                this.destination.onNext(t);
            }
            catch (Throwable e) {
                this.onError(e);
            }
        }

        public void onError(Throwable t) {
            this.destination.onError(t);
        }

        public void onComplete() {
            this.destination.onComplete();
        }
    }
}

