/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.rsocket.exceptions.RSocketException;
import io.rsocket.frame.FrameHeaderFlyweight;
import io.rsocket.framing.FrameType;
import java.nio.charset.StandardCharsets;

public class ErrorFrameFlyweight {
    public static final int INVALID_SETUP = 1;
    public static final int UNSUPPORTED_SETUP = 2;
    public static final int REJECTED_SETUP = 3;
    public static final int REJECTED_RESUME = 4;
    public static final int CONNECTION_ERROR = 257;
    public static final int CONNECTION_CLOSE = 258;
    public static final int APPLICATION_ERROR = 513;
    public static final int REJECTED = 514;
    public static final int CANCELED = 515;
    public static final int INVALID = 516;
    private static final int ERROR_CODE_FIELD_OFFSET = FrameHeaderFlyweight.FRAME_HEADER_LENGTH;
    private static final int PAYLOAD_OFFSET = ERROR_CODE_FIELD_OFFSET + 4;

    private ErrorFrameFlyweight() {
    }

    public static int computeFrameLength(int dataLength) {
        int length = FrameHeaderFlyweight.computeFrameHeaderLength(FrameType.ERROR, null, dataLength);
        return length + 4;
    }

    public static int encode(ByteBuf byteBuf, int streamId, int errorCode, ByteBuf data) {
        int frameLength = ErrorFrameFlyweight.computeFrameLength(data.readableBytes());
        int length = FrameHeaderFlyweight.encodeFrameHeader(byteBuf, frameLength, 0, FrameType.ERROR, streamId);
        byteBuf.setInt(ERROR_CODE_FIELD_OFFSET, errorCode);
        length += 4;
        length += FrameHeaderFlyweight.encodeData(byteBuf, length, data);
        return length;
    }

    public static int errorCodeFromException(Throwable ex) {
        if (ex instanceof RSocketException) {
            return ((RSocketException)ex).errorCode();
        }
        return 513;
    }

    public static int errorCode(ByteBuf byteBuf) {
        return byteBuf.getInt(ERROR_CODE_FIELD_OFFSET);
    }

    public static int payloadOffset(ByteBuf byteBuf) {
        return FrameHeaderFlyweight.FRAME_HEADER_LENGTH + 4;
    }

    public static String message(ByteBuf content) {
        return FrameHeaderFlyweight.sliceFrameData(content).toString(StandardCharsets.UTF_8);
    }
}

