/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.plugins;

import io.rsocket.DuplexConnection;
import io.rsocket.RSocket;
import io.rsocket.plugins.DuplexConnectionInterceptor;
import io.rsocket.plugins.RSocketInterceptor;
import java.util.ArrayList;
import java.util.List;

public class PluginRegistry {
    private List<DuplexConnectionInterceptor> connections = new ArrayList<DuplexConnectionInterceptor>();
    private List<RSocketInterceptor> clients = new ArrayList<RSocketInterceptor>();
    private List<RSocketInterceptor> servers = new ArrayList<RSocketInterceptor>();

    public PluginRegistry() {
    }

    public PluginRegistry(PluginRegistry defaults) {
        this.connections.addAll(defaults.connections);
        this.clients.addAll(defaults.clients);
        this.servers.addAll(defaults.servers);
    }

    public void addConnectionPlugin(DuplexConnectionInterceptor interceptor) {
        this.connections.add(interceptor);
    }

    public void addClientPlugin(RSocketInterceptor interceptor) {
        this.clients.add(interceptor);
    }

    public void addServerPlugin(RSocketInterceptor interceptor) {
        this.servers.add(interceptor);
    }

    public RSocket applyClient(RSocket rSocket) {
        for (RSocketInterceptor i : this.clients) {
            rSocket = (RSocket)i.apply(rSocket);
        }
        return rSocket;
    }

    public RSocket applyServer(RSocket rSocket) {
        for (RSocketInterceptor i : this.servers) {
            rSocket = (RSocket)i.apply(rSocket);
        }
        return rSocket;
    }

    public DuplexConnection applyConnection(DuplexConnectionInterceptor.Type type, DuplexConnection connection) {
        for (DuplexConnectionInterceptor i : this.connections) {
            connection = (DuplexConnection)i.apply(type, connection);
        }
        return connection;
    }
}

