/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.rsocket.framing.FrameType;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.Disposable;

public interface Frame
extends Disposable {
    public static final int FRAME_TYPE_SHIFT = 10;

    default public void consumeFrame(Consumer<ByteBuf> consumer) {
        Objects.requireNonNull(consumer, "consumer must not be null");
        consumer.accept(this.getUnsafeFrame());
    }

    public FrameType getFrameType();

    public ByteBuf getUnsafeFrame();

    default public <T> T mapFrame(Function<ByteBuf, T> function) {
        Objects.requireNonNull(function, "function must not be null");
        return function.apply(this.getUnsafeFrame());
    }
}

