/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.webtestclient.internal;

import io.restassured.config.EncoderConfig;
import io.restassured.config.HeaderConfig;
import io.restassured.config.LogConfig;
import io.restassured.config.MultiPartConfig;
import io.restassured.config.ObjectMapperConfig;
import io.restassured.config.ParamConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.filter.log.RequestLoggingFilter;
import io.restassured.http.ContentType;
import io.restassured.http.Cookie;
import io.restassured.http.Cookies;
import io.restassured.http.Header;
import io.restassured.http.Headers;
import io.restassured.http.Method;
import io.restassured.internal.MapCreator;
import io.restassured.internal.common.assertion.AssertParameter;
import io.restassured.internal.log.LogRepository;
import io.restassured.internal.mapping.ObjectMapping;
import io.restassured.internal.multipart.MultiPartInternal;
import io.restassured.internal.support.ParameterUpdater;
import io.restassured.mapper.ObjectMapper;
import io.restassured.mapper.ObjectMapperType;
import io.restassured.module.spring.commons.BodyHelper;
import io.restassured.module.spring.commons.CookieHelper;
import io.restassured.module.spring.commons.HeaderHelper;
import io.restassured.module.spring.commons.Serializer;
import io.restassured.module.spring.commons.config.AsyncConfig;
import io.restassured.module.spring.commons.config.ConfigConverter;
import io.restassured.module.spring.commons.config.ConfigMergeUtils;
import io.restassured.module.spring.commons.config.SpecificationConfig;
import io.restassured.module.webtestclient.config.RestAssuredWebTestClientConfig;
import io.restassured.module.webtestclient.config.WebTestClientParamConfig;
import io.restassured.module.webtestclient.internal.BuilderBasedWebTestClientFactory;
import io.restassured.module.webtestclient.internal.StandaloneWebTestClientFactory;
import io.restassured.module.webtestclient.internal.WebTestClientFactory;
import io.restassured.module.webtestclient.internal.WebTestClientRequestLogSpecificationImpl;
import io.restassured.module.webtestclient.internal.WebTestClientRequestSenderImpl;
import io.restassured.module.webtestclient.internal.WrapperWebTestClientFactory;
import io.restassured.module.webtestclient.response.WebTestClientResponse;
import io.restassured.module.webtestclient.specification.WebTestClientRequestLogSpecification;
import io.restassured.module.webtestclient.specification.WebTestClientRequestSender;
import io.restassured.module.webtestclient.specification.WebTestClientRequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.test.web.reactive.server.EntityExchangeResult;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.reactive.server.WebTestClientConfigurer;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.util.UriBuilder;

public class WebTestClientRequestSpecificationImpl
implements WebTestClientRequestSpecification {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String ACCEPT = "Accept";
    private final Map<String, Object> params = new LinkedHashMap<String, Object>();
    private final Map<String, Object> namedPathParams = new LinkedHashMap<String, Object>();
    private final Map<String, Object> queryParams = new LinkedHashMap<String, Object>();
    private final Map<String, Object> formParams = new LinkedHashMap<String, Object>();
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private final ResponseSpecification responseSpecification;
    private RestAssuredWebTestClientConfig config;
    private Object requestBody = null;
    private LogRepository logRepository;
    private WebTestClientFactory webTestClientFactory;
    private final ParameterUpdater parameterUpdater = new ParameterUpdater(this::serializeIfNeeded);
    private Headers requestHeaders = new Headers(new Header[0]);
    private String basePath;
    private RequestLoggingFilter requestLoggingFilter;
    private List<MultiPartInternal> multiParts = new ArrayList<MultiPartInternal>();
    private Cookies cookies = new Cookies(new Cookie[0]);
    private AsyncConfig asyncConfig;

    public WebTestClientRequestSpecificationImpl(WebTestClientFactory webTestClientFactory, RestAssuredWebTestClientConfig config, String basePath, WebTestClientRequestSpecification requestSpecification, ResponseSpecification responseSpecification) {
        this.logRepository = new LogRepository();
        this.basePath = basePath;
        this.responseSpecification = responseSpecification;
        this.assignConfig(config);
        WebTestClientFactory webTestClientFactory2 = this.webTestClientFactory = webTestClientFactory == null ? new BuilderBasedWebTestClientFactory(null) : webTestClientFactory;
        if (requestSpecification != null) {
            this.spec(requestSpecification);
        }
    }

    private void assignConfig(RestAssuredWebTestClientConfig config) {
        this.config = config == null ? new RestAssuredWebTestClientConfig() : config;
    }

    @Override
    public WebTestClientRequestSpecification contentType(ContentType contentType) {
        AssertParameter.notNull((Object)contentType, (String)"contentType");
        return this.header(CONTENT_TYPE, contentType.toString(), new Object[0]);
    }

    @Override
    public WebTestClientRequestSpecification contentType(MediaType mediaType) {
        AssertParameter.notNull((Object)mediaType, (String)"mediaType");
        return this.header(CONTENT_TYPE, mediaType.toString(), new Object[0]);
    }

    @Override
    public WebTestClientRequestSpecification contentType(String contentType) {
        AssertParameter.notNull((Object)contentType, (String)"contentType");
        return this.header(CONTENT_TYPE, contentType, new Object[0]);
    }

    @Override
    public WebTestClientRequestSpecification accept(ContentType contentType) {
        AssertParameter.notNull((Object)contentType, (String)"contentType");
        return this.header(ACCEPT, contentType.getAcceptHeader(), new Object[0]);
    }

    @Override
    public WebTestClientRequestSpecification accept(MediaType ... mediaTypes) {
        AssertParameter.notNull((Object)mediaTypes, (String)"mediaTypes");
        return this.header(ACCEPT, MediaType.toString(Arrays.asList(mediaTypes)), new Object[0]);
    }

    @Override
    public WebTestClientRequestSpecification accept(String mediaTypes) {
        AssertParameter.notNull((Object)mediaTypes, (String)"mediaTypes");
        return this.header(ACCEPT, mediaTypes, new Object[0]);
    }

    @Override
    public WebTestClientRequestSpecification headers(String firstHeaderName, Object firstHeaderValue, Object ... headerNameValuePairs) {
        return this.headers(MapCreator.createMapFromParams((MapCreator.CollisionStrategy)MapCreator.CollisionStrategy.MERGE, (String)firstHeaderName, (Object)firstHeaderValue, (Object[])headerNameValuePairs));
    }

    @Override
    public WebTestClientRequestSpecification headers(Map<String, ?> headers) {
        AssertParameter.notNull(headers, (String)"headers");
        this.requestHeaders = HeaderHelper.headers((Headers)this.requestHeaders, headers, (SpecificationConfig)this.config);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification headers(Headers headers) {
        AssertParameter.notNull((Object)headers, (String)"Headers");
        this.requestHeaders = HeaderHelper.headers((Headers)this.requestHeaders, (Headers)headers, (HeaderConfig)this.config.getHeaderConfig());
        return this;
    }

    @Override
    public WebTestClientRequestSpecification header(String headerName, Object headerValue, Object ... additionalHeaderValues) {
        AssertParameter.notNull((Object)headerName, (String)"Header name");
        AssertParameter.notNull((Object)headerValue, (String)"Header value");
        return this.headers(HeaderHelper.headers((Headers)this.requestHeaders, (String)headerName, (Object)headerValue, (SpecificationConfig)this.config, (Object[])additionalHeaderValues));
    }

    @Override
    public WebTestClientRequestSpecification header(Header header) {
        AssertParameter.notNull((Object)header, (String)"Header");
        return this.headers(new Headers(Collections.singletonList(header)));
    }

    @Override
    public WebTestClientRequestLogSpecification log() {
        return new WebTestClientRequestLogSpecificationImpl(this);
    }

    @Override
    public WebTestClientRequestSpecification params(String firstParameterName, Object firstParameterValue, Object ... parameterNameValuePairs) {
        AssertParameter.notNull((Object)firstParameterName, (String)"firstParameterName");
        AssertParameter.notNull((Object)firstParameterValue, (String)"firstParameterValue");
        return this.params(MapCreator.createMapFromParams((MapCreator.CollisionStrategy)MapCreator.CollisionStrategy.OVERWRITE, (String)firstParameterName, (Object)firstParameterValue, (Object[])parameterNameValuePairs));
    }

    @Override
    public WebTestClientRequestSpecification params(Map<String, ?> parametersMap) {
        AssertParameter.notNull(parametersMap, (String)"parametersMap");
        this.parameterUpdater.updateParameters(WebTestClientRequestSpecificationImpl.convert(this.config.getParamConfig().requestParamsUpdateStrategy()), parametersMap, this.params);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification param(String parameterName, Object ... parameterValues) {
        AssertParameter.notNull((Object)parameterName, (String)"parameterName");
        this.parameterUpdater.updateZeroToManyParameters(WebTestClientRequestSpecificationImpl.convert(this.config.getParamConfig().requestParamsUpdateStrategy()), this.params, parameterName, parameterValues);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification param(String parameterName, Collection<?> parameterValues) {
        AssertParameter.notNull((Object)parameterName, (String)"parameterName");
        AssertParameter.notNull(parameterValues, (String)"parameterValues");
        this.parameterUpdater.updateCollectionParameter(WebTestClientRequestSpecificationImpl.convert(this.config.getParamConfig().requestParamsUpdateStrategy()), this.params, parameterName, parameterValues);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification queryParams(String firstParameterName, Object firstParameterValue, Object ... parameterNameValuePairs) {
        AssertParameter.notNull((Object)firstParameterName, (String)"firstParameterName");
        AssertParameter.notNull((Object)firstParameterValue, (String)"firstParameterValue");
        return this.queryParams(MapCreator.createMapFromParams((MapCreator.CollisionStrategy)MapCreator.CollisionStrategy.OVERWRITE, (String)firstParameterName, (Object)firstParameterValue, (Object[])parameterNameValuePairs));
    }

    @Override
    public WebTestClientRequestSpecification queryParams(Map<String, ?> parametersMap) {
        AssertParameter.notNull(parametersMap, (String)"parametersMap");
        this.parameterUpdater.updateParameters(WebTestClientRequestSpecificationImpl.convert(this.config.getParamConfig().queryParamsUpdateStrategy()), parametersMap, this.queryParams);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification queryParam(String parameterName, Object ... parameterValues) {
        AssertParameter.notNull((Object)parameterName, (String)"parameterName");
        this.parameterUpdater.updateZeroToManyParameters(WebTestClientRequestSpecificationImpl.convert(this.config.getParamConfig().queryParamsUpdateStrategy()), this.queryParams, parameterName, parameterValues);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification queryParam(String parameterName, Collection<?> parameterValues) {
        AssertParameter.notNull((Object)parameterName, (String)"parameterName");
        AssertParameter.notNull(parameterValues, (String)"parameterValues");
        this.parameterUpdater.updateCollectionParameter(WebTestClientRequestSpecificationImpl.convert(this.config.getParamConfig().queryParamsUpdateStrategy()), this.queryParams, parameterName, parameterValues);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification pathParams(String firstParameterName, Object firstParameterValue, Object ... parameterNameValuePairs) {
        AssertParameter.notNull((Object)firstParameterName, (String)"firstParameterName");
        AssertParameter.notNull((Object)firstParameterValue, (String)"firstParameterValue");
        return this.pathParams(MapCreator.createMapFromParams((MapCreator.CollisionStrategy)MapCreator.CollisionStrategy.OVERWRITE, (String)firstParameterName, (Object)firstParameterValue, (Object[])parameterNameValuePairs));
    }

    @Override
    public WebTestClientRequestSpecification pathParams(Map<String, Object> parametersMap) {
        AssertParameter.notNull(parametersMap, (String)"parametersMap");
        this.parameterUpdater.updateParameters(WebTestClientRequestSpecificationImpl.convert(this.config.getParamConfig().pathParamsUpdateStrategy()), parametersMap, this.namedPathParams);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification pathParam(String parameterName, Object parameterValue) {
        AssertParameter.notNull((Object)parameterName, (String)"parameterName");
        AssertParameter.notNull((Object)parameterValue, (String)"parameterValue");
        this.parameterUpdater.updateStandardParameter(WebTestClientRequestSpecificationImpl.convert(this.config.getParamConfig().pathParamsUpdateStrategy()), this.namedPathParams, parameterName, parameterValue);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification formParams(String firstParameterName, Object firstParameterValue, Object ... parameterNameValuePairs) {
        AssertParameter.notNull((Object)firstParameterName, (String)"firstParameterName");
        AssertParameter.notNull((Object)firstParameterValue, (String)"firstParameterValue");
        return this.formParams(MapCreator.createMapFromParams((MapCreator.CollisionStrategy)MapCreator.CollisionStrategy.OVERWRITE, (String)firstParameterName, (Object)firstParameterValue, (Object[])parameterNameValuePairs));
    }

    @Override
    public WebTestClientRequestSpecification formParams(Map<String, ?> parametersMap) {
        AssertParameter.notNull(parametersMap, (String)"parametersMap");
        this.parameterUpdater.updateParameters(WebTestClientRequestSpecificationImpl.convert(this.config.getParamConfig().formParamsUpdateStrategy()), parametersMap, this.formParams);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification formParam(String parameterName, Object ... parameterValues) {
        AssertParameter.notNull((Object)parameterName, (String)"parameterName");
        this.parameterUpdater.updateZeroToManyParameters(WebTestClientRequestSpecificationImpl.convert(this.config.getParamConfig().formParamsUpdateStrategy()), this.formParams, parameterName, parameterValues);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification formParam(String parameterName, Collection<?> parameterValues) {
        AssertParameter.notNull((Object)parameterName, (String)"parameterName");
        AssertParameter.notNull(parameterValues, (String)"parameterValues");
        this.parameterUpdater.updateCollectionParameter(WebTestClientRequestSpecificationImpl.convert(this.config.getParamConfig().formParamsUpdateStrategy()), this.formParams, parameterName, parameterValues);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification attribute(String attributeName, Object attributeValue) {
        AssertParameter.notNull((Object)attributeName, (String)"attributeName");
        AssertParameter.notNull((Object)attributeValue, (String)"attributeValue");
        ParamConfig paramConfig = this.config.getParamConfig();
        this.parameterUpdater.updateZeroToManyParameters(WebTestClientRequestSpecificationImpl.convert(WebTestClientRequestSpecificationImpl.toWebTestClientParamConfig(paramConfig).attributeUpdateStrategy()), this.attributes, attributeName, new Object[]{attributeValue});
        return this;
    }

    @Override
    public WebTestClientRequestSpecification attributes(Map<String, ?> attributesMap) {
        AssertParameter.notNull(attributesMap, (String)"attributesMap");
        this.parameterUpdater.updateParameters(WebTestClientRequestSpecificationImpl.convert(WebTestClientRequestSpecificationImpl.toWebTestClientParamConfig(this.config.getParamConfig()).attributeUpdateStrategy()), attributesMap, this.attributes);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification body(String body) {
        this.requestBody = body;
        return this;
    }

    @Override
    public WebTestClientRequestSpecification body(byte[] body) {
        this.requestBody = body;
        return this;
    }

    @Override
    public WebTestClientRequestSpecification body(File body) {
        this.requestBody = body;
        return this;
    }

    @Override
    public WebTestClientRequestSpecification body(Object object) {
        AssertParameter.notNull((Object)object, (String)"object");
        this.requestBody = BodyHelper.toStringBody((Object)object, (SpecificationConfig)this.config, (Headers)this.requestHeaders);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification body(Object object, ObjectMapper mapper) {
        AssertParameter.notNull((Object)object, (String)"object");
        AssertParameter.notNull((Object)mapper, (String)"Object mapper");
        this.requestBody = BodyHelper.toSerializedBody((Object)object, (ObjectMapper)mapper, (SpecificationConfig)this.config, (Headers)this.requestHeaders);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification body(Object object, ObjectMapperType mapperType) {
        AssertParameter.notNull((Object)object, (String)"object");
        AssertParameter.notNull((Object)mapperType, (String)"Object mapper type");
        String requestContentType = this.getRequestContentType();
        this.requestBody = ObjectMapping.serialize((Object)object, (String)requestContentType, (String)Serializer.findEncoderCharsetOrReturnDefault((String)requestContentType, (SpecificationConfig)this.config), (ObjectMapperType)mapperType, (ObjectMapperConfig)this.config.getObjectMapperConfig(), (EncoderConfig)this.config.getEncoderConfig());
        return this;
    }

    @Override
    public WebTestClientRequestSpecification cookies(String firstCookieName, Object firstCookieValue, Object ... cookieNameValuePairs) {
        return this.cookies(MapCreator.createMapFromParams((MapCreator.CollisionStrategy)MapCreator.CollisionStrategy.OVERWRITE, (String)firstCookieName, (Object)firstCookieValue, (Object[])cookieNameValuePairs));
    }

    @Override
    public WebTestClientRequestSpecification cookies(Map<String, ?> cookies) {
        AssertParameter.notNull(cookies, (String)"cookies");
        this.cookies = CookieHelper.cookies((Cookies)this.cookies, cookies, (Headers)this.requestHeaders, (SpecificationConfig)this.config);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification cookies(Cookies cookies) {
        AssertParameter.notNull((Object)cookies, (String)"Cookies");
        this.cookies = CookieHelper.cookies((Cookies)this.cookies, (Cookies)cookies);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification cookie(String cookieName, Object cookieValue, Object ... additionalValues) {
        AssertParameter.notNull((Object)cookieName, (String)"Cookie name");
        AssertParameter.notNull((Object)cookieValue, (String)"Cookie value");
        return this.cookies(CookieHelper.cookie((String)cookieName, (Object)cookieValue, (Headers)this.requestHeaders, (SpecificationConfig)this.config, (Object[])additionalValues));
    }

    @Override
    public WebTestClientRequestSpecification cookie(Cookie cookie) {
        AssertParameter.notNull((Object)cookie, (String)"Cookie");
        return this.cookies(new Cookies(Collections.singletonList(cookie)));
    }

    @Override
    public WebTestClientRequestSpecification multiPart(File file) {
        MultiPartConfig multiPartConfig = this.config.getMultiPartConfig();
        MultiPartInternal multiPartInternal = new MultiPartInternal();
        multiPartInternal.setContent((Object)file);
        multiPartInternal.setControlName(multiPartConfig.defaultControlName());
        multiPartInternal.setFileName(file.getName());
        multiPartInternal.setMimeType("application/octet-stream");
        this.multiParts.add(multiPartInternal);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification multiPart(String controlName, File file) {
        MultiPartInternal multiPartInternal = new MultiPartInternal();
        multiPartInternal.setContent((Object)file);
        multiPartInternal.setControlName(controlName);
        multiPartInternal.setFileName(file.getName());
        multiPartInternal.setMimeType("application/octet-stream");
        this.multiParts.add(multiPartInternal);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification multiPart(String controlName, File file, String mimeType) {
        MultiPartInternal multiPartInternal = new MultiPartInternal();
        multiPartInternal.setContent((Object)file);
        multiPartInternal.setControlName(controlName);
        multiPartInternal.setFileName(file.getName());
        multiPartInternal.setMimeType(mimeType);
        this.multiParts.add(multiPartInternal);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification multiPart(String controlName, Object object) {
        MultiPartConfig multiPartConfig = this.config.getMultiPartConfig();
        MultiPartInternal multiPartInternal = new MultiPartInternal();
        multiPartInternal.setContent((Object)this.serializeIfNeeded(object));
        multiPartInternal.setControlName(controlName);
        multiPartInternal.setFileName(multiPartConfig.defaultFileName());
        this.multiParts.add(multiPartInternal);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification multiPart(String controlName, Object object, String mimeType) {
        MultiPartConfig multiPartConfig = this.config.getMultiPartConfig();
        MultiPartInternal multiPartInternal = new MultiPartInternal();
        multiPartInternal.setContent((Object)Serializer.serializeIfNeeded((Object)object, (String)mimeType, (SpecificationConfig)this.config));
        multiPartInternal.setControlName(controlName);
        multiPartInternal.setFileName(multiPartConfig.defaultFileName());
        multiPartInternal.setMimeType(mimeType);
        this.multiParts.add(multiPartInternal);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification multiPart(String controlName, String filename, Object object, String mimeType) {
        MultiPartInternal multiPartInternal = new MultiPartInternal();
        multiPartInternal.setContent((Object)Serializer.serializeIfNeeded((Object)object, (String)mimeType, (SpecificationConfig)this.config));
        multiPartInternal.setControlName(controlName);
        multiPartInternal.setFileName(filename);
        multiPartInternal.setMimeType(mimeType);
        this.multiParts.add(multiPartInternal);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification multiPart(String controlName, String fileName, byte[] bytes) {
        MultiPartInternal multiPartInternal = new MultiPartInternal();
        multiPartInternal.setContent((Object)bytes);
        multiPartInternal.setControlName(controlName);
        multiPartInternal.setFileName(fileName);
        multiPartInternal.setMimeType("application/octet-stream");
        this.multiParts.add(multiPartInternal);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification multiPart(String controlName, String fileName, byte[] bytes, String mimeType) {
        MultiPartInternal multiPartInternal = new MultiPartInternal();
        multiPartInternal.setContent((Object)bytes);
        multiPartInternal.setControlName(controlName);
        multiPartInternal.setFileName(fileName);
        multiPartInternal.setMimeType(mimeType);
        this.multiParts.add(multiPartInternal);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification multiPart(String controlName, String fileName, InputStream stream) {
        MultiPartInternal multiPartInternal = new MultiPartInternal();
        multiPartInternal.setContent((Object)stream);
        multiPartInternal.setControlName(controlName);
        multiPartInternal.setFileName(fileName);
        multiPartInternal.setMimeType("application/octet-stream");
        this.multiParts.add(multiPartInternal);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification multiPart(String controlName, String fileName, InputStream stream, String mimeType) {
        MultiPartInternal multiPartInternal = new MultiPartInternal();
        multiPartInternal.setContent((Object)stream);
        multiPartInternal.setControlName(controlName);
        multiPartInternal.setFileName(fileName);
        multiPartInternal.setMimeType(mimeType);
        this.multiParts.add(multiPartInternal);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification multiPart(String controlName, String contentBody) {
        MultiPartConfig multiPartConfig = this.config.getMultiPartConfig();
        MultiPartInternal multiPartInternal = new MultiPartInternal();
        multiPartInternal.setContent((Object)contentBody);
        multiPartInternal.setControlName(controlName);
        multiPartInternal.setFileName(multiPartConfig.defaultFileName());
        multiPartInternal.setMimeType("application/octet-stream");
        this.multiParts.add(multiPartInternal);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification multiPart(String controlName, String contentBody, String mimeType) {
        MultiPartConfig multiPartConfig = this.config.getMultiPartConfig();
        MultiPartInternal multiPartInternal = new MultiPartInternal();
        multiPartInternal.setContent((Object)contentBody);
        multiPartInternal.setControlName(controlName);
        multiPartInternal.setFileName(multiPartConfig.defaultFileName());
        multiPartInternal.setMimeType(mimeType);
        this.multiParts.add(multiPartInternal);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification config(RestAssuredWebTestClientConfig config) {
        this.assignConfig(config);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification config(SpecificationConfig config) {
        if (!(config instanceof RestAssuredWebTestClientConfig)) {
            throw new IllegalArgumentException("Only WebTestClientRequestSpecificationConfig allowed here");
        }
        this.assignConfig((RestAssuredWebTestClientConfig)config);
        return this;
    }

    @Override
    public WebTestClientRequestSpecification spec(WebTestClientRequestSpecification requestSpecificationToMerge) {
        AsyncConfig otherAsyncConfig;
        WebTestClientFactory otherWebTestClientFactory;
        AssertParameter.notNull((Object)requestSpecificationToMerge, WebTestClientRequestSpecification.class);
        if (!(requestSpecificationToMerge instanceof WebTestClientRequestSpecificationImpl)) {
            throw new IllegalArgumentException("requestSpecificationToMerge must be an instance of " + WebTestClientRequestSpecificationImpl.class.getName());
        }
        WebTestClientRequestSpecificationImpl specificationToMerge = (WebTestClientRequestSpecificationImpl)requestSpecificationToMerge;
        Object otherRequestBody = specificationToMerge.getRequestBody();
        if (otherRequestBody != null) {
            this.requestBody = otherRequestBody;
        }
        if (StringUtils.isNotEmpty((CharSequence)specificationToMerge.getBasePath())) {
            this.basePath = specificationToMerge.getBasePath();
        }
        if ((otherWebTestClientFactory = specificationToMerge.getWebTestClientFactory()) != null && otherWebTestClientFactory.isAssigned()) {
            this.webTestClientFactory = otherWebTestClientFactory;
        }
        this.cookies(specificationToMerge.getCookies());
        this.headers(specificationToMerge.getRequestHeaders());
        this.mergeConfig(this, specificationToMerge);
        this.formParams(specificationToMerge.getFormParams());
        this.pathParams(specificationToMerge.getPathParams());
        this.queryParams(specificationToMerge.getQueryParams());
        this.params(specificationToMerge.getParams());
        this.attributes(specificationToMerge.getAttributes());
        this.multiParts.addAll(specificationToMerge.getMultiParts());
        RequestLoggingFilter otherRequestLoggingFilter = specificationToMerge.getRequestLoggingFilter();
        if (otherRequestLoggingFilter != null) {
            this.requestLoggingFilter = otherRequestLoggingFilter;
        }
        if ((otherAsyncConfig = specificationToMerge.getAsyncConfig()) != null) {
            this.asyncConfig = otherAsyncConfig;
        }
        return this;
    }

    @Override
    public WebTestClientRequestSpecification sessionId(String sessionIdValue) {
        return this.sessionId(this.config.getSessionConfig().sessionIdName(), sessionIdValue);
    }

    @Override
    public WebTestClientRequestSpecification sessionId(String sessionIdName, String sessionIdValue) {
        AssertParameter.notNull((Object)sessionIdName, (String)"Session id name");
        AssertParameter.notNull((Object)sessionIdValue, (String)"Session id value");
        if (this.cookies.hasCookieWithName(sessionIdName)) {
            CookieHelper.sessionId((Cookies)this.cookies, (String)sessionIdName, (String)sessionIdValue);
        } else {
            this.cookie(sessionIdName, sessionIdValue, new Object[0]);
        }
        return this;
    }

    @Override
    public WebTestClientRequestSender when() {
        LogConfig logConfig = this.config.getLogConfig();
        if (this.requestLoggingFilter == null && logConfig.isLoggingOfRequestAndResponseIfValidationFailsEnabled()) {
            this.log().ifValidationFails(logConfig.logDetailOfRequestAndResponseIfValidationFails(), logConfig.isPrettyPrintingEnabled());
        }
        WebTestClient webTestClient = this.webTestClientFactory.build(this.config.getWebTestClientConfig());
        return new WebTestClientRequestSenderImpl(webTestClient, this.params, this.namedPathParams, this.queryParams, this.formParams, this.attributes, this.config, this.requestBody, this.requestHeaders, this.cookies, this.multiParts, this.requestLoggingFilter, this.basePath, this.responseSpecification, this.logRepository);
    }

    @Override
    public WebTestClientRequestSpecification standaloneSetup(Object ... controllerOrWebTestClientConfigurer) {
        WebTestClientFactory webTestClientFactory = StandaloneWebTestClientFactory.of(controllerOrWebTestClientConfigurer);
        return this.toRequestSpecification(webTestClientFactory);
    }

    @Override
    public WebTestClientRequestSpecification standaloneSetup(WebTestClient.Builder builder) {
        AssertParameter.notNull((Object)builder, WebTestClient.Builder.class);
        return this.toRequestSpecification(new BuilderBasedWebTestClientFactory(builder));
    }

    @Override
    public WebTestClientRequestSpecification standaloneSetup(RouterFunction routerFunction, WebTestClientConfigurer ... configurers) {
        AssertParameter.notNull((Object)routerFunction, RouterFunction.class);
        WebTestClientFactory webTestClientFactory = StandaloneWebTestClientFactory.of(routerFunction, (Object[])configurers);
        return this.toRequestSpecification(webTestClientFactory);
    }

    @Override
    public WebTestClientRequestSpecification webTestClient(WebTestClient webTestClient) {
        AssertParameter.notNull((Object)webTestClient, WebTestClient.class);
        return this.toRequestSpecification(new WrapperWebTestClientFactory(webTestClient));
    }

    @Override
    public WebTestClientRequestSpecification webAppContextSetup(WebApplicationContext context, WebTestClientConfigurer ... configurers) {
        return this.applicationContextSetup((ApplicationContext)context, configurers);
    }

    @Override
    public WebTestClientRequestSpecification applicationContextSetup(ApplicationContext context, WebTestClientConfigurer ... configurers) {
        WebTestClientFactory webTestClientFactory = StandaloneWebTestClientFactory.of(context, (Object[])configurers);
        return this.toRequestSpecification(webTestClientFactory);
    }

    @Override
    public WebTestClientRequestSpecification and() {
        return this;
    }

    private WebTestClientRequestSpecification toRequestSpecification(WebTestClientFactory webTestClientFactory) {
        this.webTestClientFactory = webTestClientFactory;
        return this;
    }

    public Object getRequestBody() {
        return this.requestBody;
    }

    public String getRequestContentType() {
        Header header = this.requestHeaders.get(CONTENT_TYPE);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    @Override
    public WebTestClientResponse get(Function<UriBuilder, URI> uriFunction) {
        return this.when().get(uriFunction);
    }

    @Override
    public WebTestClientResponse post(Function<UriBuilder, URI> uriFunction) {
        return this.when().post(uriFunction);
    }

    @Override
    public WebTestClientResponse put(Function<UriBuilder, URI> uriFunction) {
        return this.when().put(uriFunction);
    }

    @Override
    public WebTestClientResponse delete(Function<UriBuilder, URI> uriFunction) {
        return this.when().delete(uriFunction);
    }

    @Override
    public WebTestClientResponse patch(Function<UriBuilder, URI> uriFunction) {
        return this.when().patch(uriFunction);
    }

    @Override
    public WebTestClientResponse head(Function<UriBuilder, URI> uriFunction) {
        return this.when().head(uriFunction);
    }

    @Override
    public WebTestClientResponse options(Function<UriBuilder, URI> uriFunction) {
        return this.when().options(uriFunction);
    }

    @Override
    public WebTestClientResponse request(Method method, Function<UriBuilder, URI> uriFunction) {
        return this.when().request(method, uriFunction);
    }

    @Override
    public WebTestClientResponse request(String method, Function<UriBuilder, URI> uriFunction) {
        return this.when().request(method, uriFunction);
    }

    @Override
    public WebTestClientRequestSender consumeWith(Consumer<EntityExchangeResult<byte[]>> consumer) {
        return this.when().consumeWith(consumer);
    }

    public WebTestClientResponse get(String path, Object ... pathParams) {
        return (WebTestClientResponse)this.when().get(path, pathParams);
    }

    public WebTestClientResponse get(String path, Map<String, ?> pathParams) {
        return (WebTestClientResponse)this.when().get(path, pathParams);
    }

    public WebTestClientResponse post(String path, Object ... pathParams) {
        return (WebTestClientResponse)this.when().post(path, pathParams);
    }

    public WebTestClientResponse post(String path, Map<String, ?> pathParams) {
        return (WebTestClientResponse)this.when().post(path, pathParams);
    }

    public WebTestClientResponse put(String path, Object ... pathParams) {
        return (WebTestClientResponse)this.when().put(path, pathParams);
    }

    public WebTestClientResponse put(String path, Map<String, ?> pathParams) {
        return (WebTestClientResponse)this.when().put(path, pathParams);
    }

    public WebTestClientResponse delete(String path, Object ... pathParams) {
        return (WebTestClientResponse)this.when().delete(path, pathParams);
    }

    public WebTestClientResponse delete(String path, Map<String, ?> pathParams) {
        return (WebTestClientResponse)this.when().delete(path, pathParams);
    }

    public WebTestClientResponse head(String path, Object ... pathParams) {
        return (WebTestClientResponse)this.when().head(path, pathParams);
    }

    public WebTestClientResponse head(String path, Map<String, ?> pathParams) {
        return (WebTestClientResponse)this.when().head(path, pathParams);
    }

    public WebTestClientResponse patch(String path, Object ... pathParams) {
        return (WebTestClientResponse)this.when().patch(path, pathParams);
    }

    public WebTestClientResponse patch(String path, Map<String, ?> pathParams) {
        return (WebTestClientResponse)this.when().patch(path, pathParams);
    }

    public WebTestClientResponse options(String path, Object ... pathParams) {
        return (WebTestClientResponse)this.when().options(path, pathParams);
    }

    public WebTestClientResponse options(String path, Map<String, ?> pathParams) {
        return (WebTestClientResponse)this.when().options(path, pathParams);
    }

    public WebTestClientResponse get(URI uri) {
        return (WebTestClientResponse)this.when().get(uri);
    }

    public WebTestClientResponse post(URI uri) {
        return (WebTestClientResponse)this.when().post(uri);
    }

    public WebTestClientResponse put(URI uri) {
        return (WebTestClientResponse)this.when().put(uri);
    }

    public WebTestClientResponse delete(URI uri) {
        return (WebTestClientResponse)this.when().delete(uri);
    }

    public WebTestClientResponse head(URI uri) {
        return (WebTestClientResponse)this.when().head(uri);
    }

    public WebTestClientResponse patch(URI uri) {
        return (WebTestClientResponse)this.when().patch(uri);
    }

    public WebTestClientResponse options(URI uri) {
        return (WebTestClientResponse)this.when().options(uri);
    }

    public WebTestClientResponse get(URL url) {
        return (WebTestClientResponse)this.when().get(url);
    }

    public WebTestClientResponse post(URL url) {
        return (WebTestClientResponse)this.when().post(url);
    }

    public WebTestClientResponse put(URL url) {
        return (WebTestClientResponse)this.when().put(url);
    }

    public WebTestClientResponse delete(URL url) {
        return (WebTestClientResponse)this.when().delete(url);
    }

    public WebTestClientResponse head(URL url) {
        return (WebTestClientResponse)this.when().head(url);
    }

    public WebTestClientResponse patch(URL url) {
        return (WebTestClientResponse)this.when().patch(url);
    }

    public WebTestClientResponse options(URL url) {
        return (WebTestClientResponse)this.when().options(url);
    }

    public WebTestClientResponse get() {
        return (WebTestClientResponse)this.when().get();
    }

    public WebTestClientResponse post() {
        return (WebTestClientResponse)this.when().post();
    }

    public WebTestClientResponse put() {
        return (WebTestClientResponse)this.when().put();
    }

    public WebTestClientResponse delete() {
        return (WebTestClientResponse)this.when().delete();
    }

    public WebTestClientResponse head() {
        return (WebTestClientResponse)this.when().head();
    }

    public WebTestClientResponse patch() {
        return (WebTestClientResponse)this.when().patch();
    }

    public WebTestClientResponse options() {
        return (WebTestClientResponse)this.when().options();
    }

    public WebTestClientResponse request(Method method) {
        return (WebTestClientResponse)this.when().request(method);
    }

    public WebTestClientResponse request(String method) {
        return (WebTestClientResponse)this.when().request(method);
    }

    public WebTestClientResponse request(Method method, String path, Object ... pathParams) {
        return (WebTestClientResponse)this.when().request(method, path, pathParams);
    }

    public WebTestClientResponse request(String method, String path, Object ... pathParams) {
        return (WebTestClientResponse)this.when().request(method, path, pathParams);
    }

    public WebTestClientResponse request(Method method, URI uri) {
        return (WebTestClientResponse)this.when().request(method, uri);
    }

    public WebTestClientResponse request(Method method, URL url) {
        return (WebTestClientResponse)this.when().request(method, url);
    }

    public WebTestClientResponse request(String method, URI uri) {
        return (WebTestClientResponse)this.when().request(method, uri);
    }

    public WebTestClientResponse request(String method, URL url) {
        return (WebTestClientResponse)this.when().request(method, url);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public WebTestClientFactory getWebTestClientFactory() {
        return this.webTestClientFactory;
    }

    public Cookies getCookies() {
        return this.cookies;
    }

    public Headers getRequestHeaders() {
        return this.requestHeaders;
    }

    private void mergeConfig(WebTestClientRequestSpecificationImpl thisOne, WebTestClientRequestSpecificationImpl other) {
        this.config((RestAssuredWebTestClientConfig)ConfigMergeUtils.mergeConfig((SpecificationConfig)thisOne.getRestAssuredWebTestClientConfig(), (SpecificationConfig)other.getRestAssuredWebTestClientConfig()));
    }

    public Map<String, Object> getFormParams() {
        return this.formParams;
    }

    public Map<String, Object> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, Object> getPathParams() {
        return this.namedPathParams;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public List<MultiPartInternal> getMultiParts() {
        return this.multiParts;
    }

    public RequestLoggingFilter getRequestLoggingFilter() {
        return this.requestLoggingFilter;
    }

    public AsyncConfig getAsyncConfig() {
        return this.asyncConfig;
    }

    public RestAssuredWebTestClientConfig getRestAssuredWebTestClientConfig() {
        return this.config;
    }

    public LogRepository getLogRepository() {
        return this.logRepository;
    }

    public void setRequestLoggingFilter(RequestLoggingFilter requestLoggingFilter) {
        this.requestLoggingFilter = requestLoggingFilter;
    }

    public RestAssuredConfig getRestAssuredConfig() {
        return ConfigConverter.convertToRestAssuredConfig((SpecificationConfig)this.config);
    }

    public WebTestClientRequestSpecification basePath(String path) {
        AssertParameter.notNull((Object)path, (String)"Base path");
        this.basePath = path;
        return this;
    }

    private String serializeIfNeeded(Object object) {
        return Serializer.serializeIfNeeded((Object)object, (String)this.getRequestContentType(), (SpecificationConfig)this.config);
    }

    private static WebTestClientParamConfig toWebTestClientParamConfig(ParamConfig paramConfig) {
        if (!(paramConfig instanceof WebTestClientParamConfig)) {
            throw new IllegalArgumentException("Wrong ParamConfig passed to method.");
        }
        return (WebTestClientParamConfig)paramConfig;
    }

    private static ParamConfig.UpdateStrategy convert(ParamConfig.UpdateStrategy updateStrategy) {
        return ParamConfig.UpdateStrategy.valueOf((String)updateStrategy.name());
    }
}

