/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.webtestclient.internal;

import io.restassured.module.webtestclient.internal.BuilderBasedWebTestClientFactory;
import io.restassured.module.webtestclient.internal.WebTestClientFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationContext;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.reactive.server.WebTestClientConfigurer;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.server.RouterFunction;

public class StandaloneWebTestClientFactory {
    public static WebTestClientFactory of(RouterFunction routerFunction, Object[] configurersOrExchangeFilterFunctions) {
        WebTestClient.Builder builder = WebTestClient.bindToRouterFunction((RouterFunction)routerFunction).configureClient();
        StandaloneWebTestClientFactory.applyConfigurersAndFilter(configurersOrExchangeFilterFunctions, builder);
        return new BuilderBasedWebTestClientFactory(builder);
    }

    public static WebTestClientFactory of(Object[] controllersOrConfigurersOrExchangeFilterFunctions) {
        Map<Boolean, List<Object>> partitionedByConfigurer = Arrays.stream(controllersOrConfigurersOrExchangeFilterFunctions).collect(Collectors.partitioningBy(WebTestClientConfigurer.class::isInstance));
        List<Object> controllersAndExchangeFunctions = partitionedByConfigurer.get(false);
        Map<Boolean, List<Object>> partitionedByExchangeFunction = controllersAndExchangeFunctions.stream().collect(Collectors.partitioningBy(ExchangeFilterFunction.class::isInstance));
        List<WebTestClientConfigurer> configurers = partitionedByConfigurer.get(true).stream().map(WebTestClientConfigurer.class::cast).collect(Collectors.toList());
        List<ExchangeFilterFunction> exchangeFilterFunctions = partitionedByExchangeFunction.get(true).stream().map(ExchangeFilterFunction.class::cast).collect(Collectors.toList());
        WebTestClient.Builder builder = WebTestClient.bindToController((Object[])partitionedByExchangeFunction.get(false).toArray()).configureClient();
        configurers.forEach(arg_0 -> ((WebTestClient.Builder)builder).apply(arg_0));
        exchangeFilterFunctions.forEach(arg_0 -> ((WebTestClient.Builder)builder).filter(arg_0));
        return new BuilderBasedWebTestClientFactory(builder);
    }

    public static WebTestClientFactory of(ApplicationContext applicationContext, Object[] configurersOrExchangeFilterFunctions) {
        WebTestClient.Builder builder = WebTestClient.bindToApplicationContext((ApplicationContext)applicationContext).configureClient();
        StandaloneWebTestClientFactory.applyConfigurersAndFilter(configurersOrExchangeFilterFunctions, builder);
        return new BuilderBasedWebTestClientFactory(builder);
    }

    private static void applyConfigurersAndFilter(Object[] configurersOrExchangeFilterFunctions, WebTestClient.Builder builder) {
        Map<Boolean, List<Object>> partitionedByConfigurer = Arrays.stream(configurersOrExchangeFilterFunctions).collect(Collectors.partitioningBy(WebTestClientConfigurer.class::isInstance));
        partitionedByConfigurer.get(true).stream().map(WebTestClientConfigurer.class::cast).forEach(arg_0 -> ((WebTestClient.Builder)builder).apply(arg_0));
        partitionedByConfigurer.get(false).stream().filter(ExchangeFilterFunction.class::isInstance).map(ExchangeFilterFunction.class::cast).forEach(arg_0 -> ((WebTestClient.Builder)builder).filter(arg_0));
    }
}

