/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.core;

import io.reactivex.rxjava3.annotations.BackpressureKind;
import io.reactivex.rxjava3.annotations.BackpressureSupport;
import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.annotations.SchedulerSupport;
import io.reactivex.rxjava3.core.BackpressureOverflowStrategy;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Emitter;
import io.reactivex.rxjava3.core.FlowableConverter;
import io.reactivex.rxjava3.core.FlowableOnSubscribe;
import io.reactivex.rxjava3.core.FlowableOperator;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Notification;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.flowables.ConnectableFlowable;
import io.reactivex.rxjava3.flowables.GroupedFlowable;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.BiConsumer;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.BiPredicate;
import io.reactivex.rxjava3.functions.BooleanSupplier;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Function3;
import io.reactivex.rxjava3.functions.Function4;
import io.reactivex.rxjava3.functions.Function5;
import io.reactivex.rxjava3.functions.Function6;
import io.reactivex.rxjava3.functions.Function7;
import io.reactivex.rxjava3.functions.Function8;
import io.reactivex.rxjava3.functions.Function9;
import io.reactivex.rxjava3.functions.LongConsumer;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.fuseable.ScalarSupplier;
import io.reactivex.rxjava3.internal.jdk8.FlowableCollectWithCollectorSingle;
import io.reactivex.rxjava3.internal.jdk8.FlowableFirstStageSubscriber;
import io.reactivex.rxjava3.internal.jdk8.FlowableFlatMapStream;
import io.reactivex.rxjava3.internal.jdk8.FlowableFromCompletionStage;
import io.reactivex.rxjava3.internal.jdk8.FlowableFromStream;
import io.reactivex.rxjava3.internal.jdk8.FlowableLastStageSubscriber;
import io.reactivex.rxjava3.internal.jdk8.FlowableMapOptional;
import io.reactivex.rxjava3.internal.jdk8.FlowableSingleStageSubscriber;
import io.reactivex.rxjava3.internal.operators.flowable.BlockingFlowableIterable;
import io.reactivex.rxjava3.internal.operators.flowable.BlockingFlowableLatest;
import io.reactivex.rxjava3.internal.operators.flowable.BlockingFlowableMostRecent;
import io.reactivex.rxjava3.internal.operators.flowable.BlockingFlowableNext;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableAllSingle;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableAmb;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableAnySingle;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableBlockingSubscribe;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableBuffer;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableBufferBoundary;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableBufferExactBoundary;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableBufferTimed;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableCache;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableCollectSingle;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableCombineLatest;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableConcatArray;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableConcatMap;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableConcatMapEager;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableConcatMapEagerPublisher;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableConcatMapScheduler;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableConcatWithCompletable;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableConcatWithMaybe;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableConcatWithSingle;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableCountSingle;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableCreate;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableDebounce;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableDebounceTimed;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableDefer;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableDelay;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableDelaySubscriptionOther;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableDematerialize;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableDetach;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableDistinct;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableDistinctUntilChanged;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableDoAfterNext;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableDoFinally;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableDoOnEach;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableDoOnLifecycle;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableElementAtMaybe;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableElementAtSingle;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableEmpty;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableError;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableFilter;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableFlatMap;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableFlatMapCompletableCompletable;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableFlatMapMaybe;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableFlatMapSingle;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableFlattenIterable;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableFromArray;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableFromCallable;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableFromFuture;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableFromIterable;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableFromPublisher;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableFromSupplier;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableGenerate;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableGroupBy;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableGroupJoin;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableHide;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableIgnoreElements;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableIgnoreElementsCompletable;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableInternalHelper;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableInterval;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableIntervalRange;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableJoin;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableJust;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableLastMaybe;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableLastSingle;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableLift;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableMap;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableMapNotification;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableMaterialize;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableMergeWithCompletable;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableMergeWithMaybe;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableMergeWithSingle;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableNever;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableObserveOn;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableOnBackpressureBuffer;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableOnBackpressureBufferStrategy;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableOnBackpressureDrop;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableOnBackpressureLatest;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableOnErrorNext;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableOnErrorReturn;
import io.reactivex.rxjava3.internal.operators.flowable.FlowablePublish;
import io.reactivex.rxjava3.internal.operators.flowable.FlowablePublishMulticast;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableRange;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableRangeLong;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableReduceMaybe;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableReduceSeedSingle;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableReduceWithSingle;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableRepeat;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableRepeatUntil;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableRepeatWhen;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableReplay;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableRetryBiPredicate;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableRetryPredicate;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableRetryWhen;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableSamplePublisher;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableSampleTimed;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableScalarXMap;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableScan;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableScanSeed;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableSequenceEqualSingle;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableSerialized;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableSingleMaybe;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableSingleSingle;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableSkip;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableSkipLast;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableSkipLastTimed;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableSkipUntil;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableSkipWhile;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableSubscribeOn;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableSwitchIfEmpty;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableSwitchMap;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableTake;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableTakeLast;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableTakeLastOne;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableTakeLastTimed;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableTakeUntil;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableTakeUntilPredicate;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableTakeWhile;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableThrottleFirstTimed;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableThrottleLatest;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableTimeInterval;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableTimeout;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableTimeoutTimed;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableTimer;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableToListSingle;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableUnsubscribeOn;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableUsing;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableWindow;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableWindowBoundary;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableWindowBoundarySelector;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableWindowTimed;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableWithLatestFrom;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableWithLatestFromMany;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableZip;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableZipIterable;
import io.reactivex.rxjava3.internal.operators.mixed.FlowableConcatMapCompletable;
import io.reactivex.rxjava3.internal.operators.mixed.FlowableConcatMapMaybe;
import io.reactivex.rxjava3.internal.operators.mixed.FlowableConcatMapSingle;
import io.reactivex.rxjava3.internal.operators.mixed.FlowableSwitchMapCompletable;
import io.reactivex.rxjava3.internal.operators.mixed.FlowableSwitchMapMaybe;
import io.reactivex.rxjava3.internal.operators.mixed.FlowableSwitchMapSingle;
import io.reactivex.rxjava3.internal.operators.observable.ObservableFromPublisher;
import io.reactivex.rxjava3.internal.schedulers.ImmediateThinScheduler;
import io.reactivex.rxjava3.internal.subscribers.BlockingFirstSubscriber;
import io.reactivex.rxjava3.internal.subscribers.BlockingLastSubscriber;
import io.reactivex.rxjava3.internal.subscribers.ForEachWhileSubscriber;
import io.reactivex.rxjava3.internal.subscribers.FutureSubscriber;
import io.reactivex.rxjava3.internal.subscribers.LambdaSubscriber;
import io.reactivex.rxjava3.internal.subscribers.StrictSubscriber;
import io.reactivex.rxjava3.internal.util.ArrayListSupplier;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.HashMapSupplier;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.schedulers.Timed;
import io.reactivex.rxjava3.subscribers.SafeSubscriber;
import io.reactivex.rxjava3.subscribers.TestSubscriber;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class Flowable<@NonNull T>
implements Publisher<T> {
    static final int BUFFER_SIZE = Math.max(1, Integer.getInteger("rx3.buffer-size", 128));

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> amb(@NonNull @NonNull Iterable<@NonNull ? extends Publisher<@NonNull ? extends T>> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new FlowableAmb(null, sources));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Flowable<T> ambArray(Publisher<? extends T> ... sources) {
        Objects.requireNonNull(sources, "sources is null");
        int len = sources.length;
        if (len == 0) {
            return Flowable.empty();
        }
        if (len == 1) {
            return Flowable.fromPublisher(sources[0]);
        }
        return RxJavaPlugins.onAssembly(new FlowableAmb<T>(sources, null));
    }

    @CheckReturnValue
    public static int bufferSize() {
        return BUFFER_SIZE;
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public static <T, R> Flowable<R> combineLatestArray(@NonNull @NonNull Publisher<@NonNull ? extends T>[] sources, @NonNull Function<? super Object[], ? extends R> combiner) {
        return Flowable.combineLatestArray(sources, combiner, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public static <T, R> Flowable<R> combineLatestArray(@NonNull @NonNull Publisher<@NonNull ? extends T>[] sources, @NonNull Function<? super Object[], ? extends R> combiner, int bufferSize) {
        Objects.requireNonNull(sources, "sources is null");
        if (sources.length == 0) {
            return Flowable.empty();
        }
        Objects.requireNonNull(combiner, "combiner is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableCombineLatest<T, R>(sources, combiner, bufferSize, false));
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public static <T, R> Flowable<R> combineLatest(@NonNull @NonNull Iterable<@NonNull ? extends Publisher<@NonNull ? extends T>> sources, @NonNull Function<? super Object[], ? extends R> combiner) {
        return Flowable.combineLatest(sources, combiner, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public static <T, R> Flowable<R> combineLatest(@NonNull @NonNull Iterable<@NonNull ? extends Publisher<@NonNull ? extends T>> sources, @NonNull Function<? super Object[], ? extends R> combiner, int bufferSize) {
        Objects.requireNonNull(sources, "sources is null");
        Objects.requireNonNull(combiner, "combiner is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableCombineLatest(sources, combiner, bufferSize, false));
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public static <T, R> Flowable<R> combineLatestArrayDelayError(@NonNull @NonNull Publisher<@NonNull ? extends T>[] sources, @NonNull Function<? super Object[], ? extends R> combiner) {
        return Flowable.combineLatestArrayDelayError(sources, combiner, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public static <T, R> Flowable<R> combineLatestArrayDelayError(@NonNull @NonNull Publisher<@NonNull ? extends T>[] sources, @NonNull Function<? super Object[], ? extends R> combiner, int bufferSize) {
        Objects.requireNonNull(sources, "sources is null");
        Objects.requireNonNull(combiner, "combiner is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        if (sources.length == 0) {
            return Flowable.empty();
        }
        return RxJavaPlugins.onAssembly(new FlowableCombineLatest<T, R>(sources, combiner, bufferSize, true));
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public static <T, R> Flowable<R> combineLatestDelayError(@NonNull @NonNull Iterable<@NonNull ? extends Publisher<@NonNull ? extends T>> sources, @NonNull Function<? super Object[], ? extends R> combiner) {
        return Flowable.combineLatestDelayError(sources, combiner, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public static <T, R> Flowable<R> combineLatestDelayError(@NonNull @NonNull Iterable<@NonNull ? extends Publisher<@NonNull ? extends T>> sources, @NonNull Function<? super Object[], ? extends R> combiner, int bufferSize) {
        Objects.requireNonNull(sources, "sources is null");
        Objects.requireNonNull(combiner, "combiner is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableCombineLatest(sources, combiner, bufferSize, true));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, R> Flowable<R> combineLatest(@NonNull @NonNull Publisher<@NonNull ? extends T1> source1, @NonNull @NonNull Publisher<@NonNull ? extends T2> source2, @NonNull BiFunction<? super T1, ? super T2, ? extends R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return Flowable.combineLatestArray(new Publisher[]{source1, source2}, Functions.toFunction(combiner), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, R> Flowable<R> combineLatest(@NonNull @NonNull Publisher<@NonNull ? extends T1> source1, @NonNull @NonNull Publisher<@NonNull ? extends T2> source2, @NonNull @NonNull Publisher<@NonNull ? extends T3> source3, @NonNull Function3<? super T1, ? super T2, ? super T3, ? extends R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return Flowable.combineLatestArray(new Publisher[]{source1, source2, source3}, Functions.toFunction(combiner), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, R> Flowable<R> combineLatest(@NonNull @NonNull Publisher<@NonNull ? extends T1> source1, @NonNull @NonNull Publisher<@NonNull ? extends T2> source2, @NonNull @NonNull Publisher<@NonNull ? extends T3> source3, @NonNull @NonNull Publisher<@NonNull ? extends T4> source4, @NonNull Function4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return Flowable.combineLatestArray(new Publisher[]{source1, source2, source3, source4}, Functions.toFunction(combiner), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, R> Flowable<R> combineLatest(@NonNull @NonNull Publisher<@NonNull ? extends T1> source1, @NonNull @NonNull Publisher<@NonNull ? extends T2> source2, @NonNull @NonNull Publisher<@NonNull ? extends T3> source3, @NonNull @NonNull Publisher<@NonNull ? extends T4> source4, @NonNull @NonNull Publisher<@NonNull ? extends T5> source5, @NonNull Function5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return Flowable.combineLatestArray(new Publisher[]{source1, source2, source3, source4, source5}, Functions.toFunction(combiner), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, R> Flowable<R> combineLatest(@NonNull @NonNull Publisher<@NonNull ? extends T1> source1, @NonNull @NonNull Publisher<@NonNull ? extends T2> source2, @NonNull @NonNull Publisher<@NonNull ? extends T3> source3, @NonNull @NonNull Publisher<@NonNull ? extends T4> source4, @NonNull @NonNull Publisher<@NonNull ? extends T5> source5, @NonNull @NonNull Publisher<@NonNull ? extends T6> source6, @NonNull Function6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return Flowable.combineLatestArray(new Publisher[]{source1, source2, source3, source4, source5, source6}, Functions.toFunction(combiner), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, T7, R> Flowable<R> combineLatest(@NonNull @NonNull Publisher<@NonNull ? extends T1> source1, @NonNull @NonNull Publisher<@NonNull ? extends T2> source2, @NonNull @NonNull Publisher<@NonNull ? extends T3> source3, @NonNull @NonNull Publisher<@NonNull ? extends T4> source4, @NonNull @NonNull Publisher<@NonNull ? extends T5> source5, @NonNull @NonNull Publisher<@NonNull ? extends T6> source6, @NonNull @NonNull Publisher<@NonNull ? extends T7> source7, @NonNull Function7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(source7, "source7 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return Flowable.combineLatestArray(new Publisher[]{source1, source2, source3, source4, source5, source6, source7}, Functions.toFunction(combiner), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Flowable<R> combineLatest(@NonNull @NonNull Publisher<@NonNull ? extends T1> source1, @NonNull @NonNull Publisher<@NonNull ? extends T2> source2, @NonNull @NonNull Publisher<@NonNull ? extends T3> source3, @NonNull @NonNull Publisher<@NonNull ? extends T4> source4, @NonNull @NonNull Publisher<@NonNull ? extends T5> source5, @NonNull @NonNull Publisher<@NonNull ? extends T6> source6, @NonNull @NonNull Publisher<@NonNull ? extends T7> source7, @NonNull @NonNull Publisher<@NonNull ? extends T8> source8, @NonNull Function8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(source7, "source7 is null");
        Objects.requireNonNull(source8, "source8 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return Flowable.combineLatestArray(new Publisher[]{source1, source2, source3, source4, source5, source6, source7, source8}, Functions.toFunction(combiner), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Flowable<R> combineLatest(@NonNull @NonNull Publisher<@NonNull ? extends T1> source1, @NonNull @NonNull Publisher<@NonNull ? extends T2> source2, @NonNull @NonNull Publisher<@NonNull ? extends T3> source3, @NonNull @NonNull Publisher<@NonNull ? extends T4> source4, @NonNull @NonNull Publisher<@NonNull ? extends T5> source5, @NonNull @NonNull Publisher<@NonNull ? extends T6> source6, @NonNull @NonNull Publisher<@NonNull ? extends T7> source7, @NonNull @NonNull Publisher<@NonNull ? extends T8> source8, @NonNull @NonNull Publisher<@NonNull ? extends T9> source9, @NonNull Function9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(source7, "source7 is null");
        Objects.requireNonNull(source8, "source8 is null");
        Objects.requireNonNull(source9, "source9 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return Flowable.combineLatestArray(new Publisher[]{source1, source2, source3, source4, source5, source6, source7, source8, source9}, Functions.toFunction(combiner), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concat(@NonNull @NonNull Iterable<@NonNull ? extends Publisher<@NonNull ? extends T>> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return Flowable.fromIterable(sources).concatMapDelayError(Functions.identity(), false, 2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concat(@NonNull @NonNull Publisher<@NonNull ? extends Publisher<@NonNull ? extends T>> sources) {
        return Flowable.concat(sources, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concat(@NonNull @NonNull Publisher<@NonNull ? extends Publisher<@NonNull ? extends T>> sources, int prefetch) {
        return Flowable.fromPublisher(sources).concatMap(Functions.identity(), prefetch);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concat(@NonNull @NonNull Publisher<@NonNull ? extends T> source1, @NonNull @NonNull Publisher<@NonNull ? extends T> source2) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        return Flowable.concatArray(source1, source2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concat(@NonNull @NonNull Publisher<@NonNull ? extends T> source1, @NonNull @NonNull Publisher<@NonNull ? extends T> source2, @NonNull @NonNull Publisher<@NonNull ? extends T> source3) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        return Flowable.concatArray(source1, source2, source3);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concat(@NonNull @NonNull Publisher<@NonNull ? extends T> source1, @NonNull @NonNull Publisher<@NonNull ? extends T> source2, @NonNull @NonNull Publisher<@NonNull ? extends T> source3, @NonNull @NonNull Publisher<@NonNull ? extends T> source4) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        return Flowable.concatArray(source1, source2, source3, source4);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Flowable<T> concatArray(Publisher<? extends T> ... sources) {
        Objects.requireNonNull(sources, "sources is null");
        if (sources.length == 0) {
            return Flowable.empty();
        }
        if (sources.length == 1) {
            return Flowable.fromPublisher(sources[0]);
        }
        return RxJavaPlugins.onAssembly(new FlowableConcatArray<T>(sources, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Flowable<T> concatArrayDelayError(Publisher<? extends T> ... sources) {
        Objects.requireNonNull(sources, "sources is null");
        if (sources.length == 0) {
            return Flowable.empty();
        }
        if (sources.length == 1) {
            return Flowable.fromPublisher(sources[0]);
        }
        return RxJavaPlugins.onAssembly(new FlowableConcatArray<T>(sources, true));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Flowable<T> concatArrayEager(Publisher<? extends T> ... sources) {
        return Flowable.concatArrayEager(Flowable.bufferSize(), Flowable.bufferSize(), sources);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Flowable<T> concatArrayEager(int maxConcurrency, int prefetch, Publisher<? extends T> ... sources) {
        Objects.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableConcatMapEager(new FlowableFromArray<Publisher<? extends T>>(sources), Functions.identity(), maxConcurrency, prefetch, ErrorMode.IMMEDIATE));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SafeVarargs
    @NonNull
    public static <T> Flowable<T> concatArrayEagerDelayError(Publisher<? extends T> ... sources) {
        return Flowable.concatArrayEagerDelayError(Flowable.bufferSize(), Flowable.bufferSize(), sources);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SafeVarargs
    @NonNull
    public static <T> Flowable<T> concatArrayEagerDelayError(int maxConcurrency, int prefetch, Publisher<? extends T> ... sources) {
        return Flowable.fromArray(sources).concatMapEagerDelayError(Functions.identity(), true, maxConcurrency, prefetch);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concatDelayError(@NonNull @NonNull Iterable<@NonNull ? extends Publisher<@NonNull ? extends T>> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return Flowable.fromIterable(sources).concatMapDelayError(Functions.identity());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concatDelayError(@NonNull @NonNull Publisher<@NonNull ? extends Publisher<@NonNull ? extends T>> sources) {
        return Flowable.concatDelayError(sources, Flowable.bufferSize(), true);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concatDelayError(@NonNull @NonNull Publisher<@NonNull ? extends Publisher<@NonNull ? extends T>> sources, int prefetch, boolean tillTheEnd) {
        return Flowable.fromPublisher(sources).concatMapDelayError(Functions.identity(), tillTheEnd, prefetch);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concatEager(@NonNull @NonNull Publisher<@NonNull ? extends Publisher<@NonNull ? extends T>> sources) {
        return Flowable.concatEager(sources, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concatEager(@NonNull @NonNull Publisher<@NonNull ? extends Publisher<@NonNull ? extends T>> sources, int maxConcurrency, int prefetch) {
        Objects.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableConcatMapEagerPublisher(sources, Functions.identity(), maxConcurrency, prefetch, ErrorMode.IMMEDIATE));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concatEager(@NonNull @NonNull Iterable<@NonNull ? extends Publisher<@NonNull ? extends T>> sources) {
        return Flowable.concatEager(sources, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concatEager(@NonNull @NonNull Iterable<@NonNull ? extends Publisher<@NonNull ? extends T>> sources, int maxConcurrency, int prefetch) {
        Objects.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableConcatMapEager(new FlowableFromIterable<Publisher<? extends T>>(sources), Functions.identity(), maxConcurrency, prefetch, ErrorMode.IMMEDIATE));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> create(@NonNull FlowableOnSubscribe<T> source, @NonNull BackpressureStrategy mode) {
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(mode, "mode is null");
        return RxJavaPlugins.onAssembly(new FlowableCreate<T>(source, mode));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> defer(@NonNull @NonNull Supplier<? extends Publisher<@NonNull ? extends T>> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return RxJavaPlugins.onAssembly(new FlowableDefer(supplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> empty() {
        return RxJavaPlugins.onAssembly(FlowableEmpty.INSTANCE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> error(@NonNull Supplier<? extends Throwable> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return RxJavaPlugins.onAssembly(new FlowableError(supplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> error(@NonNull Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable is null");
        return Flowable.error(Functions.justSupplier(throwable));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Flowable<T> fromArray(T ... items) {
        Objects.requireNonNull(items, "items is null");
        if (items.length == 0) {
            return Flowable.empty();
        }
        if (items.length == 1) {
            return Flowable.just(items[0]);
        }
        return RxJavaPlugins.onAssembly(new FlowableFromArray<T>(items));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> fromCallable(@NonNull Callable<? extends T> callable) {
        Objects.requireNonNull(callable, "callable is null");
        return RxJavaPlugins.onAssembly(new FlowableFromCallable<T>(callable));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> fromFuture(@NonNull Future<? extends T> future) {
        Objects.requireNonNull(future, "future is null");
        return RxJavaPlugins.onAssembly(new FlowableFromFuture<T>(future, 0L, null));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> fromFuture(@NonNull Future<? extends T> future, long timeout, @NonNull TimeUnit unit) {
        Objects.requireNonNull(future, "future is null");
        Objects.requireNonNull(unit, "unit is null");
        return RxJavaPlugins.onAssembly(new FlowableFromFuture<T>(future, timeout, unit));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> fromIterable(@NonNull @NonNull Iterable<@NonNull ? extends T> source) {
        Objects.requireNonNull(source, "source is null");
        return RxJavaPlugins.onAssembly(new FlowableFromIterable<T>(source));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> fromPublisher(@NonNull @NonNull Publisher<@NonNull ? extends T> source) {
        if (source instanceof Flowable) {
            return RxJavaPlugins.onAssembly((Flowable)source);
        }
        Objects.requireNonNull(source, "source is null");
        return RxJavaPlugins.onAssembly(new FlowableFromPublisher<T>(source));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> fromSupplier(@NonNull Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return RxJavaPlugins.onAssembly(new FlowableFromSupplier<T>(supplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> generate(@NonNull @NonNull Consumer<@NonNull Emitter<T>> generator) {
        Objects.requireNonNull(generator, "generator is null");
        return Flowable.generate(Functions.nullSupplier(), FlowableInternalHelper.simpleGenerator(generator), Functions.emptyConsumer());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, S> Flowable<T> generate(@NonNull Supplier<S> initialState, @NonNull BiConsumer<S, Emitter<T>> generator) {
        Objects.requireNonNull(generator, "generator is null");
        return Flowable.generate(initialState, FlowableInternalHelper.simpleBiGenerator(generator), Functions.emptyConsumer());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, S> Flowable<T> generate(@NonNull Supplier<S> initialState, @NonNull BiConsumer<S, Emitter<T>> generator, @NonNull Consumer<? super S> disposeState) {
        Objects.requireNonNull(generator, "generator is null");
        return Flowable.generate(initialState, FlowableInternalHelper.simpleBiGenerator(generator), disposeState);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, S> Flowable<T> generate(@NonNull Supplier<S> initialState, @NonNull @NonNull BiFunction<S, @NonNull Emitter<T>, S> generator) {
        return Flowable.generate(initialState, generator, Functions.emptyConsumer());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, S> Flowable<T> generate(@NonNull Supplier<S> initialState, @NonNull @NonNull BiFunction<S, @NonNull Emitter<T>, S> generator, @NonNull Consumer<? super S> disposeState) {
        Objects.requireNonNull(initialState, "initialState is null");
        Objects.requireNonNull(generator, "generator is null");
        Objects.requireNonNull(disposeState, "disposeState is null");
        return RxJavaPlugins.onAssembly(new FlowableGenerate<T, S>(initialState, generator, disposeState));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public static Flowable<Long> interval(long initialDelay, long period, @NonNull TimeUnit unit) {
        return Flowable.interval(initialDelay, period, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public static Flowable<Long> interval(long initialDelay, long period, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableInterval(Math.max(0L, initialDelay), Math.max(0L, period), unit, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public static Flowable<Long> interval(long period, @NonNull TimeUnit unit) {
        return Flowable.interval(period, period, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public static Flowable<Long> interval(long period, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return Flowable.interval(period, period, unit, scheduler);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public static Flowable<Long> intervalRange(long start, long count, long initialDelay, long period, @NonNull TimeUnit unit) {
        return Flowable.intervalRange(start, count, initialDelay, period, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public static Flowable<Long> intervalRange(long start, long count, long initialDelay, long period, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        if (count < 0L) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count);
        }
        if (count == 0L) {
            return Flowable.empty().delay(initialDelay, unit, scheduler);
        }
        long end = start + (count - 1L);
        if (start > 0L && end < 0L) {
            throw new IllegalArgumentException("Overflow! start + count is bigger than Long.MAX_VALUE");
        }
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableIntervalRange(start, end, Math.max(0L, initialDelay), Math.max(0L, period), unit, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> just(T item) {
        Objects.requireNonNull(item, "item is null");
        return RxJavaPlugins.onAssembly(new FlowableJust<T>(item));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> just(T item1, T item2) {
        Objects.requireNonNull(item1, "item1 is null");
        Objects.requireNonNull(item2, "item2 is null");
        return Flowable.fromArray(item1, item2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> just(T item1, T item2, T item3) {
        Objects.requireNonNull(item1, "item1 is null");
        Objects.requireNonNull(item2, "item2 is null");
        Objects.requireNonNull(item3, "item3 is null");
        return Flowable.fromArray(item1, item2, item3);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4) {
        Objects.requireNonNull(item1, "item1 is null");
        Objects.requireNonNull(item2, "item2 is null");
        Objects.requireNonNull(item3, "item3 is null");
        Objects.requireNonNull(item4, "item4 is null");
        return Flowable.fromArray(item1, item2, item3, item4);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4, T item5) {
        Objects.requireNonNull(item1, "item1 is null");
        Objects.requireNonNull(item2, "item2 is null");
        Objects.requireNonNull(item3, "item3 is null");
        Objects.requireNonNull(item4, "item4 is null");
        Objects.requireNonNull(item5, "item5 is null");
        return Flowable.fromArray(item1, item2, item3, item4, item5);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4, T item5, T item6) {
        Objects.requireNonNull(item1, "item1 is null");
        Objects.requireNonNull(item2, "item2 is null");
        Objects.requireNonNull(item3, "item3 is null");
        Objects.requireNonNull(item4, "item4 is null");
        Objects.requireNonNull(item5, "item5 is null");
        Objects.requireNonNull(item6, "item6 is null");
        return Flowable.fromArray(item1, item2, item3, item4, item5, item6);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4, T item5, T item6, T item7) {
        Objects.requireNonNull(item1, "item1 is null");
        Objects.requireNonNull(item2, "item2 is null");
        Objects.requireNonNull(item3, "item3 is null");
        Objects.requireNonNull(item4, "item4 is null");
        Objects.requireNonNull(item5, "item5 is null");
        Objects.requireNonNull(item6, "item6 is null");
        Objects.requireNonNull(item7, "item7 is null");
        return Flowable.fromArray(item1, item2, item3, item4, item5, item6, item7);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4, T item5, T item6, T item7, T item8) {
        Objects.requireNonNull(item1, "item1 is null");
        Objects.requireNonNull(item2, "item2 is null");
        Objects.requireNonNull(item3, "item3 is null");
        Objects.requireNonNull(item4, "item4 is null");
        Objects.requireNonNull(item5, "item5 is null");
        Objects.requireNonNull(item6, "item6 is null");
        Objects.requireNonNull(item7, "item7 is null");
        Objects.requireNonNull(item8, "item8 is null");
        return Flowable.fromArray(item1, item2, item3, item4, item5, item6, item7, item8);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4, T item5, T item6, T item7, T item8, T item9) {
        Objects.requireNonNull(item1, "item1 is null");
        Objects.requireNonNull(item2, "item2 is null");
        Objects.requireNonNull(item3, "item3 is null");
        Objects.requireNonNull(item4, "item4 is null");
        Objects.requireNonNull(item5, "item5 is null");
        Objects.requireNonNull(item6, "item6 is null");
        Objects.requireNonNull(item7, "item7 is null");
        Objects.requireNonNull(item8, "item8 is null");
        Objects.requireNonNull(item9, "item9 is null");
        return Flowable.fromArray(item1, item2, item3, item4, item5, item6, item7, item8, item9);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4, T item5, T item6, T item7, T item8, T item9, T item10) {
        Objects.requireNonNull(item1, "item1 is null");
        Objects.requireNonNull(item2, "item2 is null");
        Objects.requireNonNull(item3, "item3 is null");
        Objects.requireNonNull(item4, "item4 is null");
        Objects.requireNonNull(item5, "item5 is null");
        Objects.requireNonNull(item6, "item6 is null");
        Objects.requireNonNull(item7, "item7 is null");
        Objects.requireNonNull(item8, "item8 is null");
        Objects.requireNonNull(item9, "item9 is null");
        Objects.requireNonNull(item10, "item10 is null");
        return Flowable.fromArray(item1, item2, item3, item4, item5, item6, item7, item8, item9, item10);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> merge(@NonNull @NonNull Iterable<@NonNull ? extends Publisher<@NonNull ? extends T>> sources, int maxConcurrency, int bufferSize) {
        return Flowable.fromIterable(sources).flatMap(Functions.identity(), false, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Flowable<T> mergeArray(int maxConcurrency, int bufferSize, Publisher<? extends T> ... sources) {
        return Flowable.fromArray(sources).flatMap(Functions.identity(), false, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> merge(@NonNull @NonNull Iterable<@NonNull ? extends Publisher<@NonNull ? extends T>> sources) {
        return Flowable.fromIterable(sources).flatMap(Functions.identity());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> merge(@NonNull @NonNull Iterable<@NonNull ? extends Publisher<@NonNull ? extends T>> sources, int maxConcurrency) {
        return Flowable.fromIterable(sources).flatMap(Functions.identity(), maxConcurrency);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> merge(@NonNull @NonNull Publisher<@NonNull ? extends Publisher<@NonNull ? extends T>> sources) {
        return Flowable.merge(sources, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> merge(@NonNull @NonNull Publisher<@NonNull ? extends Publisher<@NonNull ? extends T>> sources, int maxConcurrency) {
        return Flowable.fromPublisher(sources).flatMap(Functions.identity(), maxConcurrency);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Flowable<T> mergeArray(Publisher<? extends T> ... sources) {
        return Flowable.fromArray(sources).flatMap(Functions.identity(), sources.length);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> merge(@NonNull @NonNull Publisher<@NonNull ? extends T> source1, @NonNull @NonNull Publisher<@NonNull ? extends T> source2) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        return Flowable.fromArray(source1, source2).flatMap(Functions.identity(), false, 2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> merge(@NonNull @NonNull Publisher<@NonNull ? extends T> source1, @NonNull @NonNull Publisher<@NonNull ? extends T> source2, @NonNull @NonNull Publisher<@NonNull ? extends T> source3) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        return Flowable.fromArray(source1, source2, source3).flatMap(Functions.identity(), false, 3);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> merge(@NonNull @NonNull Publisher<@NonNull ? extends T> source1, @NonNull @NonNull Publisher<@NonNull ? extends T> source2, @NonNull @NonNull Publisher<@NonNull ? extends T> source3, @NonNull @NonNull Publisher<@NonNull ? extends T> source4) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        return Flowable.fromArray(source1, source2, source3, source4).flatMap(Functions.identity(), false, 4);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> mergeDelayError(@NonNull @NonNull Iterable<@NonNull ? extends Publisher<@NonNull ? extends T>> sources) {
        return Flowable.fromIterable(sources).flatMap(Functions.identity(), true);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> mergeDelayError(@NonNull @NonNull Iterable<@NonNull ? extends Publisher<@NonNull ? extends T>> sources, int maxConcurrency, int bufferSize) {
        return Flowable.fromIterable(sources).flatMap(Functions.identity(), true, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Flowable<T> mergeArrayDelayError(int maxConcurrency, int bufferSize, Publisher<? extends T> ... sources) {
        return Flowable.fromArray(sources).flatMap(Functions.identity(), true, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> mergeDelayError(@NonNull @NonNull Iterable<@NonNull ? extends Publisher<@NonNull ? extends T>> sources, int maxConcurrency) {
        return Flowable.fromIterable(sources).flatMap(Functions.identity(), true, maxConcurrency);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> mergeDelayError(@NonNull @NonNull Publisher<@NonNull ? extends Publisher<@NonNull ? extends T>> sources) {
        return Flowable.mergeDelayError(sources, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> mergeDelayError(@NonNull @NonNull Publisher<@NonNull ? extends Publisher<@NonNull ? extends T>> sources, int maxConcurrency) {
        return Flowable.fromPublisher(sources).flatMap(Functions.identity(), true, maxConcurrency);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Flowable<T> mergeArrayDelayError(Publisher<? extends T> ... sources) {
        return Flowable.fromArray(sources).flatMap(Functions.identity(), true, sources.length);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> mergeDelayError(@NonNull @NonNull Publisher<@NonNull ? extends T> source1, @NonNull @NonNull Publisher<@NonNull ? extends T> source2) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        return Flowable.fromArray(source1, source2).flatMap(Functions.identity(), true, 2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> mergeDelayError(@NonNull @NonNull Publisher<@NonNull ? extends T> source1, @NonNull @NonNull Publisher<@NonNull ? extends T> source2, @NonNull @NonNull Publisher<@NonNull ? extends T> source3) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        return Flowable.fromArray(source1, source2, source3).flatMap(Functions.identity(), true, 3);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> mergeDelayError(@NonNull @NonNull Publisher<@NonNull ? extends T> source1, @NonNull @NonNull Publisher<@NonNull ? extends T> source2, @NonNull @NonNull Publisher<@NonNull ? extends T> source3, @NonNull @NonNull Publisher<@NonNull ? extends T> source4) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        return Flowable.fromArray(source1, source2, source3, source4).flatMap(Functions.identity(), true, 4);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> never() {
        return RxJavaPlugins.onAssembly(FlowableNever.INSTANCE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static Flowable<Integer> range(int start, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count);
        }
        if (count == 0) {
            return Flowable.empty();
        }
        if (count == 1) {
            return Flowable.just(start);
        }
        if ((long)start + (long)(count - 1) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Integer overflow");
        }
        return RxJavaPlugins.onAssembly(new FlowableRange(start, count));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static Flowable<Long> rangeLong(long start, long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count);
        }
        if (count == 0L) {
            return Flowable.empty();
        }
        if (count == 1L) {
            return Flowable.just(start);
        }
        long end = start + (count - 1L);
        if (start > 0L && end < 0L) {
            throw new IllegalArgumentException("Overflow! start + count is bigger than Long.MAX_VALUE");
        }
        return RxJavaPlugins.onAssembly(new FlowableRangeLong(start, count));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<Boolean> sequenceEqual(@NonNull @NonNull Publisher<@NonNull ? extends T> source1, @NonNull @NonNull Publisher<@NonNull ? extends T> source2) {
        return Flowable.sequenceEqual(source1, source2, ObjectHelper.equalsPredicate(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<Boolean> sequenceEqual(@NonNull @NonNull Publisher<@NonNull ? extends T> source1, @NonNull @NonNull Publisher<@NonNull ? extends T> source2, @NonNull BiPredicate<? super T, ? super T> isEqual) {
        return Flowable.sequenceEqual(source1, source2, isEqual, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<Boolean> sequenceEqual(@NonNull @NonNull Publisher<@NonNull ? extends T> source1, @NonNull @NonNull Publisher<@NonNull ? extends T> source2, @NonNull BiPredicate<? super T, ? super T> isEqual, int bufferSize) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(isEqual, "isEqual is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableSequenceEqualSingle<T>(source1, source2, isEqual, bufferSize));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<Boolean> sequenceEqual(@NonNull @NonNull Publisher<@NonNull ? extends T> source1, @NonNull @NonNull Publisher<@NonNull ? extends T> source2, int bufferSize) {
        return Flowable.sequenceEqual(source1, source2, ObjectHelper.equalsPredicate(), bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> switchOnNext(@NonNull @NonNull Publisher<@NonNull ? extends Publisher<@NonNull ? extends T>> sources, int bufferSize) {
        return Flowable.fromPublisher(sources).switchMap(Functions.identity(), bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> switchOnNext(@NonNull @NonNull Publisher<@NonNull ? extends Publisher<@NonNull ? extends T>> sources) {
        return Flowable.fromPublisher(sources).switchMap(Functions.identity());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> switchOnNextDelayError(@NonNull @NonNull Publisher<@NonNull ? extends Publisher<@NonNull ? extends T>> sources) {
        return Flowable.switchOnNextDelayError(sources, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> switchOnNextDelayError(@NonNull @NonNull Publisher<@NonNull ? extends Publisher<@NonNull ? extends T>> sources, int prefetch) {
        return Flowable.fromPublisher(sources).switchMapDelayError(Functions.identity(), prefetch);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public static Flowable<Long> timer(long delay, @NonNull TimeUnit unit) {
        return Flowable.timer(delay, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public static Flowable<Long> timer(long delay, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableTimer(Math.max(0L, delay), unit, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.NONE)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> unsafeCreate(@NonNull Publisher<T> onSubscribe) {
        Objects.requireNonNull(onSubscribe, "onSubscribe is null");
        if (onSubscribe instanceof Flowable) {
            throw new IllegalArgumentException("unsafeCreate(Flowable) should be upgraded");
        }
        return RxJavaPlugins.onAssembly(new FlowableFromPublisher<T>(onSubscribe));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, D> Flowable<T> using(@NonNull Supplier<? extends D> resourceSupplier, @NonNull @NonNull Function<? super D, ? extends Publisher<@NonNull ? extends T>> sourceSupplier, @NonNull Consumer<? super D> resourceDisposer) {
        return Flowable.using(resourceSupplier, sourceSupplier, resourceDisposer, true);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, D> Flowable<T> using(@NonNull Supplier<? extends D> resourceSupplier, @NonNull @NonNull Function<? super D, ? extends Publisher<@NonNull ? extends T>> sourceSupplier, @NonNull Consumer<? super D> resourceDisposer, boolean eager) {
        Objects.requireNonNull(resourceSupplier, "resourceSupplier is null");
        Objects.requireNonNull(sourceSupplier, "sourceSupplier is null");
        Objects.requireNonNull(resourceDisposer, "resourceDisposer is null");
        return RxJavaPlugins.onAssembly(new FlowableUsing(resourceSupplier, sourceSupplier, resourceDisposer, eager));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, R> Flowable<R> zip(@NonNull @NonNull Iterable<@NonNull ? extends Publisher<@NonNull ? extends T>> sources, @NonNull Function<? super Object[], ? extends R> zipper) {
        Objects.requireNonNull(zipper, "zipper is null");
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new FlowableZip(null, sources, zipper, Flowable.bufferSize(), false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, R> Flowable<R> zip(@NonNull @NonNull Iterable<@NonNull ? extends Publisher<@NonNull ? extends T>> sources, @NonNull Function<? super Object[], ? extends R> zipper, boolean delayError, int bufferSize) {
        Objects.requireNonNull(zipper, "zipper is null");
        Objects.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableZip(null, sources, zipper, bufferSize, delayError));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, R> Flowable<R> zip(@NonNull @NonNull Publisher<@NonNull ? extends T1> source1, @NonNull @NonNull Publisher<@NonNull ? extends T2> source2, @NonNull BiFunction<? super T1, ? super T2, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, R> Flowable<R> zip(@NonNull @NonNull Publisher<@NonNull ? extends T1> source1, @NonNull @NonNull Publisher<@NonNull ? extends T2> source2, @NonNull BiFunction<? super T1, ? super T2, ? extends R> zipper, boolean delayError) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Flowable.zipArray(Functions.toFunction(zipper), delayError, Flowable.bufferSize(), source1, source2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, R> Flowable<R> zip(@NonNull @NonNull Publisher<@NonNull ? extends T1> source1, @NonNull @NonNull Publisher<@NonNull ? extends T2> source2, @NonNull BiFunction<? super T1, ? super T2, ? extends R> zipper, boolean delayError, int bufferSize) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Flowable.zipArray(Functions.toFunction(zipper), delayError, bufferSize, source1, source2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, R> Flowable<R> zip(@NonNull @NonNull Publisher<@NonNull ? extends T1> source1, @NonNull @NonNull Publisher<@NonNull ? extends T2> source2, @NonNull @NonNull Publisher<@NonNull ? extends T3> source3, @NonNull Function3<? super T1, ? super T2, ? super T3, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, R> Flowable<R> zip(@NonNull @NonNull Publisher<@NonNull ? extends T1> source1, @NonNull @NonNull Publisher<@NonNull ? extends T2> source2, @NonNull @NonNull Publisher<@NonNull ? extends T3> source3, @NonNull @NonNull Publisher<@NonNull ? extends T4> source4, @NonNull Function4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3, source4);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, R> Flowable<R> zip(@NonNull @NonNull Publisher<@NonNull ? extends T1> source1, @NonNull @NonNull Publisher<@NonNull ? extends T2> source2, @NonNull @NonNull Publisher<@NonNull ? extends T3> source3, @NonNull @NonNull Publisher<@NonNull ? extends T4> source4, @NonNull @NonNull Publisher<@NonNull ? extends T5> source5, @NonNull Function5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3, source4, source5);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, R> Flowable<R> zip(@NonNull @NonNull Publisher<@NonNull ? extends T1> source1, @NonNull @NonNull Publisher<@NonNull ? extends T2> source2, @NonNull @NonNull Publisher<@NonNull ? extends T3> source3, @NonNull @NonNull Publisher<@NonNull ? extends T4> source4, @NonNull @NonNull Publisher<@NonNull ? extends T5> source5, @NonNull @NonNull Publisher<@NonNull ? extends T6> source6, @NonNull Function6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3, source4, source5, source6);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, T7, R> Flowable<R> zip(@NonNull @NonNull Publisher<@NonNull ? extends T1> source1, @NonNull @NonNull Publisher<@NonNull ? extends T2> source2, @NonNull @NonNull Publisher<@NonNull ? extends T3> source3, @NonNull @NonNull Publisher<@NonNull ? extends T4> source4, @NonNull @NonNull Publisher<@NonNull ? extends T5> source5, @NonNull @NonNull Publisher<@NonNull ? extends T6> source6, @NonNull @NonNull Publisher<@NonNull ? extends T7> source7, @NonNull Function7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(source7, "source7 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3, source4, source5, source6, source7);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Flowable<R> zip(@NonNull @NonNull Publisher<@NonNull ? extends T1> source1, @NonNull @NonNull Publisher<@NonNull ? extends T2> source2, @NonNull @NonNull Publisher<@NonNull ? extends T3> source3, @NonNull @NonNull Publisher<@NonNull ? extends T4> source4, @NonNull @NonNull Publisher<@NonNull ? extends T5> source5, @NonNull @NonNull Publisher<@NonNull ? extends T6> source6, @NonNull @NonNull Publisher<@NonNull ? extends T7> source7, @NonNull @NonNull Publisher<@NonNull ? extends T8> source8, @NonNull Function8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(source7, "source7 is null");
        Objects.requireNonNull(source8, "source8 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3, source4, source5, source6, source7, source8);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Flowable<R> zip(@NonNull @NonNull Publisher<@NonNull ? extends T1> source1, @NonNull @NonNull Publisher<@NonNull ? extends T2> source2, @NonNull @NonNull Publisher<@NonNull ? extends T3> source3, @NonNull @NonNull Publisher<@NonNull ? extends T4> source4, @NonNull @NonNull Publisher<@NonNull ? extends T5> source5, @NonNull @NonNull Publisher<@NonNull ? extends T6> source6, @NonNull @NonNull Publisher<@NonNull ? extends T7> source7, @NonNull @NonNull Publisher<@NonNull ? extends T8> source8, @NonNull @NonNull Publisher<@NonNull ? extends T9> source9, @NonNull Function9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(source7, "source7 is null");
        Objects.requireNonNull(source8, "source8 is null");
        Objects.requireNonNull(source9, "source9 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3, source4, source5, source6, source7, source8, source9);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T, R> Flowable<R> zipArray(@NonNull Function<? super Object[], ? extends R> zipper, boolean delayError, int bufferSize, Publisher<? extends T> ... sources) {
        Objects.requireNonNull(sources, "sources is null");
        if (sources.length == 0) {
            return Flowable.empty();
        }
        Objects.requireNonNull(zipper, "zipper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableZip<T, R>(sources, null, zipper, bufferSize, delayError));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<Boolean> all(@NonNull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new FlowableAllSingle<T>(this, predicate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> ambWith(@NonNull @NonNull Publisher<@NonNull ? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return Flowable.ambArray(this, other);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<Boolean> any(@NonNull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new FlowableAnySingle<T>(this, predicate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final T blockingFirst() {
        BlockingFirstSubscriber s = new BlockingFirstSubscriber();
        this.subscribe(s);
        Object v = s.blockingGet();
        if (v != null) {
            return v;
        }
        throw new NoSuchElementException();
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final T blockingFirst(@NonNull T defaultItem) {
        Objects.requireNonNull(defaultItem, "defaultItem is null");
        BlockingFirstSubscriber s = new BlockingFirstSubscriber();
        this.subscribe(s);
        Object v = s.blockingGet();
        return v != null ? v : defaultItem;
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final void blockingForEach(@NonNull Consumer<? super T> onNext) {
        this.blockingForEach(onNext, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final void blockingForEach(@NonNull Consumer<? super T> onNext, int bufferSize) {
        Objects.requireNonNull(onNext, "onNext is null");
        Iterator<T> it = this.blockingIterable(bufferSize).iterator();
        while (it.hasNext()) {
            try {
                onNext.accept(it.next());
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                ((Disposable)((Object)it)).dispose();
                throw ExceptionHelper.wrapOrThrow(e);
            }
        }
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Iterable<T> blockingIterable() {
        return this.blockingIterable(Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Iterable<T> blockingIterable(int bufferSize) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return new BlockingFlowableIterable(this, bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final T blockingLast() {
        BlockingLastSubscriber s = new BlockingLastSubscriber();
        this.subscribe(s);
        Object v = s.blockingGet();
        if (v != null) {
            return v;
        }
        throw new NoSuchElementException();
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final T blockingLast(@NonNull T defaultItem) {
        Objects.requireNonNull(defaultItem, "defaultItem is null");
        BlockingLastSubscriber s = new BlockingLastSubscriber();
        this.subscribe(s);
        Object v = s.blockingGet();
        return v != null ? v : defaultItem;
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Iterable<T> blockingLatest() {
        return new BlockingFlowableLatest(this);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Iterable<T> blockingMostRecent(@NonNull T initialItem) {
        return new BlockingFlowableMostRecent<T>(this, initialItem);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Iterable<T> blockingNext() {
        return new BlockingFlowableNext(this);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final T blockingSingle() {
        return this.singleOrError().blockingGet();
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final T blockingSingle(@NonNull T defaultItem) {
        return this.single(defaultItem).blockingGet();
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Future<T> toFuture() {
        return this.subscribeWith(new FutureSubscriber());
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final void blockingSubscribe() {
        FlowableBlockingSubscribe.subscribe(this);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final void blockingSubscribe(@NonNull Consumer<? super T> onNext) {
        FlowableBlockingSubscribe.subscribe(this, onNext, Functions.ON_ERROR_MISSING, Functions.EMPTY_ACTION);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final void blockingSubscribe(@NonNull Consumer<? super T> onNext, int bufferSize) {
        FlowableBlockingSubscribe.subscribe(this, onNext, Functions.ON_ERROR_MISSING, Functions.EMPTY_ACTION, bufferSize);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final void blockingSubscribe(@NonNull Consumer<? super T> onNext, @NonNull Consumer<? super Throwable> onError) {
        FlowableBlockingSubscribe.subscribe(this, onNext, onError, Functions.EMPTY_ACTION);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final void blockingSubscribe(@NonNull Consumer<? super T> onNext, @NonNull Consumer<? super Throwable> onError, int bufferSize) {
        FlowableBlockingSubscribe.subscribe(this, onNext, onError, Functions.EMPTY_ACTION, bufferSize);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final void blockingSubscribe(@NonNull Consumer<? super T> onNext, @NonNull Consumer<? super Throwable> onError, @NonNull Action onComplete) {
        FlowableBlockingSubscribe.subscribe(this, onNext, onError, onComplete);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final void blockingSubscribe(@NonNull Consumer<? super T> onNext, @NonNull Consumer<? super Throwable> onError, @NonNull Action onComplete, int bufferSize) {
        FlowableBlockingSubscribe.subscribe(this, onNext, onError, onComplete, bufferSize);
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final void blockingSubscribe(@NonNull @NonNull Subscriber<@NonNull ? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        FlowableBlockingSubscribe.subscribe(this, subscriber);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<List<T>> buffer(int count) {
        return this.buffer(count, count);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<List<T>> buffer(int count, int skip) {
        return this.buffer(count, skip, ArrayListSupplier.asSupplier());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U extends Collection<? super T>> Flowable<U> buffer(int count, int skip, @NonNull Supplier<U> bufferSupplier) {
        ObjectHelper.verifyPositive(count, "count");
        ObjectHelper.verifyPositive(skip, "skip");
        Objects.requireNonNull(bufferSupplier, "bufferSupplier is null");
        return RxJavaPlugins.onAssembly(new FlowableBuffer(this, count, skip, bufferSupplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U extends Collection<? super T>> Flowable<U> buffer(int count, @NonNull Supplier<U> bufferSupplier) {
        return this.buffer(count, count, bufferSupplier);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<List<T>> buffer(long timespan, long timeskip, @NonNull TimeUnit unit) {
        return this.buffer(timespan, timeskip, unit, Schedulers.computation(), ArrayListSupplier.asSupplier());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<List<T>> buffer(long timespan, long timeskip, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.buffer(timespan, timeskip, unit, scheduler, ArrayListSupplier.asSupplier());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public final <U extends Collection<? super T>> Flowable<U> buffer(long timespan, long timeskip, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, @NonNull Supplier<U> bufferSupplier) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        Objects.requireNonNull(bufferSupplier, "bufferSupplier is null");
        return RxJavaPlugins.onAssembly(new FlowableBufferTimed(this, timespan, timeskip, unit, scheduler, bufferSupplier, Integer.MAX_VALUE, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<List<T>> buffer(long timespan, @NonNull TimeUnit unit) {
        return this.buffer(timespan, unit, Schedulers.computation(), Integer.MAX_VALUE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<List<T>> buffer(long timespan, @NonNull TimeUnit unit, int count) {
        return this.buffer(timespan, unit, Schedulers.computation(), count);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<List<T>> buffer(long timespan, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, int count) {
        return this.buffer(timespan, unit, scheduler, count, ArrayListSupplier.asSupplier(), false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public final <U extends Collection<? super T>> Flowable<U> buffer(long timespan, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, int count, @NonNull Supplier<U> bufferSupplier, boolean restartTimerOnMaxSize) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        Objects.requireNonNull(bufferSupplier, "bufferSupplier is null");
        ObjectHelper.verifyPositive(count, "count");
        return RxJavaPlugins.onAssembly(new FlowableBufferTimed(this, timespan, timespan, unit, scheduler, bufferSupplier, count, restartTimerOnMaxSize));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<List<T>> buffer(long timespan, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.buffer(timespan, unit, scheduler, Integer.MAX_VALUE, ArrayListSupplier.asSupplier(), false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final <TOpening, TClosing> Flowable<List<T>> buffer(@NonNull Flowable<? extends TOpening> openingIndicator, @NonNull @NonNull Function<? super TOpening, ? extends Publisher<@NonNull ? extends TClosing>> closingIndicator) {
        return this.buffer(openingIndicator, closingIndicator, ArrayListSupplier.asSupplier());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final <TOpening, TClosing, U extends Collection<? super T>> Flowable<U> buffer(@NonNull Flowable<? extends TOpening> openingIndicator, @NonNull @NonNull Function<? super TOpening, ? extends Publisher<@NonNull ? extends TClosing>> closingIndicator, @NonNull Supplier<U> bufferSupplier) {
        Objects.requireNonNull(openingIndicator, "openingIndicator is null");
        Objects.requireNonNull(closingIndicator, "closingIndicator is null");
        Objects.requireNonNull(bufferSupplier, "bufferSupplier is null");
        return RxJavaPlugins.onAssembly(new FlowableBufferBoundary(this, openingIndicator, closingIndicator, bufferSupplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final <B> Flowable<List<T>> buffer(@NonNull Publisher<B> boundaryIndicator) {
        return this.buffer(boundaryIndicator, ArrayListSupplier.asSupplier());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final <B> Flowable<List<T>> buffer(@NonNull Publisher<B> boundaryIndicator, int initialCapacity) {
        ObjectHelper.verifyPositive(initialCapacity, "initialCapacity");
        return this.buffer(boundaryIndicator, Functions.createArrayList(initialCapacity));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final <B, U extends Collection<? super T>> Flowable<U> buffer(@NonNull Publisher<B> boundaryIndicator, @NonNull Supplier<U> bufferSupplier) {
        Objects.requireNonNull(boundaryIndicator, "boundaryIndicator is null");
        Objects.requireNonNull(bufferSupplier, "bufferSupplier is null");
        return RxJavaPlugins.onAssembly(new FlowableBufferExactBoundary(this, boundaryIndicator, bufferSupplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> cache() {
        return this.cacheWithInitialCapacity(16);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> cacheWithInitialCapacity(int initialCapacity) {
        ObjectHelper.verifyPositive(initialCapacity, "initialCapacity");
        return RxJavaPlugins.onAssembly(new FlowableCache(this, initialCapacity));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Flowable<U> cast(@NonNull Class<U> clazz) {
        Objects.requireNonNull(clazz, "clazz is null");
        return this.map(Functions.castFunction(clazz));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Single<U> collect(@NonNull Supplier<? extends U> initialItemSupplier, @NonNull BiConsumer<? super U, ? super T> collector) {
        Objects.requireNonNull(initialItemSupplier, "initialItemSupplier is null");
        Objects.requireNonNull(collector, "collector is null");
        return RxJavaPlugins.onAssembly(new FlowableCollectSingle<T, U>(this, initialItemSupplier, collector));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Single<U> collectInto(U initialItem, @NonNull BiConsumer<? super U, ? super T> collector) {
        Objects.requireNonNull(initialItem, "initialItem is null");
        return this.collect(Functions.justSupplier(initialItem), collector);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> compose(@NonNull FlowableTransformer<? super T, ? extends R> composer) {
        return Flowable.fromPublisher(Objects.requireNonNull(composer, "composer is null").apply(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMap(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper) {
        return this.concatMap(mapper, 2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMap(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper, int prefetch) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        if (this instanceof ScalarSupplier) {
            Object v = ((ScalarSupplier)((Object)this)).get();
            if (v == null) {
                return Flowable.empty();
            }
            return FlowableScalarXMap.scalarXMap(v, mapper);
        }
        return RxJavaPlugins.onAssembly(new FlowableConcatMap(this, mapper, prefetch, ErrorMode.IMMEDIATE));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final <R> Flowable<R> concatMap(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper, int prefetch, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableConcatMapScheduler(this, mapper, prefetch, ErrorMode.IMMEDIATE, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public final Completable concatMapCompletable(@NonNull Function<? super T, ? extends CompletableSource> mapper) {
        return this.concatMapCompletable(mapper, 2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public final Completable concatMapCompletable(@NonNull Function<? super T, ? extends CompletableSource> mapper, int prefetch) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableConcatMapCompletable<T>(this, mapper, ErrorMode.IMMEDIATE, prefetch));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public final Completable concatMapCompletableDelayError(@NonNull Function<? super T, ? extends CompletableSource> mapper) {
        return this.concatMapCompletableDelayError(mapper, true, 2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public final Completable concatMapCompletableDelayError(@NonNull Function<? super T, ? extends CompletableSource> mapper, boolean tillTheEnd) {
        return this.concatMapCompletableDelayError(mapper, tillTheEnd, 2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public final Completable concatMapCompletableDelayError(@NonNull Function<? super T, ? extends CompletableSource> mapper, boolean tillTheEnd, int prefetch) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableConcatMapCompletable<T>(this, mapper, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY, prefetch));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMapDelayError(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper) {
        return this.concatMapDelayError(mapper, true, 2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMapDelayError(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper, boolean tillTheEnd, int prefetch) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        if (this instanceof ScalarSupplier) {
            Object v = ((ScalarSupplier)((Object)this)).get();
            if (v == null) {
                return Flowable.empty();
            }
            return FlowableScalarXMap.scalarXMap(v, mapper);
        }
        return RxJavaPlugins.onAssembly(new FlowableConcatMap(this, mapper, prefetch, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final <R> Flowable<R> concatMapDelayError(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper, boolean tillTheEnd, int prefetch, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableConcatMapScheduler(this, mapper, prefetch, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMapEager(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper) {
        return this.concatMapEager(mapper, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMapEager(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper, int maxConcurrency, int prefetch) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableConcatMapEager(this, mapper, maxConcurrency, prefetch, ErrorMode.IMMEDIATE));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMapEagerDelayError(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper, boolean tillTheEnd) {
        return this.concatMapEagerDelayError(mapper, tillTheEnd, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMapEagerDelayError(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper, boolean tillTheEnd, int maxConcurrency, int prefetch) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableConcatMapEager(this, mapper, maxConcurrency, prefetch, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Flowable<U> concatMapIterable(@NonNull @NonNull Function<? super T, ? extends Iterable<@NonNull ? extends U>> mapper) {
        return this.concatMapIterable(mapper, 2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Flowable<U> concatMapIterable(@NonNull @NonNull Function<? super T, ? extends Iterable<@NonNull ? extends U>> mapper, int prefetch) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableFlattenIterable(this, mapper, prefetch));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMapMaybe(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper) {
        return this.concatMapMaybe(mapper, 2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMapMaybe(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper, int prefetch) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableConcatMapMaybe(this, mapper, ErrorMode.IMMEDIATE, prefetch));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMapMaybeDelayError(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper) {
        return this.concatMapMaybeDelayError(mapper, true, 2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMapMaybeDelayError(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper, boolean tillTheEnd) {
        return this.concatMapMaybeDelayError(mapper, tillTheEnd, 2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMapMaybeDelayError(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper, boolean tillTheEnd, int prefetch) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableConcatMapMaybe(this, mapper, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY, prefetch));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMapSingle(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        return this.concatMapSingle(mapper, 2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMapSingle(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper, int prefetch) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableConcatMapSingle(this, mapper, ErrorMode.IMMEDIATE, prefetch));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMapSingleDelayError(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        return this.concatMapSingleDelayError(mapper, true, 2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMapSingleDelayError(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper, boolean tillTheEnd) {
        return this.concatMapSingleDelayError(mapper, tillTheEnd, 2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMapSingleDelayError(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper, boolean tillTheEnd, int prefetch) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableConcatMapSingle(this, mapper, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY, prefetch));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> concatWith(@NonNull @NonNull Publisher<@NonNull ? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return Flowable.concat(this, other);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> concatWith(@NonNull SingleSource<? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new FlowableConcatWithSingle<T>(this, other));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> concatWith(@NonNull MaybeSource<? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new FlowableConcatWithMaybe<T>(this, other));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> concatWith(@NonNull CompletableSource other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new FlowableConcatWithCompletable(this, other));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<Boolean> contains(@NonNull Object item) {
        Objects.requireNonNull(item, "item is null");
        return this.any(Functions.equalsWith(item));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<Long> count() {
        return RxJavaPlugins.onAssembly(new FlowableCountSingle(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Flowable<T> debounce(@NonNull Function<? super T, ? extends Publisher<U>> debounceIndicator) {
        Objects.requireNonNull(debounceIndicator, "debounceIndicator is null");
        return RxJavaPlugins.onAssembly(new FlowableDebounce(this, debounceIndicator));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<T> debounce(long timeout, @NonNull TimeUnit unit) {
        return this.debounce(timeout, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> debounce(long timeout, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableDebounceTimed(this, timeout, unit, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> defaultIfEmpty(@NonNull T defaultItem) {
        Objects.requireNonNull(defaultItem, "defaultItem is null");
        return this.switchIfEmpty(Flowable.just(defaultItem));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Flowable<T> delay(@NonNull Function<? super T, ? extends Publisher<U>> itemDelayIndicator) {
        Objects.requireNonNull(itemDelayIndicator, "itemDelayIndicator is null");
        return this.flatMap(FlowableInternalHelper.itemDelay(itemDelayIndicator));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<T> delay(long delay, @NonNull TimeUnit unit) {
        return this.delay(delay, unit, Schedulers.computation(), false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<T> delay(long delay, @NonNull TimeUnit unit, boolean delayError) {
        return this.delay(delay, unit, Schedulers.computation(), delayError);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> delay(long delay, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.delay(delay, unit, scheduler, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> delay(long delay, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean delayError) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableDelay(this, Math.max(0L, delay), unit, scheduler, delayError));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, V> Flowable<T> delay(@NonNull Publisher<U> subscriptionIndicator, @NonNull Function<? super T, ? extends Publisher<V>> itemDelayIndicator) {
        return this.delaySubscription(subscriptionIndicator).delay(itemDelayIndicator);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Flowable<T> delaySubscription(@NonNull Publisher<U> subscriptionIndicator) {
        Objects.requireNonNull(subscriptionIndicator, "subscriptionIndicator is null");
        return RxJavaPlugins.onAssembly(new FlowableDelaySubscriptionOther(this, subscriptionIndicator));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<T> delaySubscription(long delay, @NonNull TimeUnit unit) {
        return this.delaySubscription(delay, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> delaySubscription(long delay, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.delaySubscription(Flowable.timer(delay, unit, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @NonNull
    public final <R> Flowable<R> dematerialize(@NonNull @NonNull Function<@NonNull ? super T, @NonNull Notification<R>> selector) {
        Objects.requireNonNull(selector, "selector is null");
        return RxJavaPlugins.onAssembly(new FlowableDematerialize<T, R>(this, selector));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> distinct() {
        return this.distinct(Functions.identity(), Functions.createHashSet());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <K> Flowable<T> distinct(@NonNull Function<? super T, K> keySelector) {
        return this.distinct(keySelector, Functions.createHashSet());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <K> Flowable<T> distinct(@NonNull Function<? super T, K> keySelector, @NonNull Supplier<? extends Collection<? super K>> collectionSupplier) {
        Objects.requireNonNull(keySelector, "keySelector is null");
        Objects.requireNonNull(collectionSupplier, "collectionSupplier is null");
        return RxJavaPlugins.onAssembly(new FlowableDistinct<T, K>(this, keySelector, collectionSupplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> distinctUntilChanged() {
        return this.distinctUntilChanged(Functions.identity());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <K> Flowable<T> distinctUntilChanged(@NonNull Function<? super T, K> keySelector) {
        Objects.requireNonNull(keySelector, "keySelector is null");
        return RxJavaPlugins.onAssembly(new FlowableDistinctUntilChanged<T, K>(this, keySelector, ObjectHelper.equalsPredicate()));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> distinctUntilChanged(@NonNull BiPredicate<? super T, ? super T> comparer) {
        Objects.requireNonNull(comparer, "comparer is null");
        return RxJavaPlugins.onAssembly(new FlowableDistinctUntilChanged(this, Functions.identity(), comparer));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> doFinally(@NonNull Action onFinally) {
        Objects.requireNonNull(onFinally, "onFinally is null");
        return RxJavaPlugins.onAssembly(new FlowableDoFinally(this, onFinally));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> doAfterNext(@NonNull Consumer<? super T> onAfterNext) {
        Objects.requireNonNull(onAfterNext, "onAfterNext is null");
        return RxJavaPlugins.onAssembly(new FlowableDoAfterNext<T>(this, onAfterNext));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> doAfterTerminate(@NonNull Action onAfterTerminate) {
        return this.doOnEach(Functions.emptyConsumer(), Functions.emptyConsumer(), Functions.EMPTY_ACTION, onAfterTerminate);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> doOnCancel(@NonNull Action onCancel) {
        return this.doOnLifecycle(Functions.emptyConsumer(), Functions.EMPTY_LONG_CONSUMER, onCancel);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> doOnComplete(@NonNull Action onComplete) {
        return this.doOnEach(Functions.emptyConsumer(), Functions.emptyConsumer(), onComplete, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    private Flowable<T> doOnEach(@NonNull Consumer<? super T> onNext, @NonNull Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminate) {
        Objects.requireNonNull(onNext, "onNext is null");
        Objects.requireNonNull(onError, "onError is null");
        Objects.requireNonNull(onComplete, "onComplete is null");
        Objects.requireNonNull(onAfterTerminate, "onAfterTerminate is null");
        return RxJavaPlugins.onAssembly(new FlowableDoOnEach<T>(this, onNext, onError, onComplete, onAfterTerminate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> doOnEach(@NonNull @NonNull Consumer<@NonNull ? super Notification<T>> onNotification) {
        Objects.requireNonNull(onNotification, "onNotification is null");
        return this.doOnEach(Functions.notificationOnNext(onNotification), Functions.notificationOnError(onNotification), Functions.notificationOnComplete(onNotification), Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> doOnEach(@NonNull @NonNull Subscriber<@NonNull ? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        return this.doOnEach(FlowableInternalHelper.subscriberOnNext(subscriber), FlowableInternalHelper.subscriberOnError(subscriber), FlowableInternalHelper.subscriberOnComplete(subscriber), Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> doOnError(@NonNull Consumer<? super Throwable> onError) {
        return this.doOnEach(Functions.emptyConsumer(), onError, Functions.EMPTY_ACTION, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> doOnLifecycle(@NonNull Consumer<? super Subscription> onSubscribe, @NonNull LongConsumer onRequest, @NonNull Action onCancel) {
        Objects.requireNonNull(onSubscribe, "onSubscribe is null");
        Objects.requireNonNull(onRequest, "onRequest is null");
        Objects.requireNonNull(onCancel, "onCancel is null");
        return RxJavaPlugins.onAssembly(new FlowableDoOnLifecycle(this, onSubscribe, onRequest, onCancel));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> doOnNext(@NonNull Consumer<? super T> onNext) {
        return this.doOnEach(onNext, Functions.emptyConsumer(), Functions.EMPTY_ACTION, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> doOnRequest(@NonNull LongConsumer onRequest) {
        return this.doOnLifecycle(Functions.emptyConsumer(), onRequest, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> doOnSubscribe(@NonNull Consumer<? super Subscription> onSubscribe) {
        return this.doOnLifecycle(onSubscribe, Functions.EMPTY_LONG_CONSUMER, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> doOnTerminate(@NonNull Action onTerminate) {
        return this.doOnEach(Functions.emptyConsumer(), Functions.actionConsumer(onTerminate), onTerminate, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Maybe<T> elementAt(long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("index >= 0 required but it was " + index);
        }
        return RxJavaPlugins.onAssembly(new FlowableElementAtMaybe(this, index));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> elementAt(long index, @NonNull T defaultItem) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("index >= 0 required but it was " + index);
        }
        Objects.requireNonNull(defaultItem, "defaultItem is null");
        return RxJavaPlugins.onAssembly(new FlowableElementAtSingle<T>(this, index, defaultItem));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> elementAtOrError(long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("index >= 0 required but it was " + index);
        }
        return RxJavaPlugins.onAssembly(new FlowableElementAtSingle<Object>(this, index, null));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> filter(@NonNull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new FlowableFilter<T>(this, predicate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Maybe<T> firstElement() {
        return this.elementAt(0L);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> first(@NonNull T defaultItem) {
        return this.elementAt(0L, defaultItem);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> firstOrError() {
        return this.elementAtOrError(0L);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> flatMap(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper) {
        return this.flatMap(mapper, false, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> flatMap(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper, boolean delayErrors) {
        return this.flatMap(mapper, delayErrors, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> flatMap(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper, int maxConcurrency) {
        return this.flatMap(mapper, false, maxConcurrency, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> flatMap(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper, boolean delayErrors, int maxConcurrency) {
        return this.flatMap(mapper, delayErrors, maxConcurrency, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> flatMap(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        if (this instanceof ScalarSupplier) {
            Object v = ((ScalarSupplier)((Object)this)).get();
            if (v == null) {
                return Flowable.empty();
            }
            return FlowableScalarXMap.scalarXMap(v, mapper);
        }
        return RxJavaPlugins.onAssembly(new FlowableFlatMap(this, mapper, delayErrors, maxConcurrency, bufferSize));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> flatMap(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> onNextMapper, @NonNull @NonNull Function<? super Throwable, ? extends Publisher<@NonNull ? extends R>> onErrorMapper, @NonNull @NonNull Supplier<? extends Publisher<@NonNull ? extends R>> onCompleteSupplier) {
        Objects.requireNonNull(onNextMapper, "onNextMapper is null");
        Objects.requireNonNull(onErrorMapper, "onErrorMapper is null");
        Objects.requireNonNull(onCompleteSupplier, "onCompleteSupplier is null");
        return Flowable.merge(new FlowableMapNotification<T, Publisher<? extends R>>(this, onNextMapper, onErrorMapper, onCompleteSupplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> flatMap(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> onNextMapper, @NonNull @NonNull Function<Throwable, ? extends Publisher<@NonNull ? extends R>> onErrorMapper, @NonNull @NonNull Supplier<? extends Publisher<@NonNull ? extends R>> onCompleteSupplier, int maxConcurrency) {
        Objects.requireNonNull(onNextMapper, "onNextMapper is null");
        Objects.requireNonNull(onErrorMapper, "onErrorMapper is null");
        Objects.requireNonNull(onCompleteSupplier, "onCompleteSupplier is null");
        return Flowable.merge(new FlowableMapNotification<T, Publisher<? extends R>>(this, onNextMapper, onErrorMapper, onCompleteSupplier), maxConcurrency);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Flowable<R> flatMap(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends U>> mapper, @NonNull BiFunction<? super T, ? super U, ? extends R> combiner) {
        return this.flatMap(mapper, combiner, false, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Flowable<R> flatMap(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends U>> mapper, @NonNull BiFunction<? super T, ? super U, ? extends R> combiner, boolean delayErrors) {
        return this.flatMap(mapper, combiner, delayErrors, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Flowable<R> flatMap(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends U>> mapper, @NonNull BiFunction<? super T, ? super U, ? extends R> combiner, boolean delayErrors, int maxConcurrency) {
        return this.flatMap(mapper, combiner, delayErrors, maxConcurrency, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Flowable<R> flatMap(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends U>> mapper, @NonNull BiFunction<? super T, ? super U, ? extends R> combiner, boolean delayErrors, int maxConcurrency, int bufferSize) {
        Objects.requireNonNull(mapper, "mapper is null");
        Objects.requireNonNull(combiner, "combiner is null");
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return this.flatMap(FlowableInternalHelper.flatMapWithCombiner(mapper, combiner), delayErrors, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Flowable<R> flatMap(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends U>> mapper, @NonNull BiFunction<? super T, ? super U, ? extends R> combiner, int maxConcurrency) {
        return this.flatMap(mapper, combiner, false, maxConcurrency, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable flatMapCompletable(@NonNull Function<? super T, ? extends CompletableSource> mapper) {
        return this.flatMapCompletable(mapper, false, Integer.MAX_VALUE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable flatMapCompletable(@NonNull Function<? super T, ? extends CompletableSource> mapper, boolean delayErrors, int maxConcurrency) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        return RxJavaPlugins.onAssembly(new FlowableFlatMapCompletableCompletable<T>(this, mapper, delayErrors, maxConcurrency));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Flowable<U> flatMapIterable(@NonNull @NonNull Function<? super T, ? extends Iterable<@NonNull ? extends U>> mapper) {
        return this.flatMapIterable(mapper, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Flowable<U> flatMapIterable(@NonNull @NonNull Function<? super T, ? extends Iterable<@NonNull ? extends U>> mapper, int bufferSize) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableFlattenIterable(this, mapper, bufferSize));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, V> Flowable<V> flatMapIterable(@NonNull @NonNull Function<? super T, ? extends Iterable<@NonNull ? extends U>> mapper, @NonNull BiFunction<? super T, ? super U, ? extends V> combiner) {
        Objects.requireNonNull(mapper, "mapper is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return this.flatMap(FlowableInternalHelper.flatMapIntoIterable(mapper), combiner, false, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, V> Flowable<V> flatMapIterable(@NonNull @NonNull Function<? super T, ? extends Iterable<@NonNull ? extends U>> mapper, @NonNull BiFunction<? super T, ? super U, ? extends V> combiner, int prefetch) {
        Objects.requireNonNull(mapper, "mapper is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return this.flatMap(FlowableInternalHelper.flatMapIntoIterable(mapper), combiner, false, Flowable.bufferSize(), prefetch);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> flatMapMaybe(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper) {
        return this.flatMapMaybe(mapper, false, Integer.MAX_VALUE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> flatMapMaybe(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper, boolean delayErrors, int maxConcurrency) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        return RxJavaPlugins.onAssembly(new FlowableFlatMapMaybe(this, mapper, delayErrors, maxConcurrency));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> flatMapSingle(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        return this.flatMapSingle(mapper, false, Integer.MAX_VALUE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> flatMapSingle(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper, boolean delayErrors, int maxConcurrency) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        return RxJavaPlugins.onAssembly(new FlowableFlatMapSingle(this, mapper, delayErrors, maxConcurrency));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.NONE)
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable forEach(@NonNull Consumer<? super T> onNext) {
        return this.subscribe(onNext);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.NONE)
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable forEachWhile(@NonNull Predicate<? super T> onNext) {
        return this.forEachWhile(onNext, Functions.ON_ERROR_MISSING, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.NONE)
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable forEachWhile(@NonNull Predicate<? super T> onNext, @NonNull Consumer<? super Throwable> onError) {
        return this.forEachWhile(onNext, onError, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.NONE)
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable forEachWhile(@NonNull Predicate<? super T> onNext, @NonNull Consumer<? super Throwable> onError, @NonNull Action onComplete) {
        Objects.requireNonNull(onNext, "onNext is null");
        Objects.requireNonNull(onError, "onError is null");
        Objects.requireNonNull(onComplete, "onComplete is null");
        ForEachWhileSubscriber<? super T> s = new ForEachWhileSubscriber<T>(onNext, onError, onComplete);
        this.subscribe((FlowableSubscriber<? super T>)s);
        return s;
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final <K> Flowable<GroupedFlowable<K, T>> groupBy(@NonNull Function<? super T, ? extends K> keySelector) {
        return this.groupBy(keySelector, Functions.identity(), false, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final <K> Flowable<GroupedFlowable<K, T>> groupBy(@NonNull Function<? super T, ? extends K> keySelector, boolean delayError) {
        return this.groupBy(keySelector, Functions.identity(), delayError, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final <K, V> Flowable<GroupedFlowable<K, V>> groupBy(@NonNull Function<? super T, ? extends K> keySelector, @NonNull Function<? super T, ? extends V> valueSelector) {
        return this.groupBy(keySelector, valueSelector, false, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final <K, V> Flowable<GroupedFlowable<K, V>> groupBy(@NonNull Function<? super T, ? extends K> keySelector, @NonNull Function<? super T, ? extends V> valueSelector, boolean delayError) {
        return this.groupBy(keySelector, valueSelector, delayError, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <K, V> Flowable<GroupedFlowable<K, V>> groupBy(@NonNull Function<? super T, ? extends K> keySelector, @NonNull Function<? super T, ? extends V> valueSelector, boolean delayError, int bufferSize) {
        Objects.requireNonNull(keySelector, "keySelector is null");
        Objects.requireNonNull(valueSelector, "valueSelector is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableGroupBy<T, K, V>(this, keySelector, valueSelector, bufferSize, delayError, null));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <K, V> Flowable<GroupedFlowable<K, V>> groupBy(@NonNull Function<? super T, ? extends K> keySelector, @NonNull Function<? super T, ? extends V> valueSelector, boolean delayError, int bufferSize, @NonNull Function<? super Consumer<Object>, ? extends Map<K, Object>> evictingMapFactory) {
        Objects.requireNonNull(keySelector, "keySelector is null");
        Objects.requireNonNull(valueSelector, "valueSelector is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        Objects.requireNonNull(evictingMapFactory, "evictingMapFactory is null");
        return RxJavaPlugins.onAssembly(new FlowableGroupBy<T, K, V>(this, keySelector, valueSelector, bufferSize, delayError, evictingMapFactory));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final <TRight, TLeftEnd, TRightEnd, R> Flowable<R> groupJoin(@NonNull @NonNull Publisher<@NonNull ? extends TRight> other, @NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull TLeftEnd>> leftEnd, @NonNull @NonNull Function<? super TRight, ? extends Publisher<@NonNull TRightEnd>> rightEnd, @NonNull BiFunction<? super T, ? super Flowable<TRight>, ? extends R> resultSelector) {
        Objects.requireNonNull(other, "other is null");
        Objects.requireNonNull(leftEnd, "leftEnd is null");
        Objects.requireNonNull(rightEnd, "rightEnd is null");
        Objects.requireNonNull(resultSelector, "resultSelector is null");
        return RxJavaPlugins.onAssembly(new FlowableGroupJoin(this, other, leftEnd, rightEnd, resultSelector));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> hide() {
        return RxJavaPlugins.onAssembly(new FlowableHide(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable ignoreElements() {
        return RxJavaPlugins.onAssembly(new FlowableIgnoreElementsCompletable(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<Boolean> isEmpty() {
        return this.all(Functions.alwaysFalse());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final <TRight, TLeftEnd, TRightEnd, R> Flowable<R> join(@NonNull @NonNull Publisher<@NonNull ? extends TRight> other, @NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull TLeftEnd>> leftEnd, @NonNull @NonNull Function<? super TRight, ? extends Publisher<@NonNull TRightEnd>> rightEnd, @NonNull BiFunction<? super T, ? super TRight, ? extends R> resultSelector) {
        Objects.requireNonNull(other, "other is null");
        Objects.requireNonNull(leftEnd, "leftEnd is null");
        Objects.requireNonNull(rightEnd, "rightEnd is null");
        Objects.requireNonNull(resultSelector, "resultSelector is null");
        return RxJavaPlugins.onAssembly(new FlowableJoin(this, other, leftEnd, rightEnd, resultSelector));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Maybe<T> lastElement() {
        return RxJavaPlugins.onAssembly(new FlowableLastMaybe(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> last(@NonNull T defaultItem) {
        Objects.requireNonNull(defaultItem, "defaultItem is null");
        return RxJavaPlugins.onAssembly(new FlowableLastSingle<T>(this, defaultItem));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> lastOrError() {
        return RxJavaPlugins.onAssembly(new FlowableLastSingle<Object>(this, null));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> lift(@NonNull FlowableOperator<? extends R, ? super T> lifter) {
        Objects.requireNonNull(lifter, "lifter is null");
        return RxJavaPlugins.onAssembly(new FlowableLift<R, T>(this, lifter));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> map(@NonNull Function<? super T, ? extends R> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new FlowableMap<T, R>(this, mapper));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<Notification<T>> materialize() {
        return RxJavaPlugins.onAssembly(new FlowableMaterialize(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> mergeWith(@NonNull @NonNull Publisher<@NonNull ? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return Flowable.merge(this, other);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> mergeWith(@NonNull SingleSource<? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new FlowableMergeWithSingle<T>(this, other));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> mergeWith(@NonNull MaybeSource<? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new FlowableMergeWithMaybe<T>(this, other));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> mergeWith(@NonNull CompletableSource other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new FlowableMergeWithCompletable(this, other));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> observeOn(@NonNull Scheduler scheduler) {
        return this.observeOn(scheduler, false, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> observeOn(@NonNull Scheduler scheduler, boolean delayError) {
        return this.observeOn(scheduler, delayError, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> observeOn(@NonNull Scheduler scheduler, boolean delayError, int bufferSize) {
        Objects.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableObserveOn(this, scheduler, delayError, bufferSize));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Flowable<U> ofType(@NonNull Class<U> clazz) {
        Objects.requireNonNull(clazz, "clazz is null");
        return this.filter(Functions.isInstanceOf(clazz)).cast(clazz);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> onBackpressureBuffer() {
        return this.onBackpressureBuffer(Flowable.bufferSize(), false, true);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> onBackpressureBuffer(boolean delayError) {
        return this.onBackpressureBuffer(Flowable.bufferSize(), delayError, true);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> onBackpressureBuffer(int capacity) {
        return this.onBackpressureBuffer(capacity, false, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> onBackpressureBuffer(int capacity, boolean delayError) {
        return this.onBackpressureBuffer(capacity, delayError, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> onBackpressureBuffer(int capacity, boolean delayError, boolean unbounded) {
        ObjectHelper.verifyPositive(capacity, "capacity");
        return RxJavaPlugins.onAssembly(new FlowableOnBackpressureBuffer(this, capacity, unbounded, delayError, Functions.EMPTY_ACTION));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> onBackpressureBuffer(int capacity, boolean delayError, boolean unbounded, @NonNull Action onOverflow) {
        Objects.requireNonNull(onOverflow, "onOverflow is null");
        ObjectHelper.verifyPositive(capacity, "capacity");
        return RxJavaPlugins.onAssembly(new FlowableOnBackpressureBuffer(this, capacity, unbounded, delayError, onOverflow));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> onBackpressureBuffer(int capacity, @NonNull Action onOverflow) {
        return this.onBackpressureBuffer(capacity, false, false, onOverflow);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> onBackpressureBuffer(long capacity, @Nullable Action onOverflow, @NonNull BackpressureOverflowStrategy overflowStrategy) {
        Objects.requireNonNull(overflowStrategy, "overflowStrategy is null");
        ObjectHelper.verifyPositive(capacity, "capacity");
        return RxJavaPlugins.onAssembly(new FlowableOnBackpressureBufferStrategy(this, capacity, onOverflow, overflowStrategy));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> onBackpressureDrop() {
        return RxJavaPlugins.onAssembly(new FlowableOnBackpressureDrop(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> onBackpressureDrop(@NonNull Consumer<? super T> onDrop) {
        Objects.requireNonNull(onDrop, "onDrop is null");
        return RxJavaPlugins.onAssembly(new FlowableOnBackpressureDrop<T>(this, onDrop));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> onBackpressureLatest() {
        return RxJavaPlugins.onAssembly(new FlowableOnBackpressureLatest(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> onErrorResumeNext(@NonNull @NonNull Function<? super Throwable, ? extends Publisher<@NonNull ? extends T>> resumeFunction) {
        Objects.requireNonNull(resumeFunction, "resumeFunction is null");
        return RxJavaPlugins.onAssembly(new FlowableOnErrorNext(this, resumeFunction));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> onErrorResumeWith(@NonNull @NonNull Publisher<@NonNull ? extends T> next) {
        Objects.requireNonNull(next, "next is null");
        return this.onErrorResumeNext(Functions.justFunction(next));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> onErrorReturn(@NonNull Function<? super Throwable, ? extends T> valueSupplier) {
        Objects.requireNonNull(valueSupplier, "valueSupplier is null");
        return RxJavaPlugins.onAssembly(new FlowableOnErrorReturn<T>(this, valueSupplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> onErrorReturnItem(@NonNull T item) {
        Objects.requireNonNull(item, "item is null");
        return this.onErrorReturn(Functions.justFunction(item));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> onTerminateDetach() {
        return RxJavaPlugins.onAssembly(new FlowableDetach(this));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NonNull
    public final ParallelFlowable<T> parallel() {
        return ParallelFlowable.from(this);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NonNull
    public final ParallelFlowable<T> parallel(int parallelism) {
        return ParallelFlowable.from(this, parallelism);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NonNull
    public final ParallelFlowable<T> parallel(int parallelism, int prefetch) {
        return ParallelFlowable.from(this, parallelism, prefetch);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final ConnectableFlowable<T> publish() {
        return this.publish(Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> publish(@NonNull Function<? super Flowable<T>, ? extends Publisher<R>> selector) {
        return this.publish(selector, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> publish(@NonNull @NonNull Function<? super Flowable<T>, ? extends Publisher<@NonNull ? extends R>> selector, int prefetch) {
        Objects.requireNonNull(selector, "selector is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowablePublishMulticast(this, selector, prefetch, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final ConnectableFlowable<T> publish(int bufferSize) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowablePublish(this, bufferSize));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> rebatchRequests(int n) {
        return this.observeOn(ImmediateThinScheduler.INSTANCE, true, n);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Maybe<T> reduce(@NonNull BiFunction<T, T, T> reducer) {
        Objects.requireNonNull(reducer, "reducer is null");
        return RxJavaPlugins.onAssembly(new FlowableReduceMaybe<T>(this, reducer));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Single<R> reduce(R seed, @NonNull BiFunction<R, ? super T, R> reducer) {
        Objects.requireNonNull(seed, "seed is null");
        Objects.requireNonNull(reducer, "reducer is null");
        return RxJavaPlugins.onAssembly(new FlowableReduceSeedSingle<T, R>(this, seed, reducer));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Single<R> reduceWith(@NonNull Supplier<R> seedSupplier, @NonNull BiFunction<R, ? super T, R> reducer) {
        Objects.requireNonNull(seedSupplier, "seedSupplier is null");
        Objects.requireNonNull(reducer, "reducer is null");
        return RxJavaPlugins.onAssembly(new FlowableReduceWithSingle<T, R>(this, seedSupplier, reducer));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> repeat() {
        return this.repeat(Long.MAX_VALUE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> repeat(long times) {
        if (times < 0L) {
            throw new IllegalArgumentException("times >= 0 required but it was " + times);
        }
        if (times == 0L) {
            return Flowable.empty();
        }
        return RxJavaPlugins.onAssembly(new FlowableRepeat(this, times));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> repeatUntil(@NonNull BooleanSupplier stop) {
        Objects.requireNonNull(stop, "stop is null");
        return RxJavaPlugins.onAssembly(new FlowableRepeatUntil(this, stop));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> repeatWhen(@NonNull @NonNull Function<? super Flowable<Object>, ? extends Publisher<@NonNull ?>> handler) {
        Objects.requireNonNull(handler, "handler is null");
        return RxJavaPlugins.onAssembly(new FlowableRepeatWhen(this, handler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final ConnectableFlowable<T> replay() {
        return FlowableReplay.createFrom(this);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> replay(@NonNull Function<? super Flowable<T>, ? extends Publisher<R>> selector) {
        Objects.requireNonNull(selector, "selector is null");
        return FlowableReplay.multicastSelector(FlowableInternalHelper.replaySupplier(this), selector);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> replay(@NonNull Function<? super Flowable<T>, ? extends Publisher<R>> selector, int bufferSize) {
        Objects.requireNonNull(selector, "selector is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return FlowableReplay.multicastSelector(FlowableInternalHelper.replaySupplier(this, bufferSize, false), selector);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> replay(@NonNull Function<? super Flowable<T>, ? extends Publisher<R>> selector, int bufferSize, boolean eagerTruncate) {
        Objects.requireNonNull(selector, "selector is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return FlowableReplay.multicastSelector(FlowableInternalHelper.replaySupplier(this, bufferSize, eagerTruncate), selector);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final <R> Flowable<R> replay(@NonNull Function<? super Flowable<T>, ? extends Publisher<R>> selector, int bufferSize, long time, @NonNull TimeUnit unit) {
        return this.replay(selector, bufferSize, time, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final <R> Flowable<R> replay(@NonNull Function<? super Flowable<T>, ? extends Publisher<R>> selector, int bufferSize, long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(selector, "selector is null");
        Objects.requireNonNull(unit, "unit is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return FlowableReplay.multicastSelector(FlowableInternalHelper.replaySupplier(this, bufferSize, time, unit, scheduler, false), selector);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final <R> Flowable<R> replay(@NonNull Function<? super Flowable<T>, ? extends Publisher<R>> selector, int bufferSize, long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean eagerTruncate) {
        Objects.requireNonNull(selector, "selector is null");
        Objects.requireNonNull(unit, "unit is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return FlowableReplay.multicastSelector(FlowableInternalHelper.replaySupplier(this, bufferSize, time, unit, scheduler, eagerTruncate), selector);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final <R> Flowable<R> replay(@NonNull Function<? super Flowable<T>, ? extends Publisher<R>> selector, long time, @NonNull TimeUnit unit) {
        return this.replay(selector, time, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final <R> Flowable<R> replay(@NonNull Function<? super Flowable<T>, ? extends Publisher<R>> selector, long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(selector, "selector is null");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return FlowableReplay.multicastSelector(FlowableInternalHelper.replaySupplier(this, time, unit, scheduler, false), selector);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final <R> Flowable<R> replay(@NonNull Function<? super Flowable<T>, ? extends Publisher<R>> selector, long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean eagerTruncate) {
        Objects.requireNonNull(selector, "selector is null");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return FlowableReplay.multicastSelector(FlowableInternalHelper.replaySupplier(this, time, unit, scheduler, eagerTruncate), selector);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final ConnectableFlowable<T> replay(int bufferSize) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return FlowableReplay.create(this, bufferSize, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final ConnectableFlowable<T> replay(int bufferSize, boolean eagerTruncate) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return FlowableReplay.create(this, bufferSize, eagerTruncate);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final ConnectableFlowable<T> replay(int bufferSize, long time, @NonNull TimeUnit unit) {
        return this.replay(bufferSize, time, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final ConnectableFlowable<T> replay(int bufferSize, long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return FlowableReplay.create(this, time, unit, scheduler, bufferSize, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final ConnectableFlowable<T> replay(int bufferSize, long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean eagerTruncate) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return FlowableReplay.create(this, time, unit, scheduler, bufferSize, eagerTruncate);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final ConnectableFlowable<T> replay(long time, @NonNull TimeUnit unit) {
        return this.replay(time, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final ConnectableFlowable<T> replay(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return FlowableReplay.create(this, time, unit, scheduler, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final ConnectableFlowable<T> replay(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean eagerTruncate) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return FlowableReplay.create(this, time, unit, scheduler, eagerTruncate);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> retry() {
        return this.retry(Long.MAX_VALUE, Functions.alwaysTrue());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> retry(@NonNull @NonNull BiPredicate<@NonNull ? super Integer, @NonNull ? super Throwable> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new FlowableRetryBiPredicate(this, predicate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> retry(long times) {
        return this.retry(times, Functions.alwaysTrue());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> retry(long times, @NonNull @NonNull Predicate<@NonNull ? super Throwable> predicate) {
        if (times < 0L) {
            throw new IllegalArgumentException("times >= 0 required but it was " + times);
        }
        Objects.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new FlowableRetryPredicate(this, times, predicate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> retry(@NonNull @NonNull Predicate<@NonNull ? super Throwable> predicate) {
        return this.retry(Long.MAX_VALUE, predicate);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> retryUntil(@NonNull BooleanSupplier stop) {
        Objects.requireNonNull(stop, "stop is null");
        return this.retry(Long.MAX_VALUE, Functions.predicateReverseFor(stop));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> retryWhen(@NonNull @NonNull Function<? super Flowable<Throwable>, ? extends Publisher<@NonNull ?>> handler) {
        Objects.requireNonNull(handler, "handler is null");
        return RxJavaPlugins.onAssembly(new FlowableRetryWhen(this, handler));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final void safeSubscribe(@NonNull @NonNull Subscriber<@NonNull ? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        if (subscriber instanceof SafeSubscriber) {
            this.subscribe((SafeSubscriber)subscriber);
        } else {
            this.subscribe((FlowableSubscriber<? super T>)new SafeSubscriber<T>(subscriber));
        }
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<T> sample(long period, @NonNull TimeUnit unit) {
        return this.sample(period, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<T> sample(long period, @NonNull TimeUnit unit, boolean emitLast) {
        return this.sample(period, unit, Schedulers.computation(), emitLast);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> sample(long period, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableSampleTimed(this, period, unit, scheduler, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> sample(long period, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean emitLast) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableSampleTimed(this, period, unit, scheduler, emitLast));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Flowable<T> sample(@NonNull Publisher<U> sampler) {
        Objects.requireNonNull(sampler, "sampler is null");
        return RxJavaPlugins.onAssembly(new FlowableSamplePublisher(this, sampler, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Flowable<T> sample(@NonNull Publisher<U> sampler, boolean emitLast) {
        Objects.requireNonNull(sampler, "sampler is null");
        return RxJavaPlugins.onAssembly(new FlowableSamplePublisher(this, sampler, emitLast));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> scan(@NonNull BiFunction<T, T, T> accumulator) {
        Objects.requireNonNull(accumulator, "accumulator is null");
        return RxJavaPlugins.onAssembly(new FlowableScan<T>(this, accumulator));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> scan(R initialValue, @NonNull BiFunction<R, ? super T, R> accumulator) {
        Objects.requireNonNull(initialValue, "initialValue is null");
        return this.scanWith(Functions.justSupplier(initialValue), accumulator);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> scanWith(@NonNull Supplier<R> seedSupplier, @NonNull BiFunction<R, ? super T, R> accumulator) {
        Objects.requireNonNull(seedSupplier, "seedSupplier is null");
        Objects.requireNonNull(accumulator, "accumulator is null");
        return RxJavaPlugins.onAssembly(new FlowableScanSeed<T, R>(this, seedSupplier, accumulator));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> serialize() {
        return RxJavaPlugins.onAssembly(new FlowableSerialized(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> share() {
        return this.publish().refCount();
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Maybe<T> singleElement() {
        return RxJavaPlugins.onAssembly(new FlowableSingleMaybe(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> single(@NonNull T defaultItem) {
        Objects.requireNonNull(defaultItem, "defaultItem is null");
        return RxJavaPlugins.onAssembly(new FlowableSingleSingle<T>(this, defaultItem));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> singleOrError() {
        return RxJavaPlugins.onAssembly(new FlowableSingleSingle<Object>(this, null));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> skip(long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("count >= 0 expected but it was " + count);
        }
        if (count == 0L) {
            return RxJavaPlugins.onAssembly(this);
        }
        return RxJavaPlugins.onAssembly(new FlowableSkip(this, count));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> skip(long time, @NonNull TimeUnit unit) {
        return this.skipUntil(Flowable.timer(time, unit));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> skip(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.skipUntil(Flowable.timer(time, unit, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> skipLast(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count);
        }
        if (count == 0) {
            return RxJavaPlugins.onAssembly(this);
        }
        return RxJavaPlugins.onAssembly(new FlowableSkipLast(this, count));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> skipLast(long time, @NonNull TimeUnit unit) {
        return this.skipLast(time, unit, Schedulers.computation(), false, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> skipLast(long time, @NonNull TimeUnit unit, boolean delayError) {
        return this.skipLast(time, unit, Schedulers.computation(), delayError, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> skipLast(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.skipLast(time, unit, scheduler, false, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> skipLast(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean delayError) {
        return this.skipLast(time, unit, scheduler, delayError, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> skipLast(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean delayError, int bufferSize) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        int s = bufferSize << 1;
        return RxJavaPlugins.onAssembly(new FlowableSkipLastTimed(this, time, unit, scheduler, s, delayError));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Flowable<T> skipUntil(@NonNull Publisher<U> other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new FlowableSkipUntil(this, other));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> skipWhile(@NonNull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new FlowableSkipWhile<T>(this, predicate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> sorted() {
        return this.toList().toFlowable().map(Functions.listSorter(Functions.naturalComparator())).flatMapIterable(Functions.identity());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> sorted(@NonNull @NonNull Comparator<@NonNull ? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return this.toList().toFlowable().map(Functions.listSorter(comparator)).flatMapIterable(Functions.identity());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> startWithIterable(@NonNull @NonNull Iterable<@NonNull ? extends T> items) {
        return Flowable.concatArray(Flowable.fromIterable(items), this);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> startWith(@NonNull @NonNull Publisher<@NonNull ? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return Flowable.concatArray(other, this);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> startWithItem(@NonNull T item) {
        Objects.requireNonNull(item, "item is null");
        return Flowable.concatArray(Flowable.just(item), this);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public final Flowable<T> startWithArray(T ... items) {
        Flowable<T> fromArray = Flowable.fromArray(items);
        if (fromArray == Flowable.empty()) {
            return RxJavaPlugins.onAssembly(this);
        }
        return Flowable.concatArray(fromArray, this);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable subscribe() {
        return this.subscribe(Functions.emptyConsumer(), Functions.ON_ERROR_MISSING, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable subscribe(@NonNull Consumer<? super T> onNext) {
        return this.subscribe(onNext, Functions.ON_ERROR_MISSING, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable subscribe(@NonNull Consumer<? super T> onNext, @NonNull Consumer<? super Throwable> onError) {
        return this.subscribe(onNext, onError, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable subscribe(@NonNull Consumer<? super T> onNext, @NonNull Consumer<? super Throwable> onError, @NonNull Action onComplete) {
        Objects.requireNonNull(onNext, "onNext is null");
        Objects.requireNonNull(onError, "onError is null");
        Objects.requireNonNull(onComplete, "onComplete is null");
        LambdaSubscriber<? super T> ls = new LambdaSubscriber<T>(onNext, onError, onComplete, FlowableInternalHelper.RequestMax.INSTANCE);
        this.subscribe((FlowableSubscriber<? super T>)ls);
        return ls;
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final void subscribe(@NonNull @NonNull Subscriber<@NonNull ? super T> subscriber) {
        if (subscriber instanceof FlowableSubscriber) {
            this.subscribe((FlowableSubscriber)subscriber);
        } else {
            Objects.requireNonNull(subscriber, "subscriber is null");
            this.subscribe((FlowableSubscriber<? super T>)new StrictSubscriber<T>(subscriber));
        }
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final void subscribe(@NonNull @NonNull FlowableSubscriber<@NonNull ? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        try {
            Subscriber<@NonNull ? super T> flowableSubscriber = RxJavaPlugins.onSubscribe(this, subscriber);
            Objects.requireNonNull(flowableSubscriber, "The RxJavaPlugins.onSubscribe hook returned a null FlowableSubscriber. Please check the handler provided to RxJavaPlugins.setOnFlowableSubscribe for invalid null returns. Further reading: https://github.com/ReactiveX/RxJava/wiki/Plugins");
            this.subscribeActual(flowableSubscriber);
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(e);
            NullPointerException npe = new NullPointerException("Actually not, but can't throw other exceptions due to RS");
            npe.initCause(e);
            throw npe;
        }
    }

    protected abstract void subscribeActual(@NonNull @NonNull Subscriber<@NonNull ? super T> var1);

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <E extends Subscriber<? super T>> E subscribeWith(E subscriber) {
        this.subscribe(subscriber);
        return subscriber;
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> subscribeOn(@NonNull Scheduler scheduler) {
        Objects.requireNonNull(scheduler, "scheduler is null");
        return this.subscribeOn(scheduler, !(this instanceof FlowableCreate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> subscribeOn(@NonNull Scheduler scheduler, boolean requestOn) {
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableSubscribeOn(this, scheduler, requestOn));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> switchIfEmpty(@NonNull @NonNull Publisher<@NonNull ? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new FlowableSwitchIfEmpty<T>(this, other));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> switchMap(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper) {
        return this.switchMap(mapper, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> switchMap(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper, int bufferSize) {
        return this.switchMap0(mapper, bufferSize, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable switchMapCompletable(@NonNull Function<? super T, ? extends CompletableSource> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new FlowableSwitchMapCompletable<T>(this, mapper, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable switchMapCompletableDelayError(@NonNull Function<? super T, ? extends CompletableSource> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new FlowableSwitchMapCompletable<T>(this, mapper, true));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> switchMapDelayError(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper) {
        return this.switchMapDelayError(mapper, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> switchMapDelayError(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper, int bufferSize) {
        return this.switchMap0(mapper, bufferSize, true);
    }

    <R> Flowable<R> switchMap0(Function<? super T, ? extends Publisher<@NonNull ? extends R>> mapper, int bufferSize, boolean delayError) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        if (this instanceof ScalarSupplier) {
            Object v = ((ScalarSupplier)((Object)this)).get();
            if (v == null) {
                return Flowable.empty();
            }
            return FlowableScalarXMap.scalarXMap(v, mapper);
        }
        return RxJavaPlugins.onAssembly(new FlowableSwitchMap(this, mapper, bufferSize, delayError));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> switchMapMaybe(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new FlowableSwitchMapMaybe(this, mapper, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> switchMapMaybeDelayError(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new FlowableSwitchMapMaybe(this, mapper, true));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> switchMapSingle(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new FlowableSwitchMapSingle(this, mapper, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> switchMapSingleDelayError(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new FlowableSwitchMapSingle(this, mapper, true));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> take(long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count);
        }
        return RxJavaPlugins.onAssembly(new FlowableTake(this, count));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<T> take(long time, @NonNull TimeUnit unit) {
        return this.takeUntil(Flowable.timer(time, unit));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> take(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.takeUntil(Flowable.timer(time, unit, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> takeLast(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count);
        }
        if (count == 0) {
            return RxJavaPlugins.onAssembly(new FlowableIgnoreElements(this));
        }
        if (count == 1) {
            return RxJavaPlugins.onAssembly(new FlowableTakeLastOne(this));
        }
        return RxJavaPlugins.onAssembly(new FlowableTakeLast(this, count));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> takeLast(long count, long time, @NonNull TimeUnit unit) {
        return this.takeLast(count, time, unit, Schedulers.computation(), false, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> takeLast(long count, long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.takeLast(count, time, unit, scheduler, false, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> takeLast(long count, long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean delayError, int bufferSize) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        if (count < 0L) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count);
        }
        return RxJavaPlugins.onAssembly(new FlowableTakeLastTimed(this, count, time, unit, scheduler, bufferSize, delayError));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<T> takeLast(long time, @NonNull TimeUnit unit) {
        return this.takeLast(time, unit, Schedulers.computation(), false, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<T> takeLast(long time, @NonNull TimeUnit unit, boolean delayError) {
        return this.takeLast(time, unit, Schedulers.computation(), delayError, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> takeLast(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.takeLast(time, unit, scheduler, false, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> takeLast(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean delayError) {
        return this.takeLast(time, unit, scheduler, delayError, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> takeLast(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean delayError, int bufferSize) {
        return this.takeLast(Long.MAX_VALUE, time, unit, scheduler, delayError, bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> takeUntil(@NonNull Predicate<? super T> stopPredicate) {
        Objects.requireNonNull(stopPredicate, "stopPredicate is null");
        return RxJavaPlugins.onAssembly(new FlowableTakeUntilPredicate<T>(this, stopPredicate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Flowable<T> takeUntil(@NonNull Publisher<U> other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new FlowableTakeUntil(this, other));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> takeWhile(@NonNull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new FlowableTakeWhile<T>(this, predicate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<T> throttleFirst(long windowDuration, @NonNull TimeUnit unit) {
        return this.throttleFirst(windowDuration, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> throttleFirst(long skipDuration, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableThrottleFirstTimed(this, skipDuration, unit, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<T> throttleLast(long intervalDuration, @NonNull TimeUnit unit) {
        return this.sample(intervalDuration, unit);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> throttleLast(long intervalDuration, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.sample(intervalDuration, unit, scheduler);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<T> throttleLatest(long timeout, @NonNull TimeUnit unit) {
        return this.throttleLatest(timeout, unit, Schedulers.computation(), false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<T> throttleLatest(long timeout, @NonNull TimeUnit unit, boolean emitLast) {
        return this.throttleLatest(timeout, unit, Schedulers.computation(), emitLast);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> throttleLatest(long timeout, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.throttleLatest(timeout, unit, scheduler, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> throttleLatest(long timeout, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean emitLast) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableThrottleLatest(this, timeout, unit, scheduler, emitLast));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<T> throttleWithTimeout(long timeout, @NonNull TimeUnit unit) {
        return this.debounce(timeout, unit);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> throttleWithTimeout(long timeout, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.debounce(timeout, unit, scheduler);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<Timed<T>> timeInterval() {
        return this.timeInterval(TimeUnit.MILLISECONDS, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<Timed<T>> timeInterval(@NonNull Scheduler scheduler) {
        return this.timeInterval(TimeUnit.MILLISECONDS, scheduler);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<Timed<T>> timeInterval(@NonNull TimeUnit unit) {
        return this.timeInterval(unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<Timed<T>> timeInterval(@NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableTimeInterval(this, unit, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final <V> Flowable<T> timeout(@NonNull Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator) {
        return this.timeout0(null, itemTimeoutIndicator, null);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <V> Flowable<T> timeout(@NonNull @NonNull Function<? super T, ? extends Publisher<@NonNull V>> itemTimeoutIndicator, @NonNull @NonNull Publisher<@NonNull ? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return this.timeout0(null, itemTimeoutIndicator, other);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<T> timeout(long timeout, @NonNull TimeUnit unit) {
        return this.timeout0(timeout, unit, null, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<T> timeout(long timeout, @NonNull TimeUnit unit, @NonNull @NonNull Publisher<@NonNull ? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return this.timeout0(timeout, unit, other, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> timeout(long timeout, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, @NonNull @NonNull Publisher<@NonNull ? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return this.timeout0(timeout, unit, other, scheduler);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> timeout(long timeout, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.timeout0(timeout, unit, null, scheduler);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, V> Flowable<T> timeout(@NonNull Publisher<U> firstTimeoutIndicator, @NonNull Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator) {
        Objects.requireNonNull(firstTimeoutIndicator, "firstTimeoutIndicator is null");
        return this.timeout0(firstTimeoutIndicator, itemTimeoutIndicator, null);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, V> Flowable<T> timeout(@NonNull Publisher<U> firstTimeoutIndicator, @NonNull Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator, @NonNull @NonNull Publisher<@NonNull ? extends T> other) {
        Objects.requireNonNull(firstTimeoutIndicator, "firstTimeoutIndicator is null");
        Objects.requireNonNull(other, "other is null");
        return this.timeout0(firstTimeoutIndicator, itemTimeoutIndicator, other);
    }

    private Flowable<T> timeout0(long timeout, TimeUnit unit, Publisher<@NonNull ? extends T> other, Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableTimeoutTimed<T>(this, timeout, unit, scheduler, other));
    }

    private <U, V> Flowable<T> timeout0(Publisher<U> firstTimeoutIndicator, Function<? super T, ? extends Publisher<@NonNull V>> itemTimeoutIndicator, Publisher<@NonNull ? extends T> other) {
        Objects.requireNonNull(itemTimeoutIndicator, "itemTimeoutIndicator is null");
        return RxJavaPlugins.onAssembly(new FlowableTimeout(this, firstTimeoutIndicator, itemTimeoutIndicator, other));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<Timed<T>> timestamp() {
        return this.timestamp(TimeUnit.MILLISECONDS, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<Timed<T>> timestamp(@NonNull Scheduler scheduler) {
        return this.timestamp(TimeUnit.MILLISECONDS, scheduler);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<Timed<T>> timestamp(@NonNull TimeUnit unit) {
        return this.timestamp(unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<Timed<T>> timestamp(@NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return this.map(Functions.timestampWith(unit, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final <R> R to(@NonNull FlowableConverter<T, ? extends R> converter) {
        return Objects.requireNonNull(converter, "converter is null").apply(this);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<List<T>> toList() {
        return RxJavaPlugins.onAssembly(new FlowableToListSingle(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<List<T>> toList(int capacityHint) {
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        return RxJavaPlugins.onAssembly(new FlowableToListSingle(this, Functions.createArrayList(capacityHint)));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U extends Collection<? super T>> Single<U> toList(@NonNull Supplier<U> collectionSupplier) {
        Objects.requireNonNull(collectionSupplier, "collectionSupplier is null");
        return RxJavaPlugins.onAssembly(new FlowableToListSingle(this, collectionSupplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <K> Single<Map<K, T>> toMap(@NonNull Function<? super T, ? extends K> keySelector) {
        Objects.requireNonNull(keySelector, "keySelector is null");
        return this.collect(HashMapSupplier.asSupplier(), Functions.toMapKeySelector(keySelector));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <K, V> Single<Map<K, V>> toMap(@NonNull Function<? super T, ? extends K> keySelector, @NonNull Function<? super T, ? extends V> valueSelector) {
        Objects.requireNonNull(keySelector, "keySelector is null");
        Objects.requireNonNull(valueSelector, "valueSelector is null");
        return this.collect(HashMapSupplier.asSupplier(), Functions.toMapKeyValueSelector(keySelector, valueSelector));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <K, V> Single<Map<K, V>> toMap(@NonNull Function<? super T, ? extends K> keySelector, @NonNull Function<? super T, ? extends V> valueSelector, @NonNull Supplier<? extends Map<K, V>> mapSupplier) {
        Objects.requireNonNull(keySelector, "keySelector is null");
        Objects.requireNonNull(valueSelector, "valueSelector is null");
        return this.collect(mapSupplier, Functions.toMapKeyValueSelector(keySelector, valueSelector));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <K> Single<Map<K, Collection<T>>> toMultimap(@NonNull Function<? super T, ? extends K> keySelector) {
        Function valueSelector = Functions.identity();
        Supplier mapSupplier = HashMapSupplier.asSupplier();
        Function collectionFactory = ArrayListSupplier.asFunction();
        return this.toMultimap(keySelector, valueSelector, mapSupplier, collectionFactory);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <K, V> Single<Map<K, Collection<V>>> toMultimap(@NonNull Function<? super T, ? extends K> keySelector, @NonNull Function<? super T, ? extends V> valueSelector) {
        Supplier mapSupplier = HashMapSupplier.asSupplier();
        Function collectionFactory = ArrayListSupplier.asFunction();
        return this.toMultimap(keySelector, valueSelector, mapSupplier, collectionFactory);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <K, V> Single<Map<K, Collection<V>>> toMultimap(@NonNull Function<? super T, ? extends K> keySelector, @NonNull Function<? super T, ? extends V> valueSelector, @NonNull Supplier<? extends Map<K, Collection<V>>> mapSupplier, @NonNull Function<? super K, ? extends Collection<? super V>> collectionFactory) {
        Objects.requireNonNull(keySelector, "keySelector is null");
        Objects.requireNonNull(valueSelector, "valueSelector is null");
        Objects.requireNonNull(mapSupplier, "mapSupplier is null");
        Objects.requireNonNull(collectionFactory, "collectionFactory is null");
        return this.collect(mapSupplier, Functions.toMultimapKeyValueSelector(keySelector, valueSelector, collectionFactory));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <K, V> Single<Map<K, Collection<V>>> toMultimap(@NonNull Function<? super T, ? extends K> keySelector, @NonNull Function<? super T, ? extends V> valueSelector, @NonNull Supplier<Map<K, Collection<V>>> mapSupplier) {
        return this.toMultimap(keySelector, valueSelector, mapSupplier, ArrayListSupplier.asFunction());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> toObservable() {
        return RxJavaPlugins.onAssembly(new ObservableFromPublisher(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<List<T>> toSortedList() {
        return this.toSortedList(Functions.naturalComparator());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<List<T>> toSortedList(@NonNull Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return this.toList().map(Functions.listSorter(comparator));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<List<T>> toSortedList(@NonNull Comparator<? super T> comparator, int capacityHint) {
        Objects.requireNonNull(comparator, "comparator is null");
        return this.toList(capacityHint).map(Functions.listSorter(comparator));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<List<T>> toSortedList(int capacityHint) {
        return this.toSortedList(Functions.naturalComparator(), capacityHint);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<T> unsubscribeOn(@NonNull Scheduler scheduler) {
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableUnsubscribeOn(this, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<Flowable<T>> window(long count) {
        return this.window(count, count, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<Flowable<T>> window(long count, long skip) {
        return this.window(count, skip, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<Flowable<T>> window(long count, long skip, int bufferSize) {
        ObjectHelper.verifyPositive(skip, "skip");
        ObjectHelper.verifyPositive(count, "count");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableWindow(this, count, skip, bufferSize));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<Flowable<T>> window(long timespan, long timeskip, @NonNull TimeUnit unit) {
        return this.window(timespan, timeskip, unit, Schedulers.computation(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<Flowable<T>> window(long timespan, long timeskip, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.window(timespan, timeskip, unit, scheduler, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<Flowable<T>> window(long timespan, long timeskip, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, int bufferSize) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        ObjectHelper.verifyPositive(timespan, "timespan");
        ObjectHelper.verifyPositive(timeskip, "timeskip");
        Objects.requireNonNull(scheduler, "scheduler is null");
        Objects.requireNonNull(unit, "unit is null");
        return RxJavaPlugins.onAssembly(new FlowableWindowTimed(this, timespan, timeskip, unit, scheduler, Long.MAX_VALUE, bufferSize, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<Flowable<T>> window(long timespan, @NonNull TimeUnit unit) {
        return this.window(timespan, unit, Schedulers.computation(), Long.MAX_VALUE, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<Flowable<T>> window(long timespan, @NonNull TimeUnit unit, long count) {
        return this.window(timespan, unit, Schedulers.computation(), count, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Flowable<Flowable<T>> window(long timespan, @NonNull TimeUnit unit, long count, boolean restart) {
        return this.window(timespan, unit, Schedulers.computation(), count, restart);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<Flowable<T>> window(long timespan, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.window(timespan, unit, scheduler, Long.MAX_VALUE, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<Flowable<T>> window(long timespan, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, long count) {
        return this.window(timespan, unit, scheduler, count, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<Flowable<T>> window(long timespan, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, long count, boolean restart) {
        return this.window(timespan, unit, scheduler, count, restart, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @NonNull
    public final Flowable<Flowable<T>> window(long timespan, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, long count, boolean restart, int bufferSize) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        Objects.requireNonNull(scheduler, "scheduler is null");
        Objects.requireNonNull(unit, "unit is null");
        ObjectHelper.verifyPositive(count, "count");
        return RxJavaPlugins.onAssembly(new FlowableWindowTimed(this, timespan, timespan, unit, scheduler, count, bufferSize, restart));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final <B> Flowable<Flowable<T>> window(@NonNull Publisher<B> boundaryIndicator) {
        return this.window(boundaryIndicator, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final <B> Flowable<Flowable<T>> window(@NonNull Publisher<B> boundaryIndicator, int bufferSize) {
        Objects.requireNonNull(boundaryIndicator, "boundaryIndicator is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableWindowBoundary(this, boundaryIndicator, bufferSize));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, V> Flowable<Flowable<T>> window(@NonNull Publisher<U> openingIndicator, @NonNull Function<? super U, ? extends Publisher<V>> closingIndicator) {
        return this.window(openingIndicator, closingIndicator, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, V> Flowable<Flowable<T>> window(@NonNull Publisher<U> openingIndicator, @NonNull Function<? super U, ? extends Publisher<V>> closingIndicator, int bufferSize) {
        Objects.requireNonNull(openingIndicator, "openingIndicator is null");
        Objects.requireNonNull(closingIndicator, "closingIndicator is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableWindowBoundarySelector(this, openingIndicator, closingIndicator, bufferSize));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Flowable<R> withLatestFrom(@NonNull @NonNull Publisher<@NonNull ? extends U> other, @NonNull BiFunction<? super T, ? super U, ? extends R> combiner) {
        Objects.requireNonNull(other, "other is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return RxJavaPlugins.onAssembly(new FlowableWithLatestFrom<T, U, R>(this, combiner, other));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final <T1, T2, R> Flowable<R> withLatestFrom(@NonNull Publisher<T1> source1, @NonNull Publisher<T2> source2, @NonNull Function3<? super T, ? super T1, ? super T2, R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        Function<Object[], R> f = Functions.toFunction(combiner);
        return this.withLatestFrom(new Publisher[]{source1, source2}, f);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final <T1, T2, T3, R> Flowable<R> withLatestFrom(@NonNull Publisher<T1> source1, @NonNull Publisher<T2> source2, @NonNull Publisher<T3> source3, @NonNull Function4<? super T, ? super T1, ? super T2, ? super T3, R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        Function<Object[], R> f = Functions.toFunction(combiner);
        return this.withLatestFrom(new Publisher[]{source1, source2, source3}, f);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final <T1, T2, T3, T4, R> Flowable<R> withLatestFrom(@NonNull Publisher<T1> source1, @NonNull Publisher<T2> source2, @NonNull Publisher<T3> source3, @NonNull Publisher<T4> source4, @NonNull Function5<? super T, ? super T1, ? super T2, ? super T3, ? super T4, R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        Function<Object[], R> f = Functions.toFunction(combiner);
        return this.withLatestFrom(new Publisher[]{source1, source2, source3, source4}, f);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> withLatestFrom(@NonNull @NonNull Publisher<@NonNull ?>[] others, @NonNull Function<? super Object[], R> combiner) {
        Objects.requireNonNull(others, "others is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return RxJavaPlugins.onAssembly(new FlowableWithLatestFromMany(this, others, combiner));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> withLatestFrom(@NonNull @NonNull Iterable<@NonNull ? extends Publisher<@NonNull ?>> others, @NonNull Function<? super Object[], R> combiner) {
        Objects.requireNonNull(others, "others is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return RxJavaPlugins.onAssembly(new FlowableWithLatestFromMany(this, others, combiner));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Flowable<R> zipWith(@NonNull Iterable<U> other, @NonNull BiFunction<? super T, ? super U, ? extends R> zipper) {
        Objects.requireNonNull(other, "other is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return RxJavaPlugins.onAssembly(new FlowableZipIterable<T, U, R>(this, other, zipper));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Flowable<R> zipWith(@NonNull @NonNull Publisher<@NonNull ? extends U> other, @NonNull BiFunction<? super T, ? super U, ? extends R> zipper) {
        Objects.requireNonNull(other, "other is null");
        return Flowable.zip(this, other, zipper);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Flowable<R> zipWith(@NonNull @NonNull Publisher<@NonNull ? extends U> other, @NonNull BiFunction<? super T, ? super U, ? extends R> zipper, boolean delayError) {
        return Flowable.zip(this, other, zipper, delayError);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Flowable<R> zipWith(@NonNull @NonNull Publisher<@NonNull ? extends U> other, @NonNull BiFunction<? super T, ? super U, ? extends R> zipper, boolean delayError, int bufferSize) {
        return Flowable.zip(this, other, zipper, delayError, bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final TestSubscriber<T> test() {
        TestSubscriber ts = new TestSubscriber();
        this.subscribe(ts);
        return ts;
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final TestSubscriber<T> test(long initialRequest) {
        TestSubscriber ts = new TestSubscriber(initialRequest);
        this.subscribe(ts);
        return ts;
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final TestSubscriber<T> test(long initialRequest, boolean cancel) {
        TestSubscriber ts = new TestSubscriber(initialRequest);
        if (cancel) {
            ts.cancel();
        }
        this.subscribe(ts);
        return ts;
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> @NonNull Flowable<@NonNull T> fromOptional(@NonNull Optional<T> optional) {
        Objects.requireNonNull(optional, "optional is null");
        return optional.map(Flowable::just).orElseGet(Flowable::empty);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> @NonNull Flowable<@NonNull T> fromCompletionStage(@NonNull CompletionStage<T> stage) {
        Objects.requireNonNull(stage, "stage is null");
        return RxJavaPlugins.onAssembly(new FlowableFromCompletionStage<T>(stage));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> @NonNull Flowable<@NonNull T> fromStream(@NonNull Stream<T> stream) {
        Objects.requireNonNull(stream, "stream is null");
        return RxJavaPlugins.onAssembly(new FlowableFromStream<T>(stream));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> mapOptional(@NonNull @NonNull Function<? super T, @NonNull Optional<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new FlowableMapOptional<T, R>(this, mapper));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R, A> Single<R> collect(@NonNull Collector<T, A, R> collector) {
        Objects.requireNonNull(collector, "collector is null");
        return RxJavaPlugins.onAssembly(new FlowableCollectWithCollectorSingle<T, A, R>(this, collector));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final CompletionStage<T> firstStage(@Nullable T defaultItem) {
        return this.subscribeWith(new FlowableFirstStageSubscriber<T>(true, defaultItem));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final CompletionStage<T> singleStage(@Nullable T defaultItem) {
        return this.subscribeWith(new FlowableSingleStageSubscriber<T>(true, defaultItem));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final CompletionStage<T> lastStage(@Nullable T defaultItem) {
        return this.subscribeWith(new FlowableLastStageSubscriber<T>(true, defaultItem));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final CompletionStage<T> firstOrErrorStage() {
        return this.subscribeWith(new FlowableFirstStageSubscriber<Object>(false, null));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final CompletionStage<T> singleOrErrorStage() {
        return this.subscribeWith(new FlowableSingleStageSubscriber<Object>(false, null));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final CompletionStage<T> lastOrErrorStage() {
        return this.subscribeWith(new FlowableLastStageSubscriber<Object>(false, null));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Stream<T> blockingStream() {
        return this.blockingStream(Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Stream<T> blockingStream(int prefetch) {
        Iterator<T> iterator = this.blockingIterable(prefetch).iterator();
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false).onClose(((Disposable)((Object)iterator))::dispose);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMapStream(@NonNull @NonNull Function<? super T, @NonNull ? extends Stream<@NonNull ? extends R>> mapper) {
        return this.flatMapStream(mapper, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> concatMapStream(@NonNull @NonNull Function<? super T, @NonNull ? extends Stream<@NonNull ? extends R>> mapper, int prefetch) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableFlatMapStream(this, mapper, prefetch));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> flatMapStream(@NonNull @NonNull Function<? super T, @NonNull ? extends Stream<@NonNull ? extends R>> mapper) {
        return this.flatMapStream(mapper, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> flatMapStream(@NonNull @NonNull Function<? super T, @NonNull ? extends Stream<@NonNull ? extends R>> mapper, int prefetch) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableFlatMapStream(this, mapper, prefetch));
    }
}

