/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import java.util.EnumSet;
import java.util.Set;

abstract class AbstractJsonCodec<T>
extends AbstractCodec<T> {
    private static final Set<PostgresqlObjectId> SUPPORTED_TYPES = EnumSet.of(PostgresqlObjectId.JSON, PostgresqlObjectId.JSONB);

    AbstractJsonCodec(Class<T> type) {
        super(type);
    }

    @Override
    public Parameter encodeNull() {
        return AbstractJsonCodec.createNull(PostgresqlObjectId.JSONB, Format.FORMAT_BINARY);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return SUPPORTED_TYPES.contains((Object)type);
    }

    @Override
    public Iterable<PostgresqlObjectId> getDataTypes() {
        return SUPPORTED_TYPES;
    }
}

