/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.backend;

import io.netty.buffer.ByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.util.Assert;
import java.util.Objects;

public final class CopyData
extends AbstractReferenceCounted
implements BackendMessage {
    private final ByteBuf data;

    public CopyData(ByteBuf data) {
        Assert.requireNonNull(data, "data must not be null");
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CopyData copyData = (CopyData)o;
        return Objects.equals(this.data, copyData.data);
    }

    public ByteBuf getData() {
        return this.data;
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public String toString() {
        return "CopyData{data=" + this.data + '}';
    }

    protected void deallocate() {
        this.data.release();
    }

    public CopyData touch(Object hint) {
        return this;
    }

    static CopyData decode(ByteBuf in) {
        Assert.requireNonNull(in, "in must not be null");
        return new CopyData(in.readSlice(in.readableBytes()).retain());
    }
}

