/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.processor.beanparam;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.client.processor.beanparam.BeanParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.CookieParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.FieldExtractor;
import org.jboss.resteasy.reactive.client.processor.beanparam.GetterExtractor;
import org.jboss.resteasy.reactive.client.processor.beanparam.HeaderParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.Item;
import org.jboss.resteasy.reactive.client.processor.beanparam.QueryParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.ValueExtractor;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;

public class BeanParamParser {
    public static List<Item> parse(ClassInfo beanParamClass, IndexView index) {
        List headerParams;
        List cookieParams;
        List beanParams;
        ArrayList<Item> resultList = new ArrayList<Item>();
        Map annotations = beanParamClass.annotations();
        List queryParams = (List)annotations.get(ResteasyReactiveDotNames.QUERY_PARAM);
        if (queryParams != null) {
            for (Object annotation : queryParams) {
                AnnotationTarget target = annotation.target();
                if (target.kind() == AnnotationTarget.Kind.FIELD) {
                    FieldInfo fieldInfo = target.asField();
                    resultList.add(new QueryParamItem(annotation.value().asString(), new FieldExtractor(null, fieldInfo.name(), fieldInfo.declaringClass().name().toString()), fieldInfo.type()));
                    continue;
                }
                if (target.kind() != AnnotationTarget.Kind.METHOD) continue;
                MethodInfo getterMethod = BeanParamParser.getGetterMethod(beanParamClass, target.asMethod());
                resultList.add(new QueryParamItem(annotation.value().asString(), new GetterExtractor(getterMethod), getterMethod.returnType()));
            }
        }
        if ((beanParams = (List)annotations.get(ResteasyReactiveDotNames.BEAN_PARAM)) != null) {
            for (Object annotation : beanParams) {
                AnnotationTarget target = annotation.target();
                if (target.kind() == AnnotationTarget.Kind.FIELD) {
                    FieldInfo fieldInfo = target.asField();
                    Type type = fieldInfo.type();
                    if (type.kind() == Type.Kind.CLASS) {
                        List<Item> subBeanParamItems = BeanParamParser.parse(index.getClassByName(type.asClassType().name()), index);
                        resultList.add(new BeanParamItem(subBeanParamItems, (ValueExtractor)new FieldExtractor(null, fieldInfo.name(), fieldInfo.declaringClass().name().toString())));
                        continue;
                    }
                    throw new IllegalArgumentException("BeanParam annotation used on a field that is not an object: " + beanParamClass.name() + "." + fieldInfo.name());
                }
                if (target.kind() != AnnotationTarget.Kind.METHOD) continue;
                MethodInfo methodInfo = target.asMethod();
                MethodInfo getter = BeanParamParser.getGetterMethod(beanParamClass, methodInfo);
                Type returnType = getter.returnType();
                List<Item> items = BeanParamParser.parse(index.getClassByName(returnType.name()), index);
                resultList.add(new BeanParamItem(items, (ValueExtractor)new GetterExtractor(getter)));
            }
        }
        if ((cookieParams = (List)annotations.get(ResteasyReactiveDotNames.COOKIE_PARAM)) != null) {
            for (AnnotationInstance annotation : cookieParams) {
                AnnotationTarget target = annotation.target();
                if (target.kind() == AnnotationTarget.Kind.FIELD) {
                    FieldInfo fieldInfo = target.asField();
                    resultList.add(new CookieParamItem(annotation.value().asString(), (ValueExtractor)new FieldExtractor(null, fieldInfo.name(), fieldInfo.declaringClass().name().toString())));
                    continue;
                }
                if (target.kind() != AnnotationTarget.Kind.METHOD) continue;
                MethodInfo getterMethod = BeanParamParser.getGetterMethod(beanParamClass, target.asMethod());
                resultList.add(new CookieParamItem(annotation.value().asString(), (ValueExtractor)new GetterExtractor(getterMethod)));
            }
        }
        if ((headerParams = (List)annotations.get(ResteasyReactiveDotNames.HEADER_PARAM)) != null) {
            for (AnnotationInstance queryParamAnnotation : headerParams) {
                AnnotationTarget target = queryParamAnnotation.target();
                if (target.kind() == AnnotationTarget.Kind.FIELD) {
                    FieldInfo fieldInfo = target.asField();
                    resultList.add(new HeaderParamItem(queryParamAnnotation.value().asString(), (ValueExtractor)new FieldExtractor(null, fieldInfo.name(), fieldInfo.declaringClass().name().toString())));
                    continue;
                }
                if (target.kind() != AnnotationTarget.Kind.METHOD) continue;
                MethodInfo getterMethod = BeanParamParser.getGetterMethod(beanParamClass, target.asMethod());
                resultList.add(new HeaderParamItem(queryParamAnnotation.value().asString(), (ValueExtractor)new GetterExtractor(getterMethod)));
            }
        }
        return resultList;
    }

    private static MethodInfo getGetterMethod(ClassInfo beanParamClass, MethodInfo methodInfo) {
        MethodInfo getter = null;
        if (methodInfo.parameters().size() > 0) {
            String setterName = methodInfo.name();
            if (setterName.startsWith("set")) {
                getter = beanParamClass.method(setterName.replace("^set", "^get"), new Type[0]);
            }
        } else if (methodInfo.name().startsWith("get")) {
            getter = methodInfo;
        }
        if (getter == null) {
            throw new IllegalArgumentException("No getter corresponding to " + methodInfo.declaringClass().name() + "#" + methodInfo.name() + " found");
        }
        return getter;
    }

    private BeanParamParser() {
    }
}

