/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime.dev.ui;

import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import io.quarkus.websockets.next.Connection;
import io.quarkus.websockets.next.WebSocketConnection;
import io.quarkus.websockets.next.runtime.ConnectionManager;
import io.quarkus.websockets.next.runtime.config.WebSocketsServerRuntimeConfig;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import io.vertx.core.Vertx;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.logging.Logger;

@ApplicationScoped
public class WebSocketNextJsonRPCService
implements ConnectionManager.ConnectionListener {
    private static final Logger LOG = Logger.getLogger(WebSocketNextJsonRPCService.class);
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("YYYY-MM-dd HH:mm:ss");
    private static final String DEVUI_SOCKET_KEY_HEADER = "X-devui-socket-key";
    private final BroadcastProcessor<JsonObject> connectionStatus = BroadcastProcessor.create();
    private final BroadcastProcessor<JsonObject> connectionMessages = BroadcastProcessor.create();
    private final ConnectionManager connectionManager;
    private final Vertx vertx;
    private final ConcurrentMap<String, DevWebSocket> sockets;
    private final VertxHttpConfig httpConfig;
    private final WebSocketsServerRuntimeConfig.DevMode devModeConfig;

    WebSocketNextJsonRPCService(Instance<ConnectionManager> connectionManager, Vertx vertx, VertxHttpConfig httpConfig, WebSocketsServerRuntimeConfig config) {
        this.connectionManager = connectionManager.isResolvable() ? (ConnectionManager)connectionManager.get() : null;
        this.vertx = vertx;
        this.httpConfig = httpConfig;
        this.devModeConfig = config.devMode();
        this.sockets = new ConcurrentHashMap<String, DevWebSocket>();
        if (this.connectionManager != null) {
            this.connectionManager.addListener((ConnectionManager.ConnectionListener)this);
        }
    }

    public Multi<JsonObject> connectionStatus() {
        return this.connectionStatus;
    }

    public Multi<JsonObject> connectionMessages() {
        return this.connectionMessages;
    }

    public JsonObject getConnections(List<String> endpoints) {
        JsonObject json = new JsonObject();
        if (this.connectionManager != null) {
            for (String endpoint : endpoints) {
                ArrayList<WebSocketConnection> connections = new ArrayList<WebSocketConnection>(this.connectionManager.getConnections(endpoint));
                connections.sort(Comparator.comparing(Connection::creationTime));
                JsonArray array = new JsonArray();
                for (WebSocketConnection c : connections) {
                    array.add((Object)this.toJsonObject(endpoint, c));
                }
                json.put(endpoint, (Object)array);
            }
        }
        json.put("connectionMessagesLimit", (Object)this.devModeConfig.connectionMessagesLimit());
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonArray getMessages(String connectionKey) {
        DevWebSocket socket = (DevWebSocket)this.sockets.get(connectionKey);
        if (socket != null) {
            List<TextMessage> messages;
            JsonArray ret = new JsonArray();
            List<TextMessage> list = messages = socket.messages;
            synchronized (list) {
                ListIterator<TextMessage> it = messages.listIterator(messages.size());
                while (it.hasPrevious()) {
                    ret.add((Object)it.previous().toJsonObject());
                }
            }
            return ret;
        }
        return new JsonArray();
    }

    public Uni<JsonObject> openDevConnection(String path, String endpointPath) {
        if (this.connectionManager == null) {
            return this.failureUni();
        }
        if (WebSocketNextJsonRPCService.isInvalidPath(path, endpointPath)) {
            LOG.errorf("Invalid path %s; original endpoint path %s", (Object)path, (Object)endpointPath);
            return this.failureUni();
        }
        WebSocketClient client = this.vertx.createWebSocketClient();
        String connectionKey = UUID.randomUUID().toString();
        Uni uni = Uni.createFrom().completionStage(() -> client.connect(new WebSocketConnectOptions().setPort(Integer.valueOf(this.httpConfig.port())).setHost(this.httpConfig.host()).setURI(path).addHeader(DEVUI_SOCKET_KEY_HEADER, connectionKey)).toCompletionStage());
        return uni.onItem().transform(s -> {
            LOG.debugf("Opened Dev UI connection with key %s to %s", (Object)connectionKey, (Object)path);
            ArrayList<TextMessage> messages = new ArrayList<TextMessage>();
            s.textMessageHandler(m -> {
                List list = messages;
                synchronized (list) {
                    if ((long)messages.size() < this.devModeConfig.connectionMessagesLimit()) {
                        TextMessage t = new TextMessage(true, (String)m, LocalDateTime.now());
                        messages.add(t);
                        this.connectionMessages.onNext((Object)t.toJsonObject().put("key", (Object)connectionKey));
                    } else {
                        LOG.debugf("Opened Dev UI connection [%s] received a message but the limit [%s] has been reached", (Object)connectionKey, (Object)this.devModeConfig.connectionMessagesLimit());
                    }
                }
            });
            this.sockets.put(connectionKey, new DevWebSocket((WebSocket)s, (List<TextMessage>)messages));
            return new JsonObject().put("success", (Object)true).put("key", (Object)connectionKey);
        }).onFailure().recoverWithItem(t -> {
            LOG.errorf(t, "Unable to open Dev UI connection with key %s to %s", (Object)connectionKey, (Object)path);
            return new JsonObject().put("success", (Object)false);
        });
    }

    static boolean isInvalidPath(String path, String endpointPath) {
        String[] pathSegments;
        if (!endpointPath.contains("{")) {
            return !WebSocketNextJsonRPCService.normalize(path).equals(endpointPath);
        }
        String[] endpointPathSegments = endpointPath.split("/");
        if (endpointPathSegments.length != (pathSegments = WebSocketNextJsonRPCService.normalize(path).split("/")).length) {
            return true;
        }
        for (int i = 0; i < endpointPathSegments.length; ++i) {
            String es = endpointPathSegments[i];
            String s = pathSegments[i];
            if (es.startsWith("{") && es.endsWith("}")) continue;
            if (es.contains("{")) {
                String[] parts;
                for (String part : parts = es.split("\\{[a-zA-Z0-9_]+\\}")) {
                    if (s.contains(part)) continue;
                    return true;
                }
                continue;
            }
            if (es.equals(s)) continue;
            return true;
        }
        return false;
    }

    private static String normalize(String path) {
        int queryIdx = path.indexOf("?");
        if (queryIdx != -1) {
            return path.substring(0, queryIdx);
        }
        return path;
    }

    public Uni<JsonObject> closeDevConnection(String connectionKey) {
        if (this.connectionManager == null) {
            return this.failureUni();
        }
        DevWebSocket socket = (DevWebSocket)this.sockets.remove(connectionKey);
        if (socket != null) {
            Uni uni = Uni.createFrom().completionStage(() -> socket.socket.close().toCompletionStage());
            return uni.onItem().transform(v -> {
                LOG.debugf("Closed Dev UI connection with key %s", (Object)connectionKey);
                return new JsonObject().put("success", (Object)true);
            }).onFailure().recoverWithItem(t -> {
                LOG.errorf(t, "Unable to close Dev UI connection with key %s", (Object)connectionKey);
                return new JsonObject().put("success", (Object)false);
            });
        }
        return this.failureUni();
    }

    public Uni<JsonObject> sendTextMessage(String connectionKey, String message) {
        DevWebSocket socket = (DevWebSocket)this.sockets.get(connectionKey);
        if (socket != null) {
            Uni uni = Uni.createFrom().completionStage(() -> socket.socket.writeTextMessage(message).toCompletionStage());
            return uni.onItem().transform(v -> {
                List<TextMessage> messages;
                List<TextMessage> list = messages = socket.messages;
                synchronized (list) {
                    if ((long)messages.size() < this.devModeConfig.connectionMessagesLimit()) {
                        TextMessage t = new TextMessage(false, message, LocalDateTime.now());
                        messages.add(t);
                        this.connectionMessages.onNext((Object)t.toJsonObject().put("key", (Object)connectionKey));
                        LOG.debugf("Sent text message to connection with key %s", (Object)connectionKey);
                    } else {
                        LOG.debugf("Sent text message to connection [%s] but the limit [%s] has been reached", (Object)connectionKey, (Object)this.devModeConfig.connectionMessagesLimit());
                    }
                }
                return new JsonObject().put("success", (Object)true);
            }).onFailure().recoverWithItem(t -> {
                LOG.errorf(t, "Unable to send text message to connection with key %s", (Object)connectionKey);
                return new JsonObject().put("success", (Object)false);
            });
        }
        return this.failureUni();
    }

    public JsonObject clearMessages(String connectionKey) {
        DevWebSocket socket = (DevWebSocket)this.sockets.get(connectionKey);
        if (socket != null) {
            socket.clearMessages();
            return new JsonObject().put("success", (Object)true);
        }
        return new JsonObject().put("success", (Object)false);
    }

    private Uni<JsonObject> failureUni() {
        return Uni.createFrom().item((Object)new JsonObject().put("success", (Object)false));
    }

    public void connectionAdded(String endpoint, WebSocketConnection connection) {
        this.connectionStatus.onNext((Object)this.toJsonObject(endpoint, connection));
    }

    public void connectionRemoved(String endpoint, String connectionId) {
        this.connectionStatus.onNext((Object)new JsonObject().put("id", (Object)connectionId).put("endpoint", (Object)endpoint).put("removed", (Object)true));
    }

    JsonObject toJsonObject(String endpoint, WebSocketConnection c) {
        JsonObject json = new JsonObject();
        json.put("id", (Object)c.id());
        json.put("endpoint", (Object)endpoint);
        json.put("creationTime", (Object)LocalDateTime.ofInstant(c.creationTime(), ZoneId.systemDefault()).format(FORMATTER));
        json.put("handshakePath", (Object)c.handshakeRequest().path());
        String key = c.handshakeRequest().header(DEVUI_SOCKET_KEY_HEADER);
        if (key != null) {
            json.put("devuiSocketKey", (Object)key);
        }
        return json;
    }

    record DevWebSocket(WebSocket socket, List<TextMessage> messages) {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clearMessages() {
            List<TextMessage> list = this.messages;
            synchronized (list) {
                this.messages.clear();
            }
        }
    }

    record TextMessage(boolean incoming, String text, LocalDateTime timestamp) {
        JsonObject toJsonObject() {
            return new JsonObject().put("text", (Object)this.text).put("incoming", (Object)this.incoming).put("time", (Object)this.timestamp.format(FORMATTER)).put("className", (Object)(this.incoming ? "incoming" : "outgoing")).put("userAbbr", (Object)(this.incoming ? "IN" : "OUT"));
        }
    }
}

