/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.webdependency.locator.runtime;

import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import org.jboss.logging.Logger;

@Recorder
public class WebDependencyLocatorRecorder {
    private static final Logger LOG = Logger.getLogger((String)WebDependencyLocatorRecorder.class.getName());
    private static final String JAVASCRIPT_CODE = "const im = document.createElement('script');\nim.type = 'importmap';\nim.textContent = JSON.stringify(%s);\ndocument.currentScript.after(im);\n";

    public Handler<RoutingContext> getHandler(String webDependenciesRootUrl, Map<String, String> webDependencyNameToVersionMap) {
        return event -> {
            block8: {
                String path = event.normalizedPath();
                if (path.startsWith(webDependenciesRootUrl)) {
                    try {
                        String rest = path.substring(webDependenciesRootUrl.length());
                        String webdep = rest.substring(0, rest.indexOf(47));
                        if (webDependencyNameToVersionMap.containsKey(webdep)) {
                            int endOfVersion = rest.indexOf(47, rest.indexOf(47) + 1);
                            if (endOfVersion == -1) {
                                endOfVersion = rest.length();
                            }
                            String nextPathEntry = rest.substring(rest.indexOf(47) + 1, endOfVersion);
                            if (webDependencyNameToVersionMap.get(webdep) == null || nextPathEntry.equals(webDependencyNameToVersionMap.get(webdep))) {
                                event.next();
                            } else {
                                event.reroute(webDependenciesRootUrl + webdep + "/" + (String)webDependencyNameToVersionMap.get(webdep) + rest.substring(rest.indexOf(47)));
                            }
                            break block8;
                        }
                        event.next();
                    }
                    catch (Throwable t) {
                        LOG.debug((Object)("Error while locating web jar " + path));
                        event.next();
                    }
                } else {
                    event.next();
                }
            }
        };
    }

    public Handler<RoutingContext> getImportMapHandler(final String expectedPath, final String importmap) {
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                String path = event.normalizedPath();
                if (path.equals(expectedPath)) {
                    HttpServerResponse response = event.response();
                    response.headers().set(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/javascript");
                    response.end(WebDependencyLocatorRecorder.JAVASCRIPT_CODE.formatted(importmap));
                } else {
                    event.next();
                }
            }
        };
    }
}

