/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devconsole.spi;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.recording.BytecodeRecorderImpl;
import io.quarkus.deployment.util.ArtifactInfoUtil;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;

@Deprecated
public final class DevConsoleRouteBuildItem
extends MultiBuildItem {
    private final String groupId;
    private final String artifactId;
    private final String path;
    private final String method;
    private final Class<?> callerClass;
    private final Handler<RoutingContext> handler;
    private final boolean isBodyHandlerRequired;
    private final boolean isBlockingHandler;

    public static Builder builder() {
        return new Builder();
    }

    public DevConsoleRouteBuildItem(String groupId, String artifactId, String path, String method, Handler<RoutingContext> handler) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.path = path;
        this.method = method;
        this.handler = handler;
        this.callerClass = null;
        this.isBodyHandlerRequired = false;
        this.isBlockingHandler = false;
    }

    public DevConsoleRouteBuildItem(String path, String method, Handler<RoutingContext> handler) {
        String callerClassName = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass().getCanonicalName();
        try {
            this.callerClass = Thread.currentThread().getContextClassLoader().loadClass(callerClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.groupId = null;
        this.artifactId = null;
        this.path = path;
        this.method = method;
        this.handler = handler;
        this.isBodyHandlerRequired = false;
        this.isBlockingHandler = false;
    }

    public DevConsoleRouteBuildItem(String path, String method, Handler<RoutingContext> handler, boolean isBodyHandlerRequired) {
        String callerClassName = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass().getCanonicalName();
        try {
            this.callerClass = Thread.currentThread().getContextClassLoader().loadClass(callerClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.groupId = null;
        this.artifactId = null;
        this.path = path;
        this.method = method;
        this.handler = handler;
        this.isBodyHandlerRequired = isBodyHandlerRequired;
        this.isBlockingHandler = false;
    }

    private DevConsoleRouteBuildItem(String groupId, String artifactId, String path, String method, Class<?> callerClass, Handler<RoutingContext> handler, boolean isBodyHandlerRequired, boolean isBlockingHandler) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.path = path;
        this.method = method;
        this.callerClass = callerClass;
        this.handler = handler;
        this.isBodyHandlerRequired = isBodyHandlerRequired;
        this.isBlockingHandler = isBlockingHandler;
    }

    public Map.Entry<String, String> groupIdAndArtifactId(CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (this.callerClass == null) {
            return new AbstractMap.SimpleEntry<String, String>(this.groupId, this.artifactId);
        }
        return ArtifactInfoUtil.groupIdAndArtifactId(this.callerClass, (CurateOutcomeBuildItem)curateOutcomeBuildItem);
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public Handler<RoutingContext> getHandler() {
        return this.handler;
    }

    public boolean isDeploymentSide() {
        return !(this.handler instanceof BytecodeRecorderImpl.ReturnedProxy);
    }

    public boolean isBodyHandlerRequired() {
        return this.isBodyHandlerRequired;
    }

    public boolean isBlockingHandler() {
        return this.isBlockingHandler;
    }

    public static class Builder {
        private String groupId;
        private String artifactId;
        private String path;
        private String method;
        private Handler<RoutingContext> handler;
        private boolean isBodyHandlerRequired;
        private boolean isBlockingHandler;

        public Builder ga(String groupId, String artifactId) {
            this.groupId = Objects.requireNonNull(groupId);
            this.artifactId = Objects.requireNonNull(artifactId);
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder handler(Handler<RoutingContext> handler) {
            this.handler = Objects.requireNonNull(handler);
            return this;
        }

        public Builder bodyHandlerRequired() {
            this.isBodyHandlerRequired = true;
            return this;
        }

        public Builder blockingHandler() {
            this.isBlockingHandler = true;
            return this;
        }

        public DevConsoleRouteBuildItem build() {
            Class<?> callerClass;
            if (this.groupId == null) {
                String callerClassName = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass().getCanonicalName();
                try {
                    callerClass = Thread.currentThread().getContextClassLoader().loadClass(callerClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            } else {
                callerClass = null;
            }
            return new DevConsoleRouteBuildItem(this.groupId, this.artifactId, this.path, this.method, callerClass, this.handler, this.isBodyHandlerRequired, this.isBlockingHandler);
        }
    }
}

