/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.builder.item.SimpleBuildItem;

public final class NonApplicationRootPathBuildItem
extends SimpleBuildItem {
    private final String httpRootPath;
    private final String frameworkRootPath;
    private final boolean separateRoot;

    public NonApplicationRootPathBuildItem(String frameworkRootPath) {
        this(frameworkRootPath, null);
    }

    public NonApplicationRootPathBuildItem(String frameworkRootPath, String httpRootPath) {
        this.frameworkRootPath = frameworkRootPath;
        this.separateRoot = frameworkRootPath != null && !frameworkRootPath.equals("") && !frameworkRootPath.equals("/");
        this.httpRootPath = httpRootPath;
    }

    public String getFrameworkRootPath() {
        return this.frameworkRootPath;
    }

    public boolean isSeparateRoot() {
        return this.separateRoot;
    }

    public String adjustPath(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Path must start with /");
        }
        if (this.frameworkRootPath.equals("/")) {
            return path;
        }
        return this.frameworkRootPath + path;
    }

    public String adjustPathIncludingHttpRootPath(String path) {
        String withFrameWorkPath = this.adjustPath(path);
        if (this.httpRootPath == null || this.httpRootPath.equals("/")) {
            return withFrameWorkPath;
        }
        return this.httpRootPath + withFrameWorkPath;
    }
}

