/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.security.webauthn;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import com.webauthn4j.util.Base64UrlUtil;
import io.quarkus.security.webauthn.WebAuthnLoginResponse;
import io.quarkus.security.webauthn.WebAuthnRegisterResponse;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class WebAuthnHelper {
    public static void dumpWebAuthnRequest(JsonObject json) throws IOException {
        System.err.println(json.encodePrettily());
        JsonObject response = json.getJsonObject("response");
        if (response != null) {
            String clientDataJSON;
            String authenticatorData;
            String attestationObject = response.getString("attestationObject");
            if (attestationObject != null) {
                System.err.println("Attestation object:");
                WebAuthnHelper.dumpAttestationObject(attestationObject);
            }
            if ((authenticatorData = response.getString("authenticatorData")) != null) {
                System.err.println("Authenticator Data:");
                WebAuthnHelper.dumpAuthenticatorData(authenticatorData);
            }
            if ((clientDataJSON = response.getString("clientDataJSON")) != null) {
                System.err.println("Client Data JSON:");
                String encoded = new String(Base64UrlUtil.decode((String)clientDataJSON), StandardCharsets.UTF_8);
                System.err.println(new JsonObject(encoded).encodePrettily());
            }
        }
    }

    private static void dumpAttestationObject(String attestationObject) throws IOException {
        CBORFactory factory = CBORFactory.builder().build();
        PrettyPrinter printer = new PrettyPrinter();
        try (CBORParser parser = factory.createParser(Base64UrlUtil.decode((String)attestationObject));){
            JsonToken t;
            while ((t = parser.nextToken()) != null) {
                printer.handleToken(parser, t);
            }
        }
    }

    private static void dumpAuthenticatorData(String authenticatorData) throws IOException {
        PrettyPrinter printer = new PrettyPrinter();
        byte[] bytes = Base64UrlUtil.decode((String)authenticatorData);
        printer.dumpAuthData(bytes);
    }

    public static void dumpWebAuthnRequest(WebAuthnRegisterResponse response) {
        try {
            WebAuthnHelper.dumpWebAuthnRequest(response.toJsonObject());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void dumpWebAuthnRequest(WebAuthnLoginResponse response) {
        try {
            WebAuthnHelper.dumpWebAuthnRequest(response.toJsonObject());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        WebAuthnLoginResponse response = new WebAuthnLoginResponse();
        response.webAuthnId = "cmokxFnWpNiqBDgI8qL41usvkUCeZC_J8EVS_jD0Brw";
        response.webAuthnRawId = "cmokxFnWpNiqBDgI8qL41usvkUCeZC_J8EVS_jD0Brw";
        response.webAuthnResponseAuthenticatorData = "SZYN5YgOjGh0NBcPZHZgW4_krrmihjLHmVzzuoMdl2NBAAAAAgAAAAAAAAAAAAAAAAAAAAAAIHJqJMRZ1qTYqgQ4CPKi-NbrL5FAnmQvyfBFUv4w9Aa8v2ExAmEzJmItMQFiLTJ4LFhCbHRrY25LZ2xjTU94bmZYSnAydE1xc2RESFBhNVB5YnIvaFJUY2tSU3c9Yi0zeCxjZWQvdHRvZGdaQjhmUGdHZ0NIM3lIUUU5NjUzVk5GdTNET2JqNFNtZ2dRPf8=";
        response.webAuthnResponseSignature = "MEUCIQDlT0NRyeElINrF59m54fsAhjVh09ykApfKzUsFw1qCVQIgHHkrPCQedlVo_fWcb7p8ch7tAT8mt3h3-GihBUP8s4o=";
        response.webAuthnResponseClientDataJSON = "eyJ0eXBlIjoid2ViYXV0aG4uZ2V0IiwiY2hhbGxlbmdlIjoiQTdYTDFvOTlINEdRZXBESDI5MnAzSUdwU0NNRHU3cUVlRVEwY3dWMU5BYm82ZzFjbC1yc2pGRHZuaVdwbE5hdk1rX1Z4YkJVcG8wdE00c2V2bXpaQUEiLCJvcmlnaW4iOiJodHRwOi8vbG9jYWxob3N0OjgwODEvIiwiY3Jvc3NPcmlnaW4iOmZhbHNlfQ==";
        response.webAuthnType = "public-key";
        WebAuthnHelper.dumpWebAuthnRequest(response);
    }

    public static class PrettyPrinter {
        private int indent;

        private void indent() {
            for (int i = 0; i < this.indent; ++i) {
                System.err.print(" ");
            }
        }

        public void handleToken(CBORParser parser, JsonToken t) throws IOException {
            switch (t) {
                case END_ARRAY: {
                    this.endArray();
                    break;
                }
                case END_OBJECT: {
                    this.endObject();
                    break;
                }
                case FIELD_NAME: {
                    this.fieldName(parser.currentName());
                    break;
                }
                case NOT_AVAILABLE: {
                    break;
                }
                case START_ARRAY: {
                    this.startArray();
                    break;
                }
                case START_OBJECT: {
                    this.startObject();
                    break;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object embeddedObject = parser.getEmbeddedObject();
                    if (parser.currentName().equals("authData")) {
                        this.dumpAuthData((byte[])embeddedObject);
                        break;
                    }
                    System.err.println(embeddedObject);
                    break;
                }
                case VALUE_FALSE: {
                    this.falseConstant();
                    break;
                }
                case VALUE_NULL: {
                    this.nullConstant();
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    this.floatValue(parser.getFloatValue());
                    break;
                }
                case VALUE_NUMBER_INT: {
                    this.intValue(parser.getNumberValue());
                    break;
                }
                case VALUE_STRING: {
                    this.stringValue(parser.getValueAsString());
                    break;
                }
                case VALUE_TRUE: {
                    this.trueConstant();
                    break;
                }
            }
        }

        private void floatValue(float floatValue) {
            System.err.println(floatValue);
        }

        private void intValue(Number numberValue) {
            System.err.println(numberValue);
        }

        private void stringValue(String value) {
            System.err.println("\"" + value + "\"");
        }

        private void nullConstant() {
            System.err.println("null");
        }

        private void trueConstant() {
            System.err.println("true");
        }

        private void falseConstant() {
            System.err.println("false");
        }

        private void startObject() {
            this.indent();
            System.err.println("{");
            ++this.indent;
        }

        private void startArray() {
            this.indent();
            System.err.println("[");
            ++this.indent;
        }

        public void fieldName(String name) {
            this.indent();
            System.err.print("\"");
            System.err.print(name);
            System.err.print("\": ");
        }

        public void endObject() {
            this.indent();
            System.err.println("}");
            --this.indent;
        }

        public void endArray() {
            this.indent();
            System.err.println("]");
            --this.indent;
        }

        private void dumpAuthData(byte[] embeddedObject) throws IOException {
            Buffer buf = Buffer.buffer((byte[])embeddedObject);
            this.startObject();
            int current = 0;
            byte[] rpIdHash = buf.getBytes(0, 32);
            this.fieldName("rpIdHash");
            this.stringValue("<some hash>");
            byte flags = buf.getByte(current += 32);
            this.fieldName("flags");
            this.intValue(flags);
            long counter = buf.getUnsignedInt(++current);
            this.fieldName("counter");
            this.intValue(counter);
            if (embeddedObject.length > (current += 4)) {
                this.fieldName("attestedCredentialData");
                this.startObject();
                byte[] aaguid = buf.getBytes(current, current + 16);
                this.fieldName("aaguid");
                this.stringValue(Base64UrlUtil.encodeToString((byte[])aaguid));
                int credentialIdLength = buf.getUnsignedShort(current += 16);
                this.fieldName("credentialIdLength");
                this.intValue(credentialIdLength);
                byte[] credentialId = buf.getBytes(current += 2, current + credentialIdLength);
                current += credentialIdLength;
                this.fieldName("credentialId");
                this.stringValue(Base64UrlUtil.encodeToString((byte[])credentialId));
                this.fieldName("credentialPublicKey");
                current += this.readCBOR(embeddedObject, current);
                this.endObject();
            }
            this.endObject();
        }

        private int readCBOR(byte[] bytes, int offset) throws IOException {
            CBORFactory factory = CBORFactory.builder().build();
            long lastReadByte = offset;
            try (CBORParser parser = factory.createParser(bytes, offset, bytes.length - offset);){
                JsonToken t;
                while ((t = parser.nextToken()) != null) {
                    this.handleToken(parser, t);
                }
                lastReadByte = parser.currentLocation().getByteOffset();
            }
            return (int)(lastReadByte - (long)offset);
        }
    }
}

