/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.web.resteasy.reactive.runtime;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class SpringRequestParamHandler
implements HandlerChainCustomizer {
    public List<ServerRestHandler> handlers(HandlerChainCustomizer.Phase phase, ResourceClass resourceClass, final ServerResourceMethod resourceMethod) {
        if (phase == HandlerChainCustomizer.Phase.RESOLVE_METHOD_PARAMETERS) {
            return Collections.singletonList(new ServerRestHandler(){

                public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
                    Map parametersMap = requestContext.serverRequest().getQueryParamsMap();
                    if (parametersMap.isEmpty()) {
                        throw new WebApplicationException("Missing required param in method '" + resourceMethod.getName() + "'", Response.Status.BAD_REQUEST);
                    }
                }
            });
        }
        return Collections.emptyList();
    }
}

