/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.security.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.InterceptorBindingRegistrarBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.InterceptorBindingRegistrar;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.security.deployment.AdditionalSecurityCheckBuildItem;
import io.quarkus.security.deployment.SecurityTransformerUtils;
import io.quarkus.security.runtime.SecurityCheckRecorder;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.spring.di.deployment.SpringBeanNameToDotNameBuildItem;
import io.quarkus.spring.security.deployment.BeanMethodInvocationGenerator;
import io.quarkus.spring.security.deployment.DotNames;
import io.quarkus.spring.security.deployment.HasRoleValueUtil;
import io.quarkus.spring.security.deployment.ParameterNameAndIndex;
import io.quarkus.spring.security.deployment.SpringPreAuthorizeAnnotatedMethodBuildItem;
import io.quarkus.spring.security.deployment.SpringSecurityAnnotationsRegistrar;
import io.quarkus.spring.security.deployment.SpringSecurityProcessorUtil;
import io.quarkus.spring.security.deployment.StringPropertyAccessorData;
import io.quarkus.spring.security.deployment.StringPropertyAccessorGenerator;
import io.quarkus.spring.security.runtime.interceptor.SpringPreauthorizeInterceptor;
import io.quarkus.spring.security.runtime.interceptor.SpringSecuredInterceptor;
import io.quarkus.spring.security.runtime.interceptor.SpringSecurityRecorder;
import io.quarkus.spring.security.runtime.interceptor.check.PrincipalNameFromParameterObjectSecurityCheck;
import io.quarkus.spring.security.runtime.interceptor.check.PrincipalNameFromParameterSecurityCheck;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

class SpringSecurityProcessor {
    private static final String PARAMETER_EQ_PRINCIPAL_USERNAME_REGEX = "#(\\w+)(\\.(\\w+))?\\s+[=!]=\\s+(authentication.)?principal.username";
    private static final Pattern PARAMETER_EQ_PRINCIPAL_USERNAME_PATTERN = Pattern.compile("#(\\w+)(\\.(\\w+))?\\s+[=!]=\\s+(authentication.)?principal.username");
    private static final int PARAMETER_EQ_PRINCIPAL_USERNAME_PARAMETER_NAME_GROUP = 1;
    private static final int PARAMETER_EQ_PRINCIPAL_USERNAME_PROPERTY_ACCESSOR_MATCHER_GROUP = 3;

    SpringSecurityProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.SPRING_SECURITY);
    }

    @BuildStep
    void registerSecurityInterceptors(BuildProducer<InterceptorBindingRegistrarBuildItem> registrars, BuildProducer<AdditionalBeanBuildItem> beans) {
        registrars.produce((BuildItem)new InterceptorBindingRegistrarBuildItem((InterceptorBindingRegistrar)new SpringSecurityAnnotationsRegistrar()));
        beans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{SpringSecuredInterceptor.class}));
        beans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{SpringPreauthorizeInterceptor.class}));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void addSpringSecuredSecurityCheck(CombinedIndexBuildItem index, SecurityCheckRecorder securityCheckRecorder, BuildProducer<AdditionalSecurityCheckBuildItem> additionalSecurityCheckBuildItems) {
        String[] rolesAllowed;
        HashSet<MethodInfo> methodsWithSecurityAnnotation = new HashSet<MethodInfo>();
        for (AnnotationInstance instance : index.getIndex().getAnnotations(DotNames.SPRING_SECURED)) {
            if (instance.value() == null) continue;
            rolesAllowed = instance.value().asStringArray();
            if (instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            MethodInfo methodInfo = instance.target().asMethod();
            this.checksStandardSecurity(instance, methodInfo);
            this.checksStandardSecurity(instance, methodInfo.declaringClass());
            additionalSecurityCheckBuildItems.produce((BuildItem)new AdditionalSecurityCheckBuildItem(methodInfo, securityCheckRecorder.rolesAllowed(rolesAllowed)));
            methodsWithSecurityAnnotation.add(methodInfo);
        }
        for (AnnotationInstance instance : index.getIndex().getAnnotations(DotNames.SPRING_SECURED)) {
            if (instance.value() == null) continue;
            rolesAllowed = instance.value().asStringArray();
            if (instance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo classInfo = instance.target().asClass();
            this.checksStandardSecurity(instance, classInfo);
            for (MethodInfo methodInfo : classInfo.methods()) {
                if (!this.isPublicNonStaticNonConstructor(methodInfo)) continue;
                this.checksStandardSecurity(instance, methodInfo);
                if (this.hasSpringSecurityAnnotationOtherThan(methodInfo, DotNames.SPRING_SECURED) || methodsWithSecurityAnnotation.contains(methodInfo)) continue;
                additionalSecurityCheckBuildItems.produce((BuildItem)new AdditionalSecurityCheckBuildItem(methodInfo, securityCheckRecorder.rolesAllowed(rolesAllowed)));
            }
        }
    }

    private boolean hasSpringSecurityAnnotationOtherThan(MethodInfo methodInfo, DotName excluded) {
        HashSet<DotName> toCheck = new HashSet<DotName>(DotNames.SUPPORTED_SPRING_SECURITY_ANNOTATIONS);
        toCheck.remove(excluded);
        List annotations = methodInfo.annotations();
        for (AnnotationInstance instance : annotations) {
            if (!toCheck.contains(instance.name())) continue;
            return true;
        }
        return false;
    }

    private void checksStandardSecurity(AnnotationInstance instance, ClassInfo classInfo) {
        Optional firstStandardSecurityAnnotation;
        if (SecurityTransformerUtils.hasStandardSecurityAnnotation((ClassInfo)classInfo) && (firstStandardSecurityAnnotation = SecurityTransformerUtils.findFirstStandardSecurityAnnotation((ClassInfo)classInfo)).isPresent()) {
            String securityAnnotationName = ((AnnotationInstance)SecurityTransformerUtils.findFirstStandardSecurityAnnotation((ClassInfo)classInfo).get()).name().withoutPackagePrefix();
            throw new IllegalArgumentException("An invalid security annotation combination was detected: Found @" + instance.name().withoutPackagePrefix() + " and @" + securityAnnotationName + " on class " + classInfo.simpleName());
        }
    }

    private void checksStandardSecurity(AnnotationInstance instance, MethodInfo methodInfo) {
        Optional firstStandardSecurityAnnotation;
        if (SecurityTransformerUtils.hasStandardSecurityAnnotation((MethodInfo)methodInfo) && (firstStandardSecurityAnnotation = SecurityTransformerUtils.findFirstStandardSecurityAnnotation((MethodInfo)methodInfo)).isPresent()) {
            String securityAnnotationName = ((AnnotationInstance)SecurityTransformerUtils.findFirstStandardSecurityAnnotation((MethodInfo)methodInfo).get()).name().withoutPackagePrefix();
            throw new IllegalArgumentException("An invalid security annotation combination was detected: Found " + instance.name().withoutPackagePrefix() + " and " + securityAnnotationName + " on method " + methodInfo.name());
        }
    }

    private boolean isPublicNonStaticNonConstructor(MethodInfo methodInfo) {
        return Modifier.isPublic(methodInfo.flags()) && !Modifier.isStatic(methodInfo.flags()) && !"<init>".equals(methodInfo.name());
    }

    @BuildStep
    void locatePreAuthorizedInstances(CombinedIndexBuildItem index, BuildProducer<SpringPreAuthorizeAnnotatedMethodBuildItem> springPreAuthorizeAnnotatedMethods, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        HashMap<MethodInfo, AnnotationInstance> result = new HashMap<MethodInfo, AnnotationInstance>();
        for (Object instance : index.getIndex().getAnnotations(DotNames.SPRING_PRE_AUTHORIZE)) {
            if (instance.value() == null || instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            MethodInfo methodInfo = instance.target().asMethod();
            this.checksStandardSecurity((AnnotationInstance)instance, methodInfo);
            result.put(methodInfo, (AnnotationInstance)instance);
        }
        HashMap<DotName, ClassInfo> metaAnnotations = new HashMap<DotName, ClassInfo>();
        for (AnnotationInstance instance : index.getIndex().getAnnotations(DotNames.SPRING_PRE_AUTHORIZE)) {
            if (instance.value() == null || instance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo classInfo = instance.target().asClass();
            if (classInfo.isAnnotation()) {
                metaAnnotations.put(classInfo.name(), classInfo);
                continue;
            }
            this.checksStandardSecurity(instance, classInfo);
            for (MethodInfo methodInfo : classInfo.methods()) {
                if (!this.isPublicNonStaticNonConstructor(methodInfo)) continue;
                this.checksStandardSecurity(instance, methodInfo);
                if (this.hasSpringSecurityAnnotationOtherThan(methodInfo, DotNames.SPRING_PRE_AUTHORIZE) || result.containsKey(methodInfo)) continue;
                result.put(methodInfo, instance);
            }
        }
        final HashSet<DotName> classesInNeedOfAnnotationTransformation = new HashSet<DotName>();
        for (ClassInfo metaAnnotation : metaAnnotations.values()) {
            for (AnnotationInstance instance : index.getIndex().getAnnotations(metaAnnotation.name())) {
                if (instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                MethodInfo methodInfo = instance.target().asMethod();
                this.checksStandardSecurity(instance, methodInfo);
                result.put(methodInfo, metaAnnotation.declaredAnnotation(DotNames.SPRING_PRE_AUTHORIZE));
                classesInNeedOfAnnotationTransformation.add(methodInfo.declaringClass().name());
            }
        }
        springPreAuthorizeAnnotatedMethods.produce((BuildItem)new SpringPreAuthorizeAnnotatedMethodBuildItem(result));
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
                ClassInfo classInfo = transformationContext.getTarget().asClass();
                if (classesInNeedOfAnnotationTransformation.contains(classInfo.name())) {
                    transformationContext.transform().add(DotNames.SPRING_PRE_AUTHORIZE, new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)"")}).done();
                }
            }
        }));
    }

    @BuildStep
    void generateNecessarySupportClasses(CombinedIndexBuildItem index, SpringPreAuthorizeAnnotatedMethodBuildItem springPreAuthorizeAnnotatedMethods, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        HashMap<DotName, Set> stringPropertiesInNeedOfGeneratedAccessors = new HashMap<DotName, Set>();
        for (Map.Entry<MethodInfo, AnnotationInstance> entry : springPreAuthorizeAnnotatedMethods.getMethodToInstanceMap().entrySet()) {
            AnnotationInstance instance = entry.getValue();
            MethodInfo methodInfo = entry.getKey();
            String value = instance.value().asString().trim();
            String[] parts = new String[]{value};
            if (value.toLowerCase().contains(" and ")) {
                parts = value.split("(?i) and ");
            } else if (value.toLowerCase().contains(" or ")) {
                parts = value.split("(?i) or ");
            }
            for (String part : parts) {
                if (!(part = part.trim()).matches(PARAMETER_EQ_PRINCIPAL_USERNAME_REGEX)) continue;
                Matcher matcher = PARAMETER_EQ_PRINCIPAL_USERNAME_PATTERN.matcher(part);
                if (!matcher.find()) {
                    throw SpringSecurityProcessorUtil.createGenericMalformedException(methodInfo, part);
                }
                ParameterNameAndIndex parameterNameAndIndex = this.getParameterNameAndIndexForPrincipalUserNameReference(methodInfo, matcher, part);
                String propertyName = matcher.group(3);
                if (propertyName == null) continue;
                StringPropertyAccessorData stringPropertyAccessorData = StringPropertyAccessorData.from(methodInfo, parameterNameAndIndex.getIndex(), propertyName, index.getIndex(), part);
                Set fields = stringPropertiesInNeedOfGeneratedAccessors.getOrDefault(stringPropertyAccessorData.getMatchingParameterClassInfo().name(), new HashSet());
                fields.add(stringPropertyAccessorData.getMatchingParameterFieldInfo());
                stringPropertiesInNeedOfGeneratedAccessors.put(stringPropertyAccessorData.getMatchingParameterClassInfo().name(), fields);
            }
        }
        if (!stringPropertiesInNeedOfGeneratedAccessors.isEmpty()) {
            GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
            HashSet<String> generatedBeanClassNames = new HashSet<String>(stringPropertiesInNeedOfGeneratedAccessors.keySet().size());
            for (Map.Entry entry : stringPropertiesInNeedOfGeneratedAccessors.entrySet()) {
                String generateClassName = StringPropertyAccessorGenerator.generate((DotName)entry.getKey(), (Set)entry.getValue(), (ClassOutput)classOutput);
                generatedBeanClassNames.add(generateClassName);
            }
            unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanClassNamesExclusion(generatedBeanClassNames)));
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void addSpringPreAuthorizeSecurityCheck(CombinedIndexBuildItem index, SecurityCheckRecorder securityCheckRecorder, SpringSecurityRecorder springSecurityRecorder, SpringPreAuthorizeAnnotatedMethodBuildItem springPreAuthorizeAnnotatedMethods, SpringBeanNameToDotNameBuildItem springBeanNames, BuildProducer<AdditionalSecurityCheckBuildItem> additionalSecurityChecks, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<GeneratedClassBuildItem> generatedClasses) {
        Map springBeansNameToDotName = springBeanNames.getMap();
        HashMap<String, ClassInfo> springBeansNameToClassInfo = new HashMap<String, ClassInfo>();
        HashSet<String> beansReferencedInPreAuthorized = new HashSet<String>();
        BeanMethodInvocationGenerator beanMethodInvocationGenerator = new BeanMethodInvocationGenerator(index.getIndex(), springBeansNameToDotName, springBeansNameToClassInfo, beansReferencedInPreAuthorized, (ClassOutput)new GeneratedClassGizmoAdaptor(generatedClasses, true));
        for (Map.Entry<MethodInfo, AnnotationInstance> entry : springPreAuthorizeAnnotatedMethods.getMethodToInstanceMap().entrySet()) {
            AnnotationInstance instance = entry.getValue();
            MethodInfo methodInfo = entry.getKey();
            String value = instance.value().asString().trim();
            boolean containsAnd = false;
            boolean containsOr = false;
            String lowercaseValue = value.toLowerCase();
            if (lowercaseValue.contains(" or ")) {
                containsOr = true;
            }
            if (lowercaseValue.contains(" and ")) {
                containsAnd = true;
            }
            if (containsAnd && containsOr) {
                throw new IllegalStateException("Currently expressions containing both logical 'and' / 'or' are not supported. Offending expression is " + value + "' in the @PreAuthorize annotation on method '" + methodInfo.name() + "' of class '" + String.valueOf(methodInfo.declaringClass()));
            }
            String[] parts = new String[]{value};
            if (containsAnd) {
                parts = value.split("(?i) and ");
            } else if (containsOr) {
                parts = value.split("(?i) or ");
            }
            ArrayList<SecurityCheck> securityChecks = new ArrayList<SecurityCheck>(parts.length);
            for (String part : parts) {
                if ((part = part.trim()).equals("permitAll()")) {
                    securityChecks.add(securityCheckRecorder.permitAll());
                    continue;
                }
                if (part.equals("denyAll()")) {
                    securityChecks.add(securityCheckRecorder.denyAll());
                    continue;
                }
                if (part.equals("isAnonymous()")) {
                    securityChecks.add(springSecurityRecorder.anonymous());
                    continue;
                }
                if (part.replaceAll("\\s", "").equals("isAuthenticated()")) {
                    securityChecks.add(securityCheckRecorder.authenticated());
                    continue;
                }
                if (part.startsWith("hasRole(")) {
                    String hasRoleValue = part.replace("hasRole(", "").replace(")", "");
                    Supplier<String[]> hasRoleValueProducer = HasRoleValueUtil.getHasRoleValueProducer(hasRoleValue, methodInfo, index.getIndex(), springBeansNameToDotName, springBeansNameToClassInfo, beansReferencedInPreAuthorized, springSecurityRecorder);
                    securityChecks.add(springSecurityRecorder.rolesAllowed(Collections.singletonList(hasRoleValueProducer)));
                    continue;
                }
                if (part.startsWith("hasAnyRole(")) {
                    String hasRoleValues = part.replace("hasAnyRole(", "").replace(")", "");
                    String[] hasRoleParts = hasRoleValues.split(",");
                    ArrayList<Supplier<String[]>> hasRoleValueProducers = new ArrayList<Supplier<String[]>>(hasRoleParts.length);
                    for (String hasRolePart : hasRoleParts) {
                        hasRoleValueProducers.add(HasRoleValueUtil.getHasRoleValueProducer(hasRolePart.trim(), methodInfo, index.getIndex(), springBeansNameToDotName, springBeansNameToClassInfo, beansReferencedInPreAuthorized, springSecurityRecorder));
                    }
                    securityChecks.add(springSecurityRecorder.rolesAllowed(hasRoleValueProducers));
                    continue;
                }
                if (part.matches(PARAMETER_EQ_PRINCIPAL_USERNAME_REGEX)) {
                    Matcher matcher = PARAMETER_EQ_PRINCIPAL_USERNAME_PATTERN.matcher(part);
                    if (!matcher.find()) {
                        throw SpringSecurityProcessorUtil.createGenericMalformedException(methodInfo, part);
                    }
                    ParameterNameAndIndex parameterNameAndIndex = this.getParameterNameAndIndexForPrincipalUserNameReference(methodInfo, matcher, part);
                    String propertyName = matcher.group(3);
                    if (propertyName == null) {
                        if (!DotNames.STRING.equals((Object)methodInfo.parameterType(parameterNameAndIndex.getIndex()).name())) {
                            throw new IllegalArgumentException("Expression: '" + part + "' in the @PreAuthorize annotation on method '" + methodInfo.name() + "' of class '" + String.valueOf(methodInfo.declaringClass()) + "' references method parameter '" + parameterNameAndIndex.getName() + "' which is not a string");
                        }
                        PrincipalNameFromParameterSecurityCheck.CheckType checkType = part.contains("==") ? PrincipalNameFromParameterSecurityCheck.CheckType.EQ : PrincipalNameFromParameterSecurityCheck.CheckType.NEQ;
                        securityChecks.add(springSecurityRecorder.principalNameFromParameterSecurityCheck(parameterNameAndIndex.getIndex(), checkType));
                        continue;
                    }
                    StringPropertyAccessorData stringPropertyAccessorData = StringPropertyAccessorData.from(methodInfo, parameterNameAndIndex.getIndex(), propertyName, index.getIndex(), part);
                    PrincipalNameFromParameterObjectSecurityCheck.CheckType checkType = part.contains("==") ? PrincipalNameFromParameterObjectSecurityCheck.CheckType.EQ : PrincipalNameFromParameterObjectSecurityCheck.CheckType.NEQ;
                    securityChecks.add(springSecurityRecorder.principalNameFromParameterObjectSecurityCheck(parameterNameAndIndex.getIndex(), stringPropertyAccessorData.getMatchingParameterClassInfo().name().toString(), StringPropertyAccessorGenerator.getAccessorClassName(stringPropertyAccessorData.getMatchingParameterClassInfo().name()), stringPropertyAccessorData.getMatchingParameterFieldInfo().name(), checkType));
                    continue;
                }
                if (part.matches("@(\\w+)\\.(\\w+)\\(.*\\)")) {
                    String generatedClassName = beanMethodInvocationGenerator.generateSecurityCheck(part, methodInfo);
                    securityChecks.add(springSecurityRecorder.fromGeneratedClass(generatedClassName));
                    continue;
                }
                throw SpringSecurityProcessorUtil.createGenericMalformedException(methodInfo, part);
            }
            if (securityChecks.size() == 1) {
                additionalSecurityChecks.produce((BuildItem)new AdditionalSecurityCheckBuildItem(methodInfo, (SecurityCheck)securityChecks.get(0)));
                continue;
            }
            if (containsAnd) {
                additionalSecurityChecks.produce((BuildItem)new AdditionalSecurityCheckBuildItem(methodInfo, springSecurityRecorder.allDelegating(securityChecks)));
                continue;
            }
            if (!containsOr) continue;
            additionalSecurityChecks.produce((BuildItem)new AdditionalSecurityCheckBuildItem(methodInfo, springSecurityRecorder.anyDelegating(securityChecks)));
        }
        if (!beansReferencedInPreAuthorized.isEmpty()) {
            unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanClassNamesExclusion(beansReferencedInPreAuthorized)));
        }
    }

    private ParameterNameAndIndex getParameterNameAndIndexForPrincipalUserNameReference(MethodInfo methodInfo, Matcher matcher, String expression) {
        String parameterName = matcher.group(1);
        return new ParameterNameAndIndex(SpringSecurityProcessorUtil.getParameterIndex(methodInfo, parameterName, expression), parameterName);
    }
}

