/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.rest.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.rest.data.panache.RestDataPanacheException;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.RestDataResourceBuildItem;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.properties.ResourcePropertiesBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.reactive.spi.ExceptionMapperBuildItem;
import io.quarkus.spring.data.rest.deployment.EntityClassHelper;
import io.quarkus.spring.data.rest.deployment.RepositoryMethodsImplementor;
import io.quarkus.spring.data.rest.deployment.RepositoryPropertiesProvider;
import io.quarkus.spring.data.rest.deployment.ResourceImplementor;
import io.quarkus.spring.data.rest.deployment.ResourceMethodsImplementor;
import io.quarkus.spring.data.rest.runtime.RestDataPanacheExceptionMapper;
import io.quarkus.spring.data.rest.runtime.jta.TransactionalUpdateExecutor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.ListCrudRepository;
import org.springframework.data.repository.ListPagingAndSortingRepository;
import org.springframework.data.repository.PagingAndSortingRepository;

class SpringDataRestProcessor {
    private static final DotName CRUD_REPOSITORY_INTERFACE = DotName.createSimple((String)CrudRepository.class.getName());
    private static final DotName LIST_CRUD_REPOSITORY_INTERFACE = DotName.createSimple((String)ListCrudRepository.class.getName());
    private static final DotName PAGING_AND_SORTING_REPOSITORY_INTERFACE = DotName.createSimple((String)PagingAndSortingRepository.class.getName());
    private static final DotName LIST_PAGING_AND_SORTING_REPOSITORY_INTERFACE = DotName.createSimple((String)ListPagingAndSortingRepository.class.getName());
    private static final DotName JPA_REPOSITORY_INTERFACE = DotName.createSimple((String)JpaRepository.class.getName());
    private static final List<DotName> EXCLUDED_INTERFACES = Arrays.asList(CRUD_REPOSITORY_INTERFACE, LIST_CRUD_REPOSITORY_INTERFACE, PAGING_AND_SORTING_REPOSITORY_INTERFACE, LIST_PAGING_AND_SORTING_REPOSITORY_INTERFACE, JPA_REPOSITORY_INTERFACE);

    SpringDataRestProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.SPRING_DATA_REST);
    }

    @BuildStep
    void registerRestDataPanacheExceptionMapper(BuildProducer<ResteasyJaxrsProviderBuildItem> resteasyJaxrsProviderBuildItemBuildProducer, BuildProducer<ExceptionMapperBuildItem> exceptionMapperBuildItemBuildProducer) {
        resteasyJaxrsProviderBuildItemBuildProducer.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(RestDataPanacheExceptionMapper.class.getName()));
        exceptionMapperBuildItemBuildProducer.produce((BuildItem)new ExceptionMapperBuildItem(RestDataPanacheExceptionMapper.class.getName(), RestDataPanacheException.class.getName(), Integer.valueOf(5100), false));
    }

    @BuildStep
    AdditionalBeanBuildItem registerTransactionalExecutor() {
        return AdditionalBeanBuildItem.unremovableOf(TransactionalUpdateExecutor.class);
    }

    @BuildStep
    void registerRepositories(CombinedIndexBuildItem indexBuildItem, Capabilities capabilities, BuildProducer<GeneratedBeanBuildItem> implementationsProducer, BuildProducer<RestDataResourceBuildItem> restDataResourceProducer, BuildProducer<ResourcePropertiesBuildItem> resourcePropertiesProducer, BuildProducer<UnremovableBeanBuildItem> unremovableBeansProducer) {
        IndexView index = indexBuildItem.getIndex();
        EntityClassHelper entityClassHelper = new EntityClassHelper(index);
        List<ClassInfo> repositoriesToImplement = this.getRepositoriesToImplement(index, CRUD_REPOSITORY_INTERFACE, LIST_CRUD_REPOSITORY_INTERFACE, PAGING_AND_SORTING_REPOSITORY_INTERFACE, LIST_PAGING_AND_SORTING_REPOSITORY_INTERFACE, JPA_REPOSITORY_INTERFACE);
        this.implementResources(capabilities, implementationsProducer, restDataResourceProducer, resourcePropertiesProducer, unremovableBeansProducer, new RepositoryMethodsImplementor(index, entityClassHelper), index, repositoriesToImplement);
    }

    private void implementResources(Capabilities capabilities, BuildProducer<GeneratedBeanBuildItem> implementationsProducer, BuildProducer<RestDataResourceBuildItem> restDataResourceProducer, BuildProducer<ResourcePropertiesBuildItem> resourcePropertiesProducer, BuildProducer<UnremovableBeanBuildItem> unremovableBeansProducer, ResourceMethodsImplementor methodsImplementor, IndexView index, List<ClassInfo> repositoriesToImplement) {
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(implementationsProducer);
        ResourceImplementor resourceImplementor = new ResourceImplementor(methodsImplementor);
        EntityClassHelper entityClassHelper = new EntityClassHelper(index);
        for (ClassInfo classInfo : repositoriesToImplement) {
            boolean paged = false;
            if (entityClassHelper.isPagingAndSortingRepository(classInfo.name().toString())) {
                paged = true;
            }
            RepositoryPropertiesProvider propertiesProvider = new RepositoryPropertiesProvider(index, paged);
            List<Type> generics = this.getGenericTypes(classInfo);
            String repositoryName = classInfo.name().toString();
            String entityType = generics.get(0).name().toString();
            String idType = generics.get(1).name().toString();
            String resourceClass = resourceImplementor.implement((ClassOutput)classOutput, repositoryName, entityType);
            restDataResourceProducer.produce((BuildItem)new RestDataResourceBuildItem(new ResourceMetadata(resourceClass, repositoryName, null, entityType, idType, Collections.emptyMap())));
            ResourceProperties resourceProperties = propertiesProvider.getResourceProperties(repositoryName);
            resourcePropertiesProducer.produce((BuildItem)new ResourcePropertiesBuildItem(resourceClass, resourceProperties));
            unremovableBeansProducer.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanTypeExclusion(DotName.createSimple((String)repositoryName))));
        }
    }

    private List<ClassInfo> getRepositoriesToImplement(IndexView indexView, DotName ... repositoryInterfaces) {
        LinkedList<ClassInfo> result = new LinkedList<ClassInfo>();
        for (DotName repositoryInterface : repositoryInterfaces) {
            for (ClassInfo classInfo : indexView.getKnownDirectImplementors(repositoryInterface)) {
                if (this.hasImplementors(indexView, classInfo) || EXCLUDED_INTERFACES.contains(classInfo.name())) continue;
                this.validateResource(classInfo);
                result.add(classInfo);
            }
        }
        return result;
    }

    private boolean hasImplementors(IndexView index, ClassInfo classInfo) {
        return !index.getKnownDirectImplementors(classInfo.name()).isEmpty();
    }

    private void validateResource(ClassInfo classInfo) {
        if (!Modifier.isInterface(classInfo.flags())) {
            throw new RuntimeException(String.valueOf(classInfo.name()) + " has to be an interface");
        }
    }

    private List<Type> getGenericTypes(ClassInfo classInfo) {
        return ((Type)classInfo.interfaceTypes().stream().findFirst().orElseThrow(() -> new RuntimeException(classInfo.toString() + " does not have generic types"))).asParameterizedType().arguments();
    }
}

