/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.rest.deployment;

import io.quarkus.spring.data.rest.deployment.RepositoryMethodsImplementor;
import io.quarkus.spring.data.rest.deployment.ResourcePropertiesProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.springframework.data.domain.Pageable;

public class RepositoryPropertiesProvider
extends ResourcePropertiesProvider {
    private static final DotName PAGEABLE = DotName.createSimple((String)Pageable.class.getName());

    public RepositoryPropertiesProvider(IndexView index, boolean paged) {
        super(index, paged);
    }

    @Override
    protected Map<String, Predicate<MethodInfo>> getMethodPredicates() {
        HashMap<String, Predicate<MethodInfo>> methodPredicates = new HashMap<String, Predicate<MethodInfo>>();
        methodPredicates.put("list", methodInfo -> methodInfo.name().equals(RepositoryMethodsImplementor.LIST.getName()));
        methodPredicates.put("listIterable", methodInfo -> methodInfo.name().equals(RepositoryMethodsImplementor.LIST_ITERABLE.getName()));
        methodPredicates.put("listPaged", methodInfo -> methodInfo.name().equals(RepositoryMethodsImplementor.LIST_PAGED.getName()) && methodInfo.parametersCount() == 1 && methodInfo.parameterType(0).name().equals((Object)PAGEABLE));
        methodPredicates.put("addAll", methodInfo -> methodInfo.name().equals(RepositoryMethodsImplementor.SAVE_LIST.getName()));
        methodPredicates.put("get", methodInfo -> methodInfo.name().equals(RepositoryMethodsImplementor.GET.getName()));
        methodPredicates.put("add", methodInfo -> methodInfo.name().equals(RepositoryMethodsImplementor.ADD.getName()));
        methodPredicates.put("update", methodInfo -> methodInfo.name().equals(RepositoryMethodsImplementor.UPDATE.getName()));
        methodPredicates.put("delete", methodInfo -> methodInfo.name().equals(RepositoryMethodsImplementor.DELETE.getName()));
        return methodPredicates;
    }
}

