/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.deployment;

import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.smallrye.jwt.deployment.GenerateEncryptedDevModeJwtKeysBuildItem;
import io.quarkus.smallrye.jwt.deployment.GeneratePersistentDevModeJwtKeysBuildItem;
import io.smallrye.jwt.util.KeyUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class SmallryeJwtDevModeProcessor {
    private static final Logger LOGGER = Logger.getLogger(SmallryeJwtDevModeProcessor.class);
    public static final String MP_JWT_VERIFY_PUBLIC_KEY = "mp.jwt.verify.publickey";
    private static final String MP_JWT_VERIFY_ISSUER = "mp.jwt.verify.issuer";
    private static final String SMALLRYE_JWT_DECRYPT_KEY = "smallrye.jwt.decrypt.key";
    private static final String MP_JWT_DECRYPT_KEY_LOCATION = "mp.jwt.decrypt.key.location";
    private static final String SMALLRYE_JWT_NEW_TOKEN_ISSUER = "smallrye.jwt.new-token.issuer";
    private static final String SMALLRYE_JWT_SIGN_KEY_LOCATION = "smallrye.jwt.sign.key.location";
    public static final String SMALLRYE_JWT_SIGN_KEY = "smallrye.jwt.sign.key";
    private static final String SMALLRYE_JWT_ENCRYPT_KEY = "smallrye.jwt.encrypt.key";
    private static final String SMALLRYE_JWT_ENCRYPT_KEY_LOCATION = "smallrye.jwt.encrypt.key.location";
    private static final String NONE = "NONE";
    private static final String DEFAULT_ISSUER = "https://quarkus.io/issuer";
    private static final int KEY_SIZE = 2048;
    private static final Set<String> JWT_SIGN_KEY_PROPERTIES = Set.of("mp.jwt.verify.publickey.location", "mp.jwt.verify.publickey", "smallrye.jwt.decrypt.key", "mp.jwt.decrypt.key.location", "smallrye.jwt.sign.key.location", "smallrye.jwt.sign.key", "smallrye.jwt.encrypt.key", "smallrye.jwt.encrypt.key.location");
    public static final String DEV_PRIVATE_KEY_PEM = "dev.privateKey.pem";
    public static final String DEV_PUBLIC_KEY_PEM = "dev.publicKey.pem";

    @BuildStep(onlyIfNot={IsNormal.class})
    void generateSignKeys(BuildProducer<DevServicesResultBuildItem> devServices, LiveReloadBuildItem liveReloadBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, Optional<GeneratePersistentDevModeJwtKeysBuildItem> generatePersistentDevModeJwtKeysBuildItem, Optional<GenerateEncryptedDevModeJwtKeysBuildItem> generateEncryptedDevModeJwtKeysBuildItem) throws GeneralSecurityException, IOException {
        Set<String> userProps = JWT_SIGN_KEY_PROPERTIES.stream().filter(this::isConfigPresent).collect(Collectors.toSet());
        if (!userProps.isEmpty()) {
            Map<String, String> devServiceProps = this.addDefaultSmallryePropertiesIfMissing(userProps, generateEncryptedDevModeJwtKeysBuildItem);
            if (!this.isConfigPresent(MP_JWT_VERIFY_ISSUER) && !this.isConfigPresent(SMALLRYE_JWT_NEW_TOKEN_ISSUER)) {
                devServiceProps.put(MP_JWT_VERIFY_ISSUER, DEFAULT_ISSUER);
                devServiceProps.put(SMALLRYE_JWT_NEW_TOKEN_ISSUER, DEFAULT_ISSUER);
            }
            devServices.produce((BuildItem)this.smallryeJwtDevServiceWith(devServiceProps));
            return;
        }
        KeyPairContext ctx = (KeyPairContext)liveReloadBuildItem.getContextObject(KeyPairContext.class);
        LOGGER.info((Object)"The smallrye-jwt extension has configured an in-memory key pair, which is not enabled in production. Please ensure the correct keys/locations are set in production to avoid potential issues.");
        if (ctx == null && !liveReloadBuildItem.isLiveReload()) {
            KeyPair keyPair = this.generateOrReloadKeyPair(curateOutcomeBuildItem, generatePersistentDevModeJwtKeysBuildItem);
            String publicKey = SmallryeJwtDevModeProcessor.getStringKey(keyPair.getPublic());
            String privateKey = SmallryeJwtDevModeProcessor.getStringKey(keyPair.getPrivate());
            Map<String, String> devServiceProps = SmallryeJwtDevModeProcessor.generateDevServiceProperties(publicKey, privateKey, generateEncryptedDevModeJwtKeysBuildItem);
            if (!this.isConfigPresent(MP_JWT_VERIFY_ISSUER) && !this.isConfigPresent(SMALLRYE_JWT_NEW_TOKEN_ISSUER)) {
                devServiceProps.put(MP_JWT_VERIFY_ISSUER, DEFAULT_ISSUER);
                devServiceProps.put(SMALLRYE_JWT_NEW_TOKEN_ISSUER, DEFAULT_ISSUER);
            }
            liveReloadBuildItem.setContextObject(KeyPairContext.class, (Object)new KeyPairContext(devServiceProps));
            devServices.produce((BuildItem)this.smallryeJwtDevServiceWith(devServiceProps));
        }
        if (ctx != null && liveReloadBuildItem.isLiveReload()) {
            devServices.produce((BuildItem)this.smallryeJwtDevServiceWith(ctx.properties()));
        }
    }

    private KeyPair generateOrReloadKeyPair(CurateOutcomeBuildItem curateOutcomeBuildItem, Optional<GeneratePersistentDevModeJwtKeysBuildItem> generatePersistentDevModeJwtKeysBuildItem) throws GeneralSecurityException, IOException {
        if (generatePersistentDevModeJwtKeysBuildItem.isPresent()) {
            File buildDir = SmallryeJwtDevModeProcessor.getBuildDir(curateOutcomeBuildItem);
            buildDir.mkdirs();
            File privateKey = new File(buildDir, DEV_PRIVATE_KEY_PEM);
            File publicKey = new File(buildDir, DEV_PUBLIC_KEY_PEM);
            if (!privateKey.exists() || !publicKey.exists()) {
                KeyPair keyPair = KeyUtils.generateKeyPair((int)2048);
                LOGGER.infof("Generating private/public keys for DEV/TEST in %s and %s", (Object)privateKey, (Object)publicKey);
                try (FileWriter fw = new FileWriter(privateKey);){
                    fw.append("-----BEGIN PRIVATE KEY-----\n");
                    fw.append(Base64.getMimeEncoder().encodeToString(keyPair.getPrivate().getEncoded()));
                    fw.append("\n");
                    fw.append("-----END PRIVATE KEY-----\n");
                }
                fw = new FileWriter(publicKey);
                try {
                    fw.append("-----BEGIN PUBLIC KEY-----\n");
                    fw.append(Base64.getMimeEncoder().encodeToString(keyPair.getPublic().getEncoded()));
                    fw.append("\n");
                    fw.append("-----END PUBLIC KEY-----\n");
                }
                finally {
                    fw.close();
                }
                return keyPair;
            }
            return new KeyPair(KeyUtils.readPublicKey((String)publicKey.getName()), KeyUtils.readPrivateKey((String)privateKey.getName()));
        }
        return KeyUtils.generateKeyPair((int)2048);
    }

    public static File getBuildDir(CurateOutcomeBuildItem curateOutcomeBuildItem) {
        File buildDir = null;
        ArtifactSources src = curateOutcomeBuildItem.getApplicationModel().getAppArtifact().getSources();
        if (src != null) {
            Collection srcDirs = src.getResourceDirs();
            if (srcDirs.isEmpty()) {
                srcDirs = src.getSourceDirs();
            }
            if (!srcDirs.isEmpty()) {
                Path resourcesOutputDir = ((SourceDir)srcDirs.iterator().next()).getOutputDir();
                buildDir = resourcesOutputDir.toFile();
            }
        }
        if (buildDir == null) {
            buildDir = new File(curateOutcomeBuildItem.getApplicationModel().getAppArtifact().getWorkspaceModule().getBuildDir(), "classes");
        }
        return buildDir;
    }

    private Map<String, String> addDefaultSmallryePropertiesIfMissing(Set<String> userConfigs, Optional<GenerateEncryptedDevModeJwtKeysBuildItem> generateEncryptedDevModeJwtKeysBuildItem) {
        HashMap<String, String> devServiceConfigs = new HashMap<String, String>();
        if (!userConfigs.contains(SMALLRYE_JWT_SIGN_KEY)) {
            devServiceConfigs.put(SMALLRYE_JWT_SIGN_KEY, NONE);
        }
        if (!userConfigs.contains(MP_JWT_VERIFY_PUBLIC_KEY)) {
            devServiceConfigs.put(MP_JWT_VERIFY_PUBLIC_KEY, NONE);
        }
        if (generateEncryptedDevModeJwtKeysBuildItem.isPresent()) {
            if (!userConfigs.contains(SMALLRYE_JWT_ENCRYPT_KEY) && !userConfigs.contains(SMALLRYE_JWT_ENCRYPT_KEY_LOCATION)) {
                devServiceConfigs.put(SMALLRYE_JWT_ENCRYPT_KEY, NONE);
            }
            if (!userConfigs.contains(SMALLRYE_JWT_DECRYPT_KEY) && !userConfigs.contains(MP_JWT_DECRYPT_KEY_LOCATION)) {
                devServiceConfigs.put(SMALLRYE_JWT_DECRYPT_KEY, NONE);
            }
        }
        return devServiceConfigs;
    }

    private boolean isConfigPresent(String property) {
        return ConfigProvider.getConfig().getOptionalValue(property, String.class).isPresent();
    }

    private DevServicesResultBuildItem smallryeJwtDevServiceWith(Map<String, String> properties) {
        return DevServicesResultBuildItem.discovered().feature(Feature.SMALLRYE_JWT).config(properties).build();
    }

    private static Map<String, String> generateDevServiceProperties(String publicKey, String privateKey, Optional<GenerateEncryptedDevModeJwtKeysBuildItem> generateEncryptedDevModeJwtKeysBuildItem) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(MP_JWT_VERIFY_PUBLIC_KEY, publicKey);
        properties.put(SMALLRYE_JWT_SIGN_KEY, privateKey);
        if (generateEncryptedDevModeJwtKeysBuildItem.isPresent()) {
            properties.put(SMALLRYE_JWT_ENCRYPT_KEY, publicKey);
            properties.put(SMALLRYE_JWT_DECRYPT_KEY, privateKey);
        }
        return properties;
    }

    private static String getStringKey(Key key) {
        return Base64.getEncoder().encodeToString(key.getEncoded());
    }

    record KeyPairContext(Map<String, String> properties) {
    }
}

