/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.smallrye.jwt.util.KeyUtils;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class SmallryeJwtDevModeProcessor {
    private static final Logger LOGGER = Logger.getLogger(SmallryeJwtDevModeProcessor.class);
    private static final String MP_JWT_VERIFY_PUBLIC_KEY = "mp.jwt.verify.publickey";
    private static final String MP_JWT_VERIFY_ISSUER = "mp.jwt.verify.issuer";
    private static final String SMALLRYE_JWT_NEW_TOKEN_ISSUER = "smallrye.jwt.new-token.issuer";
    private static final String SMALLRYE_JWT_SIGN_KEY_LOCATION = "smallrye.jwt.sign.key.location";
    private static final String SMALLRYE_JWT_SIGN_KEY = "smallrye.jwt.sign.key";
    private static final String NONE = "NONE";
    private static final String DEFAULT_ISSUER = "https://quarkus.io/issuer";
    private static final int KEY_SIZE = 2048;
    private static final Set<String> JWT_SIGN_KEY_PROPERTIES = Set.of("mp.jwt.verify.publickey.location", "mp.jwt.verify.publickey", "smallrye.jwt.sign.key.location", "smallrye.jwt.sign.key");

    @BuildStep(onlyIfNot={IsNormal.class})
    void generateSignKeys(BuildProducer<DevServicesResultBuildItem> devServices, LiveReloadBuildItem liveReloadBuildItem) throws NoSuchAlgorithmException {
        Set<String> userProps = JWT_SIGN_KEY_PROPERTIES.stream().filter(this::isConfigPresent).collect(Collectors.toSet());
        if (!userProps.isEmpty()) {
            Map<String, String> devServiceProps = this.addDefaultSmallryePropertiesIfMissing(userProps);
            if (!this.isConfigPresent(MP_JWT_VERIFY_ISSUER) && !this.isConfigPresent(SMALLRYE_JWT_NEW_TOKEN_ISSUER)) {
                devServiceProps.put(MP_JWT_VERIFY_ISSUER, DEFAULT_ISSUER);
                devServiceProps.put(SMALLRYE_JWT_NEW_TOKEN_ISSUER, DEFAULT_ISSUER);
            }
            devServices.produce((BuildItem)this.smallryeJwtDevServiceWith(devServiceProps));
            return;
        }
        KeyPairContext ctx = (KeyPairContext)liveReloadBuildItem.getContextObject(KeyPairContext.class);
        LOGGER.info((Object)"The smallrye-jwt extension has configured an in-memory key pair, which is not enabled in production. Please ensure the correct keys/locations are set in production to avoid potential issues.");
        if (ctx == null && !liveReloadBuildItem.isLiveReload()) {
            KeyPair keyPair = KeyUtils.generateKeyPair((int)2048);
            String publicKey = SmallryeJwtDevModeProcessor.getStringKey(keyPair.getPublic());
            String privateKey = SmallryeJwtDevModeProcessor.getStringKey(keyPair.getPrivate());
            Map<String, String> devServiceProps = SmallryeJwtDevModeProcessor.generateDevServiceProperties(publicKey, privateKey);
            if (!this.isConfigPresent(MP_JWT_VERIFY_ISSUER) && !this.isConfigPresent(SMALLRYE_JWT_NEW_TOKEN_ISSUER)) {
                devServiceProps.put(MP_JWT_VERIFY_ISSUER, DEFAULT_ISSUER);
                devServiceProps.put(SMALLRYE_JWT_NEW_TOKEN_ISSUER, DEFAULT_ISSUER);
            }
            liveReloadBuildItem.setContextObject(KeyPairContext.class, (Object)new KeyPairContext(devServiceProps));
            devServices.produce((BuildItem)this.smallryeJwtDevServiceWith(devServiceProps));
        }
        if (ctx != null && liveReloadBuildItem.isLiveReload()) {
            devServices.produce((BuildItem)this.smallryeJwtDevServiceWith(ctx.properties()));
        }
    }

    private Map<String, String> addDefaultSmallryePropertiesIfMissing(Set<String> userConfigs) {
        HashMap<String, String> devServiceConfigs = new HashMap<String, String>();
        if (!userConfigs.contains(SMALLRYE_JWT_SIGN_KEY)) {
            devServiceConfigs.put(SMALLRYE_JWT_SIGN_KEY, NONE);
        }
        if (!userConfigs.contains(MP_JWT_VERIFY_PUBLIC_KEY)) {
            devServiceConfigs.put(MP_JWT_VERIFY_PUBLIC_KEY, NONE);
        }
        return devServiceConfigs;
    }

    private boolean isConfigPresent(String property) {
        return ConfigProvider.getConfig().getOptionalValue(property, String.class).isPresent();
    }

    private DevServicesResultBuildItem smallryeJwtDevServiceWith(Map<String, String> properties) {
        return new DevServicesResultBuildItem(Feature.SMALLRYE_JWT.name(), null, properties);
    }

    private static Map<String, String> generateDevServiceProperties(String publicKey, String privateKey) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(MP_JWT_VERIFY_PUBLIC_KEY, publicKey);
        properties.put(SMALLRYE_JWT_SIGN_KEY, privateKey);
        return properties;
    }

    private static String getStringKey(Key key) {
        return Base64.getEncoder().encodeToString(key.getEncoded());
    }

    record KeyPairContext(Map<String, String> properties) {
    }
}

