/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.deployment;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.ModuleInfo;
import org.jboss.jandex.RecordComponentInfo;
import org.jboss.jandex.Type;

public class OverridableIndex
implements IndexView {
    private final IndexView original;
    private final IndexView override;
    private Comparator<ClassInfo> classInfoComparator = new Comparator<ClassInfo>(){

        @Override
        public int compare(ClassInfo t, ClassInfo t1) {
            return t.name().toString().compareTo(t1.name().toString());
        }
    };
    private Comparator<Type> typeComparator = new Comparator<Type>(){

        @Override
        public int compare(Type t, Type t1) {
            return t.name().toString().compareTo(t1.name().toString());
        }
    };
    private Comparator<ModuleInfo> moduleInfoComparator = new Comparator<ModuleInfo>(){

        @Override
        public int compare(ModuleInfo t, ModuleInfo t1) {
            return t.name().toString().compareTo(t1.name().toString());
        }
    };
    private Comparator<FieldInfo> fieldInfoComparator = new Comparator<FieldInfo>(){

        @Override
        public int compare(FieldInfo t, FieldInfo t1) {
            if (OverridableIndex.this.classInfoComparator.compare(t.declaringClass(), t1.declaringClass()) == 0) {
                return t.name().toString().compareTo(t1.name().toString());
            }
            return -1;
        }
    };
    private Comparator<RecordComponentInfo> recordComponentInfoComparator = new Comparator<RecordComponentInfo>(){

        @Override
        public int compare(RecordComponentInfo t, RecordComponentInfo t1) {
            if (OverridableIndex.this.classInfoComparator.compare(t.declaringClass(), t1.declaringClass()) == 0) {
                return t.name().toString().compareTo(t1.name().toString());
            }
            return -1;
        }
    };
    private Comparator<MethodInfo> methodInfoComparator = new Comparator<MethodInfo>(){

        @Override
        public int compare(MethodInfo t, MethodInfo t1) {
            if (OverridableIndex.this.classInfoComparator.compare(t.declaringClass(), t1.declaringClass()) == 0 && t.name().toString().compareTo(t1.name().toString()) == 0 && t.parametersCount() == t1.parametersCount()) {
                for (int i = 0; i < t.parametersCount(); ++i) {
                    int typeTheSame = OverridableIndex.this.typeComparator.compare(t.parameterType(i), t1.parameterType(i));
                    if (typeTheSame == 0) continue;
                    return typeTheSame;
                }
                return 0;
            }
            return -1;
        }
    };
    private Comparator<MethodParameterInfo> methodParameterInfoComparator = new Comparator<MethodParameterInfo>(){

        @Override
        public int compare(MethodParameterInfo t, MethodParameterInfo t1) {
            if (OverridableIndex.this.methodInfoComparator.compare(t.method(), t1.method()) == 0 && t.kind().equals((Object)t1.kind()) && t.name().equals(t1.name()) && t.position() == t1.position()) {
                return 0;
            }
            return -1;
        }
    };
    private Comparator<AnnotationInstance> annotationInstanceComparator = new Comparator<AnnotationInstance>(){

        @Override
        public int compare(AnnotationInstance t, AnnotationInstance t1) {
            if (t.name().equals((Object)t1.name())) {
                if (t.target().kind().equals((Object)AnnotationTarget.Kind.CLASS) && t1.target().kind().equals((Object)AnnotationTarget.Kind.CLASS)) {
                    return OverridableIndex.this.classInfoComparator.compare(t.target().asClass(), t1.target().asClass());
                }
                if (t.target().kind().equals((Object)AnnotationTarget.Kind.FIELD) && t1.target().kind().equals((Object)AnnotationTarget.Kind.FIELD)) {
                    return OverridableIndex.this.fieldInfoComparator.compare(t.target().asField(), t1.target().asField());
                }
                if (t.target().kind().equals((Object)AnnotationTarget.Kind.TYPE) && t1.target().kind().equals((Object)AnnotationTarget.Kind.TYPE)) {
                    return OverridableIndex.this.typeComparator.compare(t.target().asType().target(), t1.target().asType().target());
                }
                if (t.target().kind().equals((Object)AnnotationTarget.Kind.METHOD) && t1.target().kind().equals((Object)AnnotationTarget.Kind.METHOD)) {
                    return OverridableIndex.this.methodInfoComparator.compare(t.target().asMethod(), t1.target().asMethod());
                }
                if (t.target().kind().equals((Object)AnnotationTarget.Kind.METHOD_PARAMETER) && t1.target().kind().equals((Object)AnnotationTarget.Kind.METHOD_PARAMETER)) {
                    return OverridableIndex.this.methodParameterInfoComparator.compare(t.target().asMethodParameter(), t1.target().asMethodParameter());
                }
                if (t.target().kind().equals((Object)AnnotationTarget.Kind.RECORD_COMPONENT) && t1.target().kind().equals((Object)AnnotationTarget.Kind.RECORD_COMPONENT)) {
                    return OverridableIndex.this.recordComponentInfoComparator.compare(t.target().asRecordComponent(), t1.target().asRecordComponent());
                }
            }
            return -1;
        }
    };

    private OverridableIndex(IndexView original, IndexView override) {
        this.original = original;
        this.override = override;
    }

    public static OverridableIndex create(IndexView original, IndexView override) {
        return new OverridableIndex(original, override);
    }

    public Collection<ClassInfo> getKnownClasses() {
        return this.overrideCollection(this.original.getKnownClasses(), this.override.getKnownClasses(), this.classInfoComparator);
    }

    public ClassInfo getClassByName(DotName dn) {
        return this.overrideObject(this.original.getClassByName(dn), this.override.getClassByName(dn));
    }

    public Collection<ClassInfo> getKnownDirectSubclasses(DotName dn) {
        return this.overrideCollection(this.original.getKnownDirectSubclasses(dn), this.override.getKnownDirectSubclasses(dn), this.classInfoComparator);
    }

    public Collection<ClassInfo> getAllKnownSubclasses(DotName dn) {
        return this.overrideCollection(this.original.getAllKnownSubclasses(dn), this.override.getAllKnownSubclasses(dn), this.classInfoComparator);
    }

    public Collection<ClassInfo> getKnownDirectSubinterfaces(DotName dn) {
        return this.overrideCollection(this.original.getKnownDirectSubinterfaces(dn), this.override.getKnownDirectSubinterfaces(dn), this.classInfoComparator);
    }

    public Collection<ClassInfo> getAllKnownSubinterfaces(DotName dn) {
        return this.overrideCollection(this.original.getAllKnownSubinterfaces(dn), this.override.getAllKnownSubinterfaces(dn), this.classInfoComparator);
    }

    public Collection<ClassInfo> getKnownDirectImplementors(DotName dn) {
        return this.overrideCollection(this.original.getKnownDirectImplementors(dn), this.override.getKnownDirectImplementors(dn), this.classInfoComparator);
    }

    public Collection<ClassInfo> getAllKnownImplementors(DotName dn) {
        return this.overrideCollection(this.original.getAllKnownImplementors(dn), this.override.getAllKnownImplementors(dn), this.classInfoComparator);
    }

    public Collection<AnnotationInstance> getAnnotations(DotName dn) {
        return this.overrideCollection(this.original.getAnnotations(dn), this.override.getAnnotations(dn), this.annotationInstanceComparator);
    }

    public Collection<AnnotationInstance> getAnnotationsWithRepeatable(DotName dn, IndexView iv) {
        return this.overrideCollection(this.original.getAnnotationsWithRepeatable(dn, iv), this.override.getAnnotationsWithRepeatable(dn, iv), this.annotationInstanceComparator);
    }

    public Collection<ModuleInfo> getKnownModules() {
        return this.overrideCollection(this.original.getKnownModules(), this.override.getKnownModules(), this.moduleInfoComparator);
    }

    public ModuleInfo getModuleByName(DotName dn) {
        return this.overrideObject(this.original.getModuleByName(dn), this.override.getModuleByName(dn));
    }

    public Collection<ClassInfo> getKnownUsers(DotName dn) {
        return this.overrideCollection(this.original.getKnownUsers(dn), this.override.getKnownUsers(dn), this.classInfoComparator);
    }

    public Collection<ClassInfo> getClassesInPackage(DotName pn) {
        return this.overrideCollection(this.original.getClassesInPackage(pn), this.override.getClassesInPackage(pn), this.classInfoComparator);
    }

    public Set<DotName> getSubpackages(DotName pn) {
        return new HashSet<DotName>(this.overrideCollection(this.original.getSubpackages(pn), this.override.getSubpackages(pn), Comparator.naturalOrder()));
    }

    private <T> Collection<T> overrideCollection(Collection<T> originalCollection, Collection<T> overrideCollection, Comparator<T> comparator) {
        if (originalCollection == null && overrideCollection == null) {
            return null;
        }
        if (originalCollection == null) {
            return overrideCollection;
        }
        if (overrideCollection == null) {
            return originalCollection;
        }
        if (originalCollection.isEmpty() && overrideCollection.isEmpty()) {
            return originalCollection;
        }
        if (originalCollection.isEmpty()) {
            return overrideCollection;
        }
        if (overrideCollection.isEmpty()) {
            return originalCollection;
        }
        TreeSet<T> newCollection = new TreeSet<T>(comparator);
        newCollection.addAll(overrideCollection);
        newCollection.addAll(originalCollection);
        return newCollection;
    }

    private <T> T overrideObject(T originalObject, T overrideObject) {
        if (overrideObject != null) {
            return overrideObject;
        }
        return originalObject;
    }
}

