/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.faulttolerance.deployment;

import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.AnnotationProxyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.smallrye.faulttolerance.deployment.ConfigUtilJandex;
import io.quarkus.smallrye.faulttolerance.deployment.DotNames;
import io.quarkus.smallrye.faulttolerance.deployment.FaultToleranceMethodSearch;
import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.faulttolerance.api.ApplyFaultTolerance;
import io.smallrye.faulttolerance.api.ApplyGuard;
import io.smallrye.faulttolerance.api.AsynchronousNonBlocking;
import io.smallrye.faulttolerance.api.BeforeRetry;
import io.smallrye.faulttolerance.api.CircuitBreakerName;
import io.smallrye.faulttolerance.api.CustomBackoff;
import io.smallrye.faulttolerance.api.ExponentialBackoff;
import io.smallrye.faulttolerance.api.FibonacciBackoff;
import io.smallrye.faulttolerance.api.RateLimit;
import io.smallrye.faulttolerance.api.RetryWhen;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

final class FaultToleranceScanner {
    private final IndexView index;
    private final AnnotationStore annotationStore;
    private final AnnotationProxyBuildItem proxy;
    private final ClassOutput output;
    private final RecorderContext recorderContext;
    private final BuildProducer<ReflectiveMethodBuildItem> reflectiveMethod;
    private final FaultToleranceMethodSearch methodSearch;

    FaultToleranceScanner(IndexView index, AnnotationStore annotationStore, AnnotationProxyBuildItem proxy, ClassOutput output, RecorderContext recorderContext, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethod) {
        this.index = index;
        this.annotationStore = annotationStore;
        this.proxy = proxy;
        this.output = output;
        this.recorderContext = recorderContext;
        this.reflectiveMethod = reflectiveMethod;
        this.methodSearch = new FaultToleranceMethodSearch(index);
    }

    boolean hasFTAnnotations(ClassInfo clazz) {
        if (this.annotationStore.hasAnyAnnotation((AnnotationTarget)clazz, DotNames.FT_ANNOTATIONS)) {
            return true;
        }
        for (MethodInfo method : clazz.methods()) {
            if (!this.annotationStore.hasAnyAnnotation((AnnotationTarget)method, DotNames.FT_ANNOTATIONS)) continue;
            return true;
        }
        DotName parentClassName = clazz.superName();
        if (parentClassName == null || parentClassName.equals((Object)DotNames.OBJECT)) {
            return false;
        }
        ClassInfo parentClass = this.index.getClassByName(parentClassName);
        if (parentClass == null) {
            return false;
        }
        return this.hasFTAnnotations(parentClass);
    }

    void forEachMethod(ClassInfo clazz, Consumer<MethodInfo> action) {
        for (MethodInfo method : clazz.methods()) {
            if (method.name().startsWith("<") || method.isSynthetic() || Modifier.isPrivate(method.flags()) || this.annotationStore.hasAnnotation((AnnotationTarget)method, io.quarkus.arc.processor.DotNames.NO_CLASS_INTERCEPTORS) && !this.annotationStore.hasAnyAnnotation((AnnotationTarget)method, DotNames.FT_ANNOTATIONS)) continue;
            action.accept(method);
        }
        DotName parentClassName = clazz.superName();
        if (parentClassName == null || parentClassName.equals((Object)DotNames.OBJECT)) {
            return;
        }
        ClassInfo parentClass = this.index.getClassByName(parentClassName);
        if (parentClass == null) {
            return;
        }
        this.forEachMethod(parentClass, action);
    }

    FaultToleranceMethod createFaultToleranceMethod(ClassInfo beanClass, MethodInfo method) {
        HashSet<Class<? extends Annotation>> annotationsPresentDirectly = new HashSet<Class<? extends Annotation>>();
        FaultToleranceMethod result = new FaultToleranceMethod();
        result.beanClass = this.getClassProxy(beanClass);
        result.method = this.createMethodDescriptor(method);
        result.applyFaultTolerance = this.getAnnotation(ApplyFaultTolerance.class, DotNames.APPLY_FAULT_TOLERANCE, method, beanClass, annotationsPresentDirectly);
        result.applyGuard = this.getAnnotation(ApplyGuard.class, DotNames.APPLY_GUARD, method, beanClass, annotationsPresentDirectly);
        result.asynchronous = this.getAnnotation(Asynchronous.class, DotNames.ASYNCHRONOUS, method, beanClass, annotationsPresentDirectly);
        result.asynchronousNonBlocking = this.getAnnotation(AsynchronousNonBlocking.class, DotNames.ASYNCHRONOUS_NON_BLOCKING, method, beanClass, annotationsPresentDirectly);
        result.blocking = this.getAnnotation(Blocking.class, DotNames.BLOCKING, method, beanClass, annotationsPresentDirectly);
        result.nonBlocking = this.getAnnotation(NonBlocking.class, DotNames.NON_BLOCKING, method, beanClass, annotationsPresentDirectly);
        result.bulkhead = this.getAnnotation(Bulkhead.class, DotNames.BULKHEAD, method, beanClass, annotationsPresentDirectly);
        result.circuitBreaker = this.getAnnotation(CircuitBreaker.class, DotNames.CIRCUIT_BREAKER, method, beanClass, annotationsPresentDirectly);
        result.circuitBreakerName = this.getAnnotation(CircuitBreakerName.class, DotNames.CIRCUIT_BREAKER_NAME, method, beanClass, annotationsPresentDirectly);
        result.fallback = this.getAnnotation(Fallback.class, DotNames.FALLBACK, method, beanClass, annotationsPresentDirectly);
        result.rateLimit = this.getAnnotation(RateLimit.class, DotNames.RATE_LIMIT, method, beanClass, annotationsPresentDirectly);
        result.retry = this.getAnnotation(Retry.class, DotNames.RETRY, method, beanClass, annotationsPresentDirectly);
        result.timeout = this.getAnnotation(Timeout.class, DotNames.TIMEOUT, method, beanClass, annotationsPresentDirectly);
        result.customBackoff = this.getAnnotation(CustomBackoff.class, DotNames.CUSTOM_BACKOFF, method, beanClass, annotationsPresentDirectly);
        result.exponentialBackoff = this.getAnnotation(ExponentialBackoff.class, DotNames.EXPONENTIAL_BACKOFF, method, beanClass, annotationsPresentDirectly);
        result.fibonacciBackoff = this.getAnnotation(FibonacciBackoff.class, DotNames.FIBONACCI_BACKOFF, method, beanClass, annotationsPresentDirectly);
        result.retryWhen = this.getAnnotation(RetryWhen.class, DotNames.RETRY_WHEN, method, beanClass, annotationsPresentDirectly);
        result.beforeRetry = this.getAnnotation(BeforeRetry.class, DotNames.BEFORE_RETRY, method, beanClass, annotationsPresentDirectly);
        result.annotationsPresentDirectly = annotationsPresentDirectly;
        this.searchForMethods(result, beanClass, method, annotationsPresentDirectly);
        return result;
    }

    private MethodDescriptor createMethodDescriptor(MethodInfo method) {
        MethodDescriptor result = new MethodDescriptor();
        result.declaringClass = this.getClassProxy(method.declaringClass());
        result.name = method.name();
        Class[] parameterTypes = new Class[method.parametersCount()];
        for (int i = 0; i < method.parametersCount(); ++i) {
            parameterTypes[i] = this.getClassProxy(method.parameterType(i));
        }
        result.parameterTypes = parameterTypes;
        result.returnType = this.getClassProxy(method.returnType());
        return result;
    }

    private <A extends Annotation> A getAnnotation(Class<A> annotationType, DotName annotationName, MethodInfo method, ClassInfo beanClass, Set<Class<? extends Annotation>> directlyPresent) {
        if (this.annotationStore.hasAnnotation((AnnotationTarget)method, annotationName)) {
            directlyPresent.add(annotationType);
            AnnotationInstance annotation = this.annotationStore.getAnnotation((AnnotationTarget)method, annotationName);
            return this.createAnnotation(annotationType, annotation);
        }
        return this.getAnnotationFromClass(annotationType, annotationName, beanClass);
    }

    private void searchForMethods(FaultToleranceMethod result, ClassInfo beanClass, MethodInfo method, Set<Class<? extends Annotation>> annotationsPresentDirectly) {
        if (result.fallback != null) {
            String fallbackMethod = this.getMethodNameFromConfig(method, annotationsPresentDirectly, Fallback.class, "fallbackMethod");
            if (fallbackMethod == null) {
                fallbackMethod = result.fallback.fallbackMethod();
            }
            if (fallbackMethod != null && !fallbackMethod.isEmpty()) {
                ClassInfo declaringClass = method.declaringClass();
                Type[] parameterTypes = method.parameterTypes().toArray(new Type[0]);
                Type returnType = method.returnType();
                MethodInfo foundMethod = this.methodSearch.findFallbackMethod(beanClass, declaringClass, fallbackMethod, parameterTypes, returnType);
                Set<MethodInfo> foundMethods = this.methodSearch.findFallbackMethodsWithExceptionParameter(beanClass, declaringClass, fallbackMethod, parameterTypes, returnType);
                result.fallbackMethod = this.createMethodDescriptorIfNotNull(foundMethod);
                result.fallbackMethodsWithExceptionParameter = this.createMethodDescriptorsIfNotEmpty(foundMethods);
                if (foundMethod != null) {
                    this.reflectiveMethod.produce((BuildItem)new ReflectiveMethodBuildItem("@Fallback method", foundMethod));
                }
                for (MethodInfo m : foundMethods) {
                    this.reflectiveMethod.produce((BuildItem)new ReflectiveMethodBuildItem("@Fallback method", m));
                }
            }
        }
        if (result.beforeRetry != null) {
            String beforeRetryMethod = this.getMethodNameFromConfig(method, annotationsPresentDirectly, BeforeRetry.class, "methodName");
            if (beforeRetryMethod == null) {
                beforeRetryMethod = result.beforeRetry.methodName();
            }
            if (beforeRetryMethod != null && !beforeRetryMethod.isEmpty()) {
                MethodInfo foundMethod = this.methodSearch.findBeforeRetryMethod(beanClass, method.declaringClass(), beforeRetryMethod);
                result.beforeRetryMethod = this.createMethodDescriptorIfNotNull(foundMethod);
                if (foundMethod != null) {
                    this.reflectiveMethod.produce((BuildItem)new ReflectiveMethodBuildItem("@BeforeRetry method", foundMethod));
                }
            }
        }
    }

    private String getMethodNameFromConfig(MethodInfo method, Set<Class<? extends Annotation>> annotationsPresentDirectly, Class<? extends Annotation> ftAnnotation, String memberName) {
        String result;
        String oldKey;
        String newKey;
        Config config = ConfigProvider.getConfig();
        if (annotationsPresentDirectly.contains(ftAnnotation)) {
            newKey = ConfigUtilJandex.newKey(ftAnnotation, memberName, method);
            oldKey = ConfigUtilJandex.oldKey(ftAnnotation, memberName, method);
            result = config.getOptionalValue(newKey, String.class).or(() -> config.getOptionalValue(oldKey, String.class)).orElse(null);
        } else {
            newKey = ConfigUtilJandex.newKey(ftAnnotation, memberName, method.declaringClass());
            oldKey = ConfigUtilJandex.oldKey(ftAnnotation, memberName, method.declaringClass());
            result = config.getOptionalValue(newKey, String.class).or(() -> config.getOptionalValue(oldKey, String.class)).orElse(null);
        }
        if (result == null) {
            newKey = ConfigUtilJandex.newKey(ftAnnotation, memberName);
            oldKey = ConfigUtilJandex.oldKey(ftAnnotation, memberName);
            result = config.getOptionalValue(newKey, String.class).or(() -> config.getOptionalValue(oldKey, String.class)).orElse(null);
        }
        return result;
    }

    private MethodDescriptor createMethodDescriptorIfNotNull(MethodInfo method) {
        return method == null ? null : this.createMethodDescriptor(method);
    }

    private List<MethodDescriptor> createMethodDescriptorsIfNotEmpty(Collection<MethodInfo> methods) {
        if (methods.isEmpty()) {
            return null;
        }
        ArrayList<MethodDescriptor> result = new ArrayList<MethodDescriptor>(methods.size());
        for (MethodInfo method : methods) {
            result.add(this.createMethodDescriptor(method));
        }
        return result;
    }

    private <A extends Annotation> A getAnnotationFromClass(Class<A> annotationType, DotName annotationName, ClassInfo clazz) {
        if (this.annotationStore.hasAnnotation((AnnotationTarget)clazz, annotationName)) {
            AnnotationInstance annotation = this.annotationStore.getAnnotation((AnnotationTarget)clazz, annotationName);
            return this.createAnnotation(annotationType, annotation);
        }
        DotName parentClassName = clazz.superName();
        if (parentClassName == null || parentClassName.equals((Object)DotNames.OBJECT)) {
            return null;
        }
        ClassInfo parentClass = this.index.getClassByName(parentClassName);
        if (parentClass == null) {
            return null;
        }
        return this.getAnnotationFromClass(annotationType, annotationName, parentClass);
    }

    private <A extends Annotation> A createAnnotation(Class<A> annotationType, AnnotationInstance instance) {
        return (A)((Annotation)this.proxy.builder(instance, annotationType).build(this.output));
    }

    private Class<?> getClassProxy(ClassInfo clazz) {
        return this.recorderContext.classProxy(clazz.name().toString());
    }

    private Class<?> getClassProxy(Type type) {
        return this.recorderContext.classProxy(type.name().toString());
    }
}

