/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.context.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.smallrye.context.runtime.SmallRyeContextPropagationProvider;
import io.quarkus.smallrye.context.runtime.SmallRyeContextPropagationRecorder;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.microprofile.context.spi.ContextManagerExtension;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.jboss.logging.Logger;
import org.jboss.resteasy.context.ResteasyContextProvider;

class SmallRyeContextPropagationProcessor {
    private static final Logger log = Logger.getLogger((String)SmallRyeContextPropagationProcessor.class.getName());

    SmallRyeContextPropagationProcessor() {
    }

    @BuildStep
    void registerBean(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(SmallRyeContextPropagationProvider.class));
    }

    @BuildStep(loadsApplicationClasses=true)
    @Record(value=ExecutionTime.STATIC_INIT)
    void buildStatic(SmallRyeContextPropagationRecorder recorder) throws ClassNotFoundException, IOException {
        ArrayList<ThreadContextProvider> discoveredProviders = new ArrayList<ThreadContextProvider>();
        ArrayList<ContextManagerExtension> discoveredExtensions = new ArrayList<ContextManagerExtension>();
        for (Class provider : ServiceUtil.classesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)("META-INF/services/" + ThreadContextProvider.class.getName()))) {
            if (provider.equals(ResteasyContextProvider.class)) {
                try {
                    Class.forName("org.jboss.resteasy.core.ResteasyContext", false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
            }
            try {
                discoveredProviders.add((ThreadContextProvider)provider.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Failed to instantiate declared ThreadContextProvider class: " + provider.getName(), e);
            }
        }
        for (Class extension : ServiceUtil.classesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)("META-INF/services/" + ContextManagerExtension.class.getName()))) {
            try {
                discoveredExtensions.add((ContextManagerExtension)extension.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Failed to instantiate declared ThreadContextProvider class: " + extension.getName(), e);
            }
        }
        recorder.configureStaticInit(discoveredProviders, discoveredExtensions);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void build(SmallRyeContextPropagationRecorder recorder, BeanContainerBuildItem beanContainer, ExecutorBuildItem executorBuildItem, BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem("smallrye-context-propagation"));
        recorder.configureRuntime(beanContainer.getValue(), executorBuildItem.getExecutorProxy());
    }
}

