/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.jpa.reactive.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.panache.common.deployment.PanacheEntityClassesBuildItem;
import io.quarkus.security.identity.request.TrustedAuthenticationRequest;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import io.quarkus.security.jpa.PasswordProvider;
import io.quarkus.security.jpa.common.deployment.JpaSecurityDefinition;
import io.quarkus.security.jpa.common.deployment.JpaSecurityDefinitionBuildItem;
import io.quarkus.security.jpa.common.deployment.JpaSecurityIdentityUtil;
import io.quarkus.security.jpa.common.deployment.PanacheEntityPredicateBuildItem;
import io.quarkus.security.jpa.reactive.runtime.JpaReactiveIdentityProvider;
import io.quarkus.security.jpa.reactive.runtime.JpaReactiveTrustedIdentityProvider;
import io.smallrye.mutiny.Uni;
import jakarta.inject.Singleton;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.hibernate.annotations.NaturalId;
import org.hibernate.reactive.common.Identifier;
import org.hibernate.reactive.mutiny.Mutiny;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

class QuarkusSecurityJpaReactiveProcessor {
    private static final DotName NATURAL_ID = DotName.createSimple((String)NaturalId.class.getName());

    QuarkusSecurityJpaReactiveProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.SECURITY_JPA_REACTIVE);
    }

    @BuildStep
    void configureJpaAuthConfig(ApplicationIndexBuildItem index, BuildProducer<GeneratedBeanBuildItem> beanProducer, Optional<JpaSecurityDefinitionBuildItem> jpaSecurityDefinitionBuildItem, PanacheEntityPredicateBuildItem panacheEntityPredicate) {
        if (jpaSecurityDefinitionBuildItem.isPresent()) {
            JpaSecurityDefinition jpaSecurityDefinition = jpaSecurityDefinitionBuildItem.get().get();
            QuarkusSecurityJpaReactiveProcessor.generateIdentityProvider(index.getIndex(), jpaSecurityDefinition, jpaSecurityDefinition.passwordType(), jpaSecurityDefinition.customPasswordProvider(), beanProducer, panacheEntityPredicate);
            QuarkusSecurityJpaReactiveProcessor.generateTrustedIdentityProvider(index.getIndex(), jpaSecurityDefinition, beanProducer, panacheEntityPredicate);
        }
    }

    @BuildStep
    PanacheEntityPredicateBuildItem panacheEntityPredicate(List<PanacheEntityClassesBuildItem> panacheEntityClasses) {
        return new PanacheEntityPredicateBuildItem(QuarkusSecurityJpaReactiveProcessor.collectPanacheEntities(panacheEntityClasses));
    }

    private static Set<String> collectPanacheEntities(List<PanacheEntityClassesBuildItem> panacheEntityClassesBuildItems) {
        HashSet<String> modelClasses = new HashSet<String>();
        for (PanacheEntityClassesBuildItem panacheEntityClasses : panacheEntityClassesBuildItems) {
            modelClasses.addAll(panacheEntityClasses.getEntityClasses());
        }
        return modelClasses;
    }

    private static void generateIdentityProvider(Index index, JpaSecurityDefinition jpaSecurityDefinition, AnnotationValue passwordTypeValue, AnnotationValue passwordProviderValue, BuildProducer<GeneratedBeanBuildItem> beanProducer, PanacheEntityPredicateBuildItem panacheEntityPredicate) {
        GeneratedBeanGizmoAdaptor gizmoAdaptor = new GeneratedBeanGizmoAdaptor(beanProducer);
        String name = String.valueOf(jpaSecurityDefinition.annotatedClass.name()) + "__JpaReactiveIdentityProviderImpl";
        try (ClassCreator classCreator = ClassCreator.builder().className(name).superClass(JpaReactiveIdentityProvider.class).classOutput((ClassOutput)gizmoAdaptor).build();){
            classCreator.addAnnotation(Singleton.class);
            FieldDescriptor passwordProviderField = ((FieldCreator)classCreator.getFieldCreator("passwordProvider", PasswordProvider.class).setModifiers(0)).getFieldDescriptor();
            MethodDescriptor methodToImpl = MethodDescriptor.ofMethod(JpaReactiveIdentityProvider.class, (String)"authenticate", Uni.class, (Class[])new Class[]{Mutiny.Session.class, UsernamePasswordAuthenticationRequest.class});
            try (MethodCreator methodCreator = classCreator.getMethodCreator(methodToImpl);){
                methodCreator.setModifiers(1);
                ResultHandle username = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(UsernamePasswordAuthenticationRequest.class, (String)"getUsername", String.class, (Class[])new Class[0]), methodCreator.getMethodParam(1), new ResultHandle[0]);
                ResultHandle userUni = QuarkusSecurityJpaReactiveProcessor.lookupUserById(jpaSecurityDefinition, methodCreator, username);
                ResultHandle identityUni = QuarkusSecurityJpaReactiveProcessor.uniMap(methodCreator, userUni, (body, user) -> JpaSecurityIdentityUtil.buildIdentity((Index)index, (JpaSecurityDefinition)jpaSecurityDefinition, (AnnotationValue)passwordTypeValue, (AnnotationValue)passwordProviderValue, (PanacheEntityPredicateBuildItem)panacheEntityPredicate, (FieldDescriptor)passwordProviderField, (MethodCreator)methodCreator, (ResultHandle)user, (BytecodeCreator)body));
                methodCreator.returnValue(identityUni);
            }
        }
    }

    private static void generateTrustedIdentityProvider(Index index, JpaSecurityDefinition jpaSecurityDefinition, BuildProducer<GeneratedBeanBuildItem> beanProducer, PanacheEntityPredicateBuildItem panacheEntityPredicate) {
        GeneratedBeanGizmoAdaptor gizmoAdaptor = new GeneratedBeanGizmoAdaptor(beanProducer);
        String name = String.valueOf(jpaSecurityDefinition.annotatedClass.name()) + "__JpaReactiveTrustedIdentityProviderImpl";
        try (ClassCreator classCreator = ClassCreator.builder().className(name).superClass(JpaReactiveTrustedIdentityProvider.class).classOutput((ClassOutput)gizmoAdaptor).build();){
            classCreator.addAnnotation(Singleton.class);
            MethodDescriptor methodToImpl = MethodDescriptor.ofMethod(JpaReactiveTrustedIdentityProvider.class, (String)"authenticate", Uni.class, (Class[])new Class[]{Mutiny.Session.class, TrustedAuthenticationRequest.class});
            try (MethodCreator methodCreator = classCreator.getMethodCreator(methodToImpl);){
                methodCreator.setModifiers(1);
                ResultHandle username = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(TrustedAuthenticationRequest.class, (String)"getPrincipal", String.class, (Class[])new Class[0]), methodCreator.getMethodParam(1), new ResultHandle[0]);
                ResultHandle userUni = QuarkusSecurityJpaReactiveProcessor.lookupUserById(jpaSecurityDefinition, methodCreator, username);
                ResultHandle identityUni = QuarkusSecurityJpaReactiveProcessor.uniMap(methodCreator, userUni, (body, user) -> JpaSecurityIdentityUtil.buildTrustedIdentity((Index)index, (JpaSecurityDefinition)jpaSecurityDefinition, (PanacheEntityPredicateBuildItem)panacheEntityPredicate, (MethodCreator)methodCreator, (ResultHandle)user, (BytecodeCreator)body));
                methodCreator.returnValue(identityUni);
            }
        }
    }

    private static ResultHandle lookupUserById(JpaSecurityDefinition jpaSecurityDefinition, MethodCreator methodCreator, ResultHandle username) {
        ResultHandle user;
        AnnotationInstance naturalIdAnnotation = jpaSecurityDefinition.username.annotation(NATURAL_ID);
        String userEntityClassName = jpaSecurityDefinition.annotatedClass.name().toString();
        ResultHandle userEntityClass = methodCreator.loadClass(userEntityClassName);
        ResultHandle session = methodCreator.getMethodParam(0);
        boolean fetchJoinRoles = QuarkusSecurityJpaReactiveProcessor.shouldFetchJoinRoles(jpaSecurityDefinition);
        if (naturalIdAnnotation != null) {
            ResultHandle id = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Identifier.class, (String)"id", Identifier.Id.class, (Class[])new Class[]{String.class, Object.class}), new ResultHandle[]{methodCreator.load(jpaSecurityDefinition.username.name()), username});
            user = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Mutiny.Session.class, (String)"find", Uni.class, (Class[])new Class[]{Class.class, Identifier.class}), session, new ResultHandle[]{userEntityClass, id});
            if (fetchJoinRoles) {
                String userClassName = jpaSecurityDefinition.annotatedClass.name().toString();
                user = QuarkusSecurityJpaReactiveProcessor.uniFlatMap((BytecodeCreator)methodCreator, user, (body, user1) -> body.invokeInterfaceMethod(MethodDescriptor.ofMethod(Mutiny.Session.class, (String)"fetch", Uni.class, (Object[])new Object[]{userClassName}), session, new ResultHandle[]{user1}));
            }
        } else {
            String hql = fetchJoinRoles ? "FROM " + jpaSecurityDefinition.annotatedClass.simpleName() + " en LEFT JOIN FETCH en." + jpaSecurityDefinition.roles.name() + " WHERE en." + jpaSecurityDefinition.username.name() + " = :name" : "FROM " + jpaSecurityDefinition.annotatedClass.simpleName() + " WHERE " + jpaSecurityDefinition.username.name() + " = :name";
            ResultHandle query1 = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Mutiny.Session.class, (String)"createQuery", Mutiny.SelectionQuery.class, (Class[])new Class[]{String.class, Class.class}), session, new ResultHandle[]{methodCreator.load(hql), userEntityClass});
            ResultHandle query2 = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Mutiny.SelectionQuery.class, (String)"setParameter", Mutiny.SelectionQuery.class, (Class[])new Class[]{String.class, Object.class}), query1, new ResultHandle[]{methodCreator.load("name"), username});
            user = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Mutiny.SelectionQuery.class, (String)"getSingleResultOrNull", Uni.class, (Class[])new Class[0]), query2, new ResultHandle[0]);
        }
        return user;
    }

    private static boolean shouldFetchJoinRoles(JpaSecurityDefinition jpaSecurityDefinition) {
        return jpaSecurityDefinition.haveRolesAnnotation(new DotName[]{DotName.createSimple(CollectionTable.class), DotName.createSimple(ManyToMany.class), DotName.createSimple(OneToMany.class), DotName.createSimple(ManyToOne.class)});
    }

    private static ResultHandle uniMap(MethodCreator creator, ResultHandle uniInstance, BiConsumer<BytecodeCreator, ResultHandle> fun) {
        return QuarkusSecurityJpaReactiveProcessor.uniLambda((BytecodeCreator)creator, uniInstance, fun, "map");
    }

    private static ResultHandle uniFlatMap(BytecodeCreator creator, ResultHandle uniInstance, BiConsumer<BytecodeCreator, ResultHandle> fun) {
        return QuarkusSecurityJpaReactiveProcessor.uniLambda(creator, uniInstance, fun, "flatMap");
    }

    private static ResultHandle uniLambda(BytecodeCreator creator, ResultHandle uniInstance, BiConsumer<BytecodeCreator, ResultHandle> function, String name) {
        FunctionCreator lambda = creator.createFunction(Function.class);
        BytecodeCreator body = lambda.getBytecode();
        ResultHandle user = body.getMethodParam(0);
        function.accept(body, user);
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Uni.class, (String)name, Uni.class, (Class[])new Class[]{Function.class}), uniInstance, new ResultHandle[]{lambda.getInstance()});
    }
}

