/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.apicurio.registry.devservice;

import io.quarkus.apicurio.registry.devservice.ApicurioRegistryBuildTimeConfig;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={DevServicesConfig.Enabled.class})
public class DevServicesApicurioRegistryProcessor {
    private static final Logger log = Logger.getLogger(DevServicesApicurioRegistryProcessor.class);
    private static final int APICURIO_REGISTRY_PORT = 8080;
    private static final String APICURIO_REGISTRY_URL_CONFIG = "mp.messaging.connector.smallrye-kafka.apicurio.registry.url";
    private static final String CONFLUENT_SCHEMA_REGISTRY_URL_CONFIG = "mp.messaging.connector.smallrye-kafka.schema.registry.url";
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-apicurio-registry";
    private static final ContainerLocator apicurioRegistryContainerLocator = new ContainerLocator("quarkus-dev-service-apicurio-registry", 8080);
    static volatile DevServicesResultBuildItem.RunningDevService devService;
    static volatile ApicurioRegistryDevServiceCfg cfg;
    static volatile boolean first;

    @BuildStep
    public DevServicesResultBuildItem startApicurioRegistryDevService(LaunchModeBuildItem launchMode, DockerStatusBuildItem dockerStatusBuildItem, ApicurioRegistryBuildTimeConfig apicurioRegistryConfiguration, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, DevServicesConfig devServicesConfig) {
        ApicurioRegistryDevServiceCfg configuration = this.getConfiguration(apicurioRegistryConfiguration.devservices());
        if (devService != null) {
            boolean restartRequired;
            boolean bl = restartRequired = !configuration.equals(cfg);
            if (!restartRequired) {
                return devService.toBuildItem();
            }
            this.shutdownApicurioRegistry();
            cfg = null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Apicurio Registry Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            boolean useSharedNetwork = DevServicesSharedNetworkBuildItem.isSharedNetworkRequired((DevServicesConfig)devServicesConfig, devServicesSharedNetworkBuildItem);
            devService = this.startApicurioRegistry(dockerStatusBuildItem, configuration, launchMode, useSharedNetwork, devServicesConfig.timeout());
            compressor.close();
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (devService == null) {
            return null;
        }
        cfg = configuration;
        if (devService.isOwner()) {
            log.infof("Dev Services for Apicurio Registry started. The registry is available at %s", devService.getConfig().get(APICURIO_REGISTRY_URL_CONFIG));
        }
        if (first) {
            first = false;
            Runnable closeTask = new Runnable(){

                @Override
                public void run() {
                    if (devService != null) {
                        DevServicesApicurioRegistryProcessor.this.shutdownApicurioRegistry();
                    }
                    first = true;
                    devService = null;
                    cfg = null;
                }
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        return devService.toBuildItem();
    }

    private Map<String, String> getRegistryUrlConfigs(String baseUrl) {
        return Map.of(APICURIO_REGISTRY_URL_CONFIG, baseUrl + "/apis/registry/v2", CONFLUENT_SCHEMA_REGISTRY_URL_CONFIG, baseUrl + "/apis/ccompat/v6");
    }

    private void shutdownApicurioRegistry() {
        if (devService != null) {
            try {
                devService.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop Apicurio Registry", e);
            }
            finally {
                devService = null;
            }
        }
    }

    private DevServicesResultBuildItem.RunningDevService startApicurioRegistry(DockerStatusBuildItem dockerStatusBuildItem, ApicurioRegistryDevServiceCfg config, LaunchModeBuildItem launchMode, boolean useSharedNetwork, Optional<Duration> timeout) {
        if (!config.devServicesEnabled) {
            log.debug((Object)"Not starting dev services for Apicurio Registry, as it has been disabled in the config.");
            return null;
        }
        if (ConfigUtils.isPropertyNonEmpty((String)APICURIO_REGISTRY_URL_CONFIG)) {
            log.debug((Object)"Not starting dev services for Apicurio Registry, mp.messaging.connector.smallrye-kafka.apicurio.registry.url is configured.");
            return null;
        }
        if (ConfigUtils.isPropertyNonEmpty((String)CONFLUENT_SCHEMA_REGISTRY_URL_CONFIG)) {
            log.debug((Object)"Not starting dev services for Apicurio Registry, mp.messaging.connector.smallrye-kafka.schema.registry.url is configured.");
            return null;
        }
        if (!this.hasKafkaChannelWithoutRegistry()) {
            log.debug((Object)"Not starting dev services for Apicurio Registry, all the channels have a registry URL configured.");
            return null;
        }
        if (!dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            log.warn((Object)"Docker isn't working, please run Apicurio Registry yourself.");
            return null;
        }
        return apicurioRegistryContainerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode()).map(address -> new DevServicesResultBuildItem.RunningDevService(Feature.APICURIO_REGISTRY_AVRO.getName(), address.getId(), null, this.getRegistryUrlConfigs("http://" + address.getUrl()))).orElseGet(() -> {
            ApicurioRegistryContainer container = new ApicurioRegistryContainer(DockerImageName.parse((String)config.imageName).asCompatibleSubstituteFor("apicurio/apicurio-registry-mem"), config.fixedExposedPort, launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT ? config.serviceName : null, useSharedNetwork);
            timeout.ifPresent(arg_0 -> ((ApicurioRegistryContainer)container).withStartupTimeout(arg_0));
            container.withEnv(config.containerEnv);
            container.start();
            return new DevServicesResultBuildItem.RunningDevService(Feature.APICURIO_REGISTRY_AVRO.getName(), container.getContainerId(), () -> ((ApicurioRegistryContainer)container).close(), this.getRegistryUrlConfigs(container.getUrl()));
        });
    }

    private boolean hasKafkaChannelWithoutRegistry() {
        Config config = ConfigProvider.getConfig();
        for (String name : config.getPropertyNames()) {
            boolean isIncoming = name.startsWith("mp.messaging.incoming.");
            boolean isOutgoing = name.startsWith("mp.messaging.outgoing.");
            boolean isConnector = name.endsWith(".connector");
            boolean isKafka = isConnector && "smallrye-kafka".equals(config.getOptionalValue(name, String.class).orElse("ignored"));
            boolean isConfigured = false;
            if ((isIncoming || isOutgoing) && isKafka) {
                boolean bl = isConfigured = ConfigUtils.isPropertyNonEmpty((String)name.replace(".connector", ".apicurio.registry.url")) || ConfigUtils.isPropertyNonEmpty((String)name.replace(".connector", ".schema.registry.url"));
            }
            if (isConfigured) continue;
            return true;
        }
        return false;
    }

    private ApicurioRegistryDevServiceCfg getConfiguration(ApicurioRegistryBuildTimeConfig.ApicurioRegistryDevServicesBuildTimeConfig cfg) {
        return new ApicurioRegistryDevServiceCfg(cfg);
    }

    static {
        first = true;
    }

    private static final class ApicurioRegistryDevServiceCfg {
        private final boolean devServicesEnabled;
        private final String imageName;
        private final Integer fixedExposedPort;
        private final boolean shared;
        private final String serviceName;
        private final Map<String, String> containerEnv;

        public ApicurioRegistryDevServiceCfg(ApicurioRegistryBuildTimeConfig.ApicurioRegistryDevServicesBuildTimeConfig config) {
            this.devServicesEnabled = config.enabled().orElse(true);
            this.imageName = config.imageName();
            this.fixedExposedPort = config.port().orElse(0);
            this.shared = config.shared();
            this.serviceName = config.serviceName();
            this.containerEnv = config.containerEnv();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApicurioRegistryDevServiceCfg that = (ApicurioRegistryDevServiceCfg)o;
            return this.devServicesEnabled == that.devServicesEnabled && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.fixedExposedPort, that.fixedExposedPort) && this.shared == that.shared && Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.containerEnv, that.containerEnv);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.imageName, this.fixedExposedPort, this.shared, this.serviceName, this.containerEnv);
        }
    }

    private static final class ApicurioRegistryContainer
    extends GenericContainer<ApicurioRegistryContainer> {
        private final int fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;

        private ApicurioRegistryContainer(DockerImageName dockerImageName, int fixedExposedPort, String serviceName, boolean useSharedNetwork) {
            super(dockerImageName);
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
            if (serviceName != null) {
                this.withLabel(DevServicesApicurioRegistryProcessor.DEV_SERVICE_LABEL, serviceName);
            }
            this.withEnv("QUARKUS_PROFILE", "prod");
            if (!dockerImageName.getRepository().endsWith("apicurio/apicurio-registry-mem")) {
                throw new IllegalArgumentException("Only apicurio/apicurio-registry-mem images are supported");
            }
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"kafka");
                return;
            }
            if (this.fixedExposedPort > 0) {
                this.addFixedExposedPort(this.fixedExposedPort, 8080);
            } else {
                this.addExposedPorts(new int[]{8080});
            }
        }

        public String getUrl() {
            return String.format("http://%s:%s", this.getHostToUse(), this.getPortToUse());
        }

        private String getHostToUse() {
            return this.useSharedNetwork ? this.hostName : this.getHost();
        }

        private int getPortToUse() {
            return this.useSharedNetwork ? 8080 : this.getMappedPort(8080);
        }
    }
}

