/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scala.deployment;

import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.paths.PathCollection;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import scala.collection.JavaConverters;
import scala.tools.nsc.Global;
import scala.tools.nsc.Settings;

public class ScalaCompilationProvider
implements CompilationProvider {
    public String getProviderKey() {
        return "scala";
    }

    public Set<String> handledExtensions() {
        return Collections.singleton(".scala");
    }

    public void compile(Set<File> files, CompilationProvider.Context context) {
        Settings settings = new Settings();
        context.getClasspath().forEach(file -> settings.classpath().append(file.getAbsolutePath()));
        context.getReloadableClasspath().forEach(file -> settings.classpath().append(file.getAbsolutePath()));
        settings.outputDirs().add(context.getSourceDirectory().getAbsolutePath(), context.getOutputDirectory().getAbsolutePath());
        try (Global g = new Global(settings);){
            Global.Run run = new Global.Run(g);
            Set fileSet = files.stream().map(File::getAbsolutePath).collect(Collectors.toSet());
            run.compile(JavaConverters.asScalaSet(fileSet).toList());
        }
    }

    public Path getSourcePath(Path classFilePath, PathCollection sourcePaths, String classesPath) {
        return classFilePath;
    }
}

