/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.token.propagation;

import io.quarkus.oidc.token.propagation.runtime.AbstractTokenRequestFilter;
import io.smallrye.jwt.build.Jwt;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.ws.rs.client.ClientRequestContext;
import java.io.IOException;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class JsonWebTokenRequestFilter
extends AbstractTokenRequestFilter {
    @Inject
    Instance<JsonWebToken> jwtAccessToken;
    @Inject
    @ConfigProperty(name="quarkus.resteasy-client-oidc-token-propagation.secure-json-web-token")
    boolean resignToken;

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (this.verifyTokenInstance(requestContext, this.jwtAccessToken)) {
            this.propagateToken(requestContext, this.getToken());
        }
    }

    private String getToken() {
        if (this.resignToken) {
            return Jwt.claims((JsonWebToken)((JsonWebToken)this.jwtAccessToken.get())).sign();
        }
        return ((JsonWebToken)this.jwtAccessToken.get()).getRawToken();
    }
}

