/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.servlet.runtime;

import io.netty.channel.EventLoop;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.concurrent.ScheduledFuture;
import io.quarkus.arc.Arc;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveSecurityContext;
import io.quarkus.resteasy.reactive.server.servlet.runtime.EnumerationIterable;
import io.quarkus.resteasy.reactive.server.servlet.runtime.ServletResteasyReactiveInputStream;
import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ResponseCommitListener;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Event;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;
import org.jboss.resteasy.reactive.server.spi.ServerHttpResponse;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;

public class ServletRequestContext
extends ResteasyReactiveRequestContext
implements ServerHttpRequest,
ServerHttpResponse,
ResponseCommitListener {
    private static final LazyValue<Event<SecurityIdentity>> SECURITY_IDENTITY_EVENT = new LazyValue(ServletRequestContext::createEvent);
    final RoutingContext context;
    final HttpServletRequest request;
    final HttpServletResponse response;
    AsyncContext asyncContext;
    ServletWriteListener writeListener;
    ServletReadListener readListener;
    byte[] asyncWriteData;
    boolean closed;
    Consumer<Throwable> asyncWriteHandler;
    protected Consumer<ResteasyReactiveRequestContext> preCommitTask;

    public ServletRequestContext(Deployment deployment, HttpServletRequest request, HttpServletResponse response, ThreadSetupAction requestContext, ServerRestHandler[] handlerChain, ServerRestHandler[] abortHandlerChain, RoutingContext context, HttpServerExchange exchange) {
        super(deployment, requestContext, handlerChain, abortHandlerChain);
        this.request = request;
        this.response = response;
        this.context = context;
        exchange.addResponseCommitListener((ResponseCommitListener)this);
    }

    protected boolean isRequestScopeManagementRequired() {
        return this.asyncContext != null;
    }

    protected void beginAsyncProcessing() {
        this.asyncContext = this.request.startAsync();
    }

    public synchronized void close() {
        if (this.asyncWriteData != null) {
            this.closed = true;
        } else {
            super.close();
            if (this.asyncContext != null) {
                this.asyncContext.complete();
            }
        }
    }

    public ServerHttpResponse addCloseHandler(Runnable onClose) {
        this.context.response().closeHandler(v -> onClose.run());
        return this;
    }

    public ServerHttpRequest serverRequest() {
        return this;
    }

    public ServerHttpResponse serverResponse() {
        return this;
    }

    protected void setQueryParamsFrom(String uri) {
        MultiMap map = this.context.queryParams();
        map.clear();
        Map decodedParams = new QueryStringDecoder(uri).parameters();
        for (Map.Entry entry : decodedParams.entrySet()) {
            map.add((String)entry.getKey(), (Iterable)entry.getValue());
        }
    }

    protected void handleRequestScopeActivation() {
        super.handleRequestScopeActivation();
        QuarkusHttpUser user = (QuarkusHttpUser)this.context.user();
        if (user != null) {
            ServletRequestContext.fireSecurityIdentity(user.getSecurityIdentity());
        }
    }

    static void fireSecurityIdentity(SecurityIdentity identity) {
        ((Event)SECURITY_IDENTITY_EVENT.get()).fire((Object)identity);
    }

    static void clear() {
        SECURITY_IDENTITY_EVENT.clear();
    }

    private static Event<SecurityIdentity> createEvent() {
        return Arc.container().beanManager().getEvent().select(SecurityIdentity.class, new Annotation[0]);
    }

    protected SecurityContext createSecurityContext() {
        return new ResteasyReactiveSecurityContext(this.context);
    }

    protected EventLoop getEventLoop() {
        return ((ConnectionBase)this.context.request().connection()).channel().eventLoop();
    }

    public Runnable registerTimer(long millis, Runnable task) {
        final ScheduledFuture handle = this.getEventLoop().schedule(task, millis, TimeUnit.MILLISECONDS);
        return new Runnable(){

            @Override
            public void run() {
                handle.cancel(false);
            }
        };
    }

    public boolean resumeExternalProcessing() {
        return false;
    }

    public String getRequestHeader(CharSequence name) {
        return this.request.getHeader(name.toString());
    }

    public Iterable<Map.Entry<String, String>> getAllRequestHeaders() {
        ArrayList<Map.Entry<String, String>> ret = new ArrayList<Map.Entry<String, String>>();
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            for (String v : new EnumerationIterable(this.request.getHeaders(name))) {
                ret.add(new MapEntry<String, String>(name, v));
            }
        }
        return ret;
    }

    public List<String> getAllRequestHeaders(String name) {
        Enumeration headers = this.request.getHeaders(name);
        if (headers == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>();
        while (headers.hasMoreElements()) {
            ret.add((String)headers.nextElement());
        }
        return ret;
    }

    public boolean containsRequestHeader(CharSequence accept) {
        return this.request.getHeader(accept.toString()) != null;
    }

    public String getRequestPath() {
        return this.request.getServletPath();
    }

    public String getRequestMethod() {
        return this.request.getMethod();
    }

    public String getRequestNormalisedPath() {
        return this.context.normalizedPath();
    }

    public String getRequestAbsoluteUri() {
        if (this.request.getQueryString() == null) {
            return this.request.getRequestURL().toString();
        }
        return this.request.getRequestURL().append("?").append(this.request.getQueryString()).toString();
    }

    public String getRequestScheme() {
        return this.request.getScheme();
    }

    public String getRequestHost() {
        return this.context.request().authority().toString();
    }

    public void closeConnection() {
        try {
            this.response.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.context.request().connection().close();
    }

    public String getQueryParam(String name) {
        if (!this.context.queryParams().contains(name)) {
            return null;
        }
        return this.request.getParameter(name);
    }

    public List<String> getAllQueryParams(String name) {
        return this.context.queryParam(name);
    }

    public String query() {
        return this.request.getQueryString();
    }

    public Collection<String> queryParamNames() {
        return this.context.queryParams().names();
    }

    public boolean isRequestEnded() {
        return this.context.request().isEnded();
    }

    public InputStream createInputStream(ByteBuffer existingData) {
        return new ServletResteasyReactiveInputStream(existingData, this.request);
    }

    public InputStream createInputStream() {
        try {
            return this.request.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ServerHttpResponse pauseRequestInput() {
        return this;
    }

    public ServerHttpResponse resumeRequestInput() {
        return this;
    }

    public ServerHttpResponse setReadListener(ServerHttpRequest.ReadCallback callback) {
        try {
            ServletInputStream in = this.request.getInputStream();
            if (!this.request.isAsyncStarted()) {
                this.request.startAsync();
            }
            in.setReadListener((ReadListener)new ServletReadListener(in, callback));
        }
        catch (IOException e) {
            this.resume(e);
        }
        return this;
    }

    public <T> T unwrap(Class<T> theType) {
        if (theType == RoutingContext.class) {
            return (T)this.context;
        }
        if (theType == HttpServerRequest.class) {
            return (T)this.context.request();
        }
        if (theType == HttpServerResponse.class) {
            return (T)this.context.response();
        }
        if (theType == HttpServletRequest.class) {
            return (T)this.request;
        }
        if (theType == HttpServletResponse.class) {
            return (T)this.response;
        }
        return null;
    }

    public boolean isOnIoThread() {
        return true;
    }

    public ServerHttpResponse setStatusCode(int code) {
        this.response.setStatus(code);
        return this;
    }

    public ServerHttpResponse end() {
        try {
            this.response.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public boolean headWritten() {
        return this.response.isCommitted();
    }

    public ServerHttpResponse end(byte[] data) {
        if (BlockingOperationControl.isBlockingAllowed()) {
            try {
                this.response.getOutputStream().write(data);
                this.response.getOutputStream().close();
            }
            catch (IOException e) {
                log.debug((Object)"IoException writing response", (Throwable)e);
            }
        } else {
            this.write(data, new Consumer<Throwable>(){

                @Override
                public void accept(Throwable throwable) {
                    try {
                        ServletRequestContext.this.response.getOutputStream().close();
                    }
                    catch (IOException e) {
                        log.debug((Object)"IoException writing response", (Throwable)e);
                    }
                }
            });
        }
        return this;
    }

    public ServerHttpResponse end(String data) {
        this.end(data.getBytes(StandardCharsets.UTF_8));
        return this;
    }

    public ServerHttpResponse addResponseHeader(CharSequence name, CharSequence value) {
        this.response.addHeader(name.toString(), value.toString());
        return this;
    }

    public ServerHttpResponse setResponseHeader(CharSequence name, CharSequence value) {
        this.response.setHeader(name.toString(), value != null ? value.toString() : null);
        return this;
    }

    public ServerHttpResponse setResponseHeader(CharSequence name, Iterable<CharSequence> values) {
        for (CharSequence v : values) {
            this.response.addHeader(name.toString(), v.toString());
        }
        return this;
    }

    public Iterable<Map.Entry<String, String>> getAllResponseHeaders() {
        ArrayList<Map.Entry<String, String>> ret = new ArrayList<Map.Entry<String, String>>();
        Collection headerNames = this.response.getHeaderNames();
        for (String name : headerNames) {
            for (String v : this.response.getHeaders(name)) {
                ret.add(new MapEntry<String, String>(name, v));
            }
        }
        return ret;
    }

    public String getResponseHeader(String name) {
        return this.response.getHeader(name);
    }

    public void removeResponseHeader(String name) {
        throw new UnsupportedOperationException();
    }

    public boolean closed() {
        return this.context.response().closed();
    }

    public ServerHttpResponse setChunked(boolean chunked) {
        this.context.response().setChunked(chunked);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerHttpResponse write(byte[] data, Consumer<Throwable> asyncResultHandler) {
        if (this.asyncWriteData != null) {
            asyncResultHandler.accept(new IllegalStateException("Cannot write before data has all been written"));
        }
        if (this.asyncContext == null) {
            try {
                this.response.getOutputStream().write(data);
                asyncResultHandler.accept(null);
            }
            catch (IOException e) {
                asyncResultHandler.accept(e);
            }
        } else {
            ServletRequestContext servletRequestContext = this;
            synchronized (servletRequestContext) {
                if (this.asyncWriteData != null) {
                    throw new IllegalStateException("Cannot write more than one piece of async data at a time");
                }
                this.asyncWriteData = data;
                this.asyncWriteHandler = asyncResultHandler;
                if (this.writeListener == null) {
                    try {
                        ServletOutputStream outputStream = this.response.getOutputStream();
                        this.writeListener = new ServletWriteListener(outputStream);
                        outputStream.setWriteListener((WriteListener)this.writeListener);
                    }
                    catch (IOException e) {
                        asyncResultHandler.accept(e);
                    }
                } else {
                    this.writeListener.onWritePossible();
                }
            }
        }
        return this;
    }

    public CompletionStage<Void> write(byte[] data) {
        final CompletableFuture<Void> cf = new CompletableFuture<Void>();
        this.write(data, new Consumer<Throwable>(){

            @Override
            public void accept(Throwable throwable) {
                if (throwable == null) {
                    cf.complete(null);
                } else {
                    cf.completeExceptionally(throwable);
                }
            }
        });
        return cf;
    }

    public OutputStream createResponseOutputStream() {
        try {
            return this.response.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPreCommitListener(Consumer<ResteasyReactiveRequestContext> task) {
        this.preCommitTask = task;
    }

    public void beforeCommit(HttpServerExchange exchange) {
        if (this.preCommitTask != null) {
            this.preCommitTask.accept(this);
        }
    }

    public ServerHttpResponse sendFile(String path, long offset, long length) {
        this.context.response().sendFile(path, offset, length);
        return this;
    }

    public boolean isWriteQueueFull() {
        return this.context.response().writeQueueFull();
    }

    public ServerHttpResponse addDrainHandler(final Runnable onDrain) {
        this.context.response().drainHandler((Handler)new Handler<Void>(){

            public void handle(Void event) {
                onDrain.run();
            }
        });
        return this;
    }

    static final class MapEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        MapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V old = value;
            this.value = value;
            return old;
        }
    }

    class ServletReadListener
    implements ReadListener {
        final ServletInputStream inputStream;
        final ServerHttpRequest.ReadCallback readCallback;
        boolean paused;
        boolean allDone;
        Throwable problem;

        ServletReadListener(ServletInputStream inputStream, ServerHttpRequest.ReadCallback readCallback) {
            this.inputStream = inputStream;
            this.readCallback = readCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDataAvailable() throws IOException {
            ServletReadListener servletReadListener = this;
            synchronized (servletReadListener) {
                if (this.paused) {
                    return;
                }
            }
            this.doRead();
        }

        private void doRead() {
            if (this.inputStream.isReady()) {
                byte[] buf = new byte[1024];
                try {
                    int r = this.inputStream.read(buf);
                    this.readCallback.data(ByteBuffer.wrap(buf, 0, r));
                }
                catch (IOException e) {
                    ServletRequestContext.this.resume(this.problem);
                }
            }
        }

        synchronized void pause() {
            this.paused = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resume() {
            Throwable problem;
            boolean allDone;
            ServletReadListener servletReadListener = this;
            synchronized (servletReadListener) {
                this.paused = false;
                allDone = this.allDone;
                this.allDone = false;
                problem = this.problem;
                this.problem = null;
            }
            if (problem != null) {
                ServletRequestContext.this.resume(problem);
            } else if (allDone) {
                this.readCallback.done();
            } else {
                this.doRead();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAllDataRead() throws IOException {
            ServletReadListener servletReadListener = this;
            synchronized (servletReadListener) {
                if (this.paused) {
                    this.allDone = true;
                    return;
                }
            }
            this.readCallback.done();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable t) {
            ServletReadListener servletReadListener = this;
            synchronized (servletReadListener) {
                if (this.paused) {
                    this.problem = t;
                    return;
                }
            }
            ServletRequestContext.this.resume(t);
        }
    }

    class ServletWriteListener
    implements WriteListener {
        private final ServletOutputStream outputStream;

        ServletWriteListener(ServletOutputStream outputStream) {
            this.outputStream = outputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWritePossible() {
            ServletRequestContext servletRequestContext = ServletRequestContext.this;
            synchronized (servletRequestContext) {
                if (!this.outputStream.isReady()) {
                    return;
                }
                Consumer<Throwable> ctx = ServletRequestContext.this.asyncWriteHandler;
                byte[] data = ServletRequestContext.this.asyncWriteData;
                ServletRequestContext.this.asyncWriteHandler = null;
                ServletRequestContext.this.asyncWriteData = null;
                try {
                    this.outputStream.write(data);
                    ctx.accept(null);
                }
                catch (IOException e) {
                    ctx.accept(e);
                }
                if (ServletRequestContext.this.closed) {
                    ServletRequestContext.this.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void onError(Throwable t) {
            ServletRequestContext servletRequestContext = ServletRequestContext.this;
            synchronized (servletRequestContext) {
                if (ServletRequestContext.this.asyncWriteHandler != null) {
                    Consumer<Throwable> ctx = ServletRequestContext.this.asyncWriteHandler;
                    ServletRequestContext.this.asyncWriteHandler = null;
                    ServletRequestContext.this.asyncWriteData = null;
                    ctx.accept(t);
                    ServletRequestContext.this.close();
                }
            }
        }
    }
}

