/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jaxb.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.jaxb.deployment.JaxbClassesToBeBoundBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.JaxRsResourceIndexBuildItem;
import io.quarkus.resteasy.reactive.jaxb.runtime.JAXBContextContextResolver;
import io.quarkus.resteasy.reactive.jaxb.runtime.serialisers.ServerJaxbMessageBodyReader;
import io.quarkus.resteasy.reactive.jaxb.runtime.serialisers.ServerJaxbMessageBodyWriter;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveResourceMethodEntriesBuildItem;
import io.quarkus.resteasy.reactive.spi.ContextResolverBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterBuildItem;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.ws.rs.RuntimeType;
import jakarta.xml.bind.JAXBContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.model.MethodParameter;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;

public class ResteasyReactiveJaxbProcessor {
    private static final List<String> XML_TYPES = List.of("application/xml", "text/xml");

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.REST_JAXB));
    }

    @BuildStep
    void additionalProviders(BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<MessageBodyReaderBuildItem> additionalReaders, BuildProducer<MessageBodyWriterBuildItem> additionalWriters, BuildProducer<ContextResolverBuildItem> additionalResolvers) {
        additionalBean.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(ServerJaxbMessageBodyReader.class.getName()).addBeanClass(ServerJaxbMessageBodyWriter.class.getName()).setUnremovable().build());
        additionalReaders.produce((BuildItem)new MessageBodyReaderBuildItem(ServerJaxbMessageBodyReader.class.getName(), Object.class.getName(), XML_TYPES, RuntimeType.SERVER, true, Integer.valueOf(5000)));
        additionalWriters.produce((BuildItem)new MessageBodyWriterBuildItem(ServerJaxbMessageBodyWriter.class.getName(), Object.class.getName(), XML_TYPES, RuntimeType.SERVER, true, Integer.valueOf(5000)));
        additionalResolvers.produce((BuildItem)new ContextResolverBuildItem(JAXBContextContextResolver.class.getName(), XML_TYPES, JAXBContext.class.getName()));
    }

    @BuildStep
    void registerClassesToBeBound(ResteasyReactiveResourceMethodEntriesBuildItem resourceMethodEntries, JaxRsResourceIndexBuildItem index, BuildProducer<JaxbClassesToBeBoundBuildItem> classesToBeBoundBuildItemBuildProducer) {
        HashSet<ClassInfo> classesInfo = new HashSet<ClassInfo>();
        IndexView indexView = index.getIndexView();
        for (ResteasyReactiveResourceMethodEntriesBuildItem.Entry entry : resourceMethodEntries.getEntries()) {
            ResourceMethod resourceInfo = entry.getResourceMethod();
            MethodInfo methodInfo = entry.getMethodInfo();
            ClassInfo effectiveReturnType = this.getEffectiveClassInfo(methodInfo.returnType(), indexView);
            if (effectiveReturnType != null) {
                if (this.producesXml(resourceInfo)) {
                    if (!this.isTypeCompatibleWithJaxb(methodInfo.returnType())) {
                        throw new DeploymentException("Cannot directly return collections or arrays using JAXB. You need to wrap it into a root element class. Problematic method is '" + String.valueOf(entry.getActualClassInfo().name()) + "." + methodInfo.name() + "'");
                    }
                    classesInfo.add(effectiveReturnType);
                }
                if (this.producesMultipart(resourceInfo)) {
                    classesInfo.addAll(this.getEffectivePartsUsingXml(effectiveReturnType, indexView));
                }
            }
            boolean consumesXml = this.consumesXml(resourceInfo);
            boolean consumesMultipart = this.consumesMultipart(resourceInfo);
            if (!consumesXml && !consumesMultipart) continue;
            for (MethodParameterInfo parameter : methodInfo.parameters()) {
                if (this.isParameterBody(parameter, resourceInfo) && !this.isTypeCompatibleWithJaxb(parameter.type())) {
                    throw new DeploymentException("Cannot handle collections or arrays as parameters using JAXB. You need to wrap it into a root element class. Problematic parameter is '" + parameter.name() + "' in the method '" + String.valueOf(entry.getActualClassInfo().name()) + "." + methodInfo.name() + "'");
                }
                ClassInfo effectiveParameter = this.getEffectiveClassInfo(parameter.type(), indexView);
                if (effectiveParameter == null) continue;
                if (consumesXml) {
                    classesInfo.add(effectiveParameter);
                    continue;
                }
                if (!consumesMultipart) continue;
                classesInfo.addAll(this.getEffectivePartsUsingXml(effectiveParameter, indexView));
            }
        }
        classesToBeBoundBuildItemBuildProducer.produce((BuildItem)new JaxbClassesToBeBoundBuildItem(this.toClasses(classesInfo)));
    }

    @BuildStep
    void setupJaxbContextConfigForValidator(Capabilities capabilities, BuildProducer<JaxbClassesToBeBoundBuildItem> classesToBeBoundProducer) {
        if (capabilities.isPresent("io.quarkus.hibernate.validator")) {
            classesToBeBoundProducer.produce((BuildItem)new JaxbClassesToBeBoundBuildItem(Collections.singletonList("io.quarkus.hibernate.validator.runtime.jaxrs.ViolationReport")));
        }
    }

    private List<ClassInfo> getEffectivePartsUsingXml(ClassInfo returnType, IndexView indexView) {
        ArrayList<ClassInfo> classInfos = new ArrayList<ClassInfo>();
        for (FieldInfo field : returnType.fields()) {
            if (!this.isPartTypeXml(field)) continue;
            classInfos.add(this.getEffectiveClassInfo(field.type(), indexView));
        }
        return classInfos;
    }

    private boolean isPartTypeXml(FieldInfo field) {
        AnnotationInstance partType = field.annotation(ResteasyReactiveDotNames.PART_TYPE_NAME);
        if (partType != null) {
            AnnotationValue partTypeValue = partType.value();
            if (this.containsMediaType(new String[]{partTypeValue.asString()}, XML_TYPES)) {
                return true;
            }
        }
        return false;
    }

    private ClassInfo getEffectiveClassInfo(Type type, IndexView indexView) {
        if (type.kind() == Type.Kind.VOID || type.kind() == Type.Kind.PRIMITIVE) {
            return null;
        }
        Type effectiveType = type;
        if (this.isContainerType(effectiveType)) {
            if (effectiveType.kind() != Type.Kind.PARAMETERIZED_TYPE) {
                return null;
            }
            effectiveType = (Type)type.asParameterizedType().arguments().get(0);
        }
        if (this.isCollectionType(effectiveType)) {
            effectiveType = (Type)effectiveType.asParameterizedType().arguments().get(0);
        } else if (this.isMapType(effectiveType)) {
            effectiveType = (Type)effectiveType.asParameterizedType().arguments().get(1);
        }
        ClassInfo effectiveReturnClassInfo = indexView.getClassByName(effectiveType.name());
        if (effectiveReturnClassInfo == null || effectiveReturnClassInfo.name().equals((Object)ResteasyReactiveDotNames.OBJECT)) {
            return null;
        }
        return effectiveReturnClassInfo;
    }

    private boolean consumesXml(ResourceMethod resourceInfo) {
        return this.containsMediaType(resourceInfo.getConsumes(), XML_TYPES);
    }

    private boolean consumesMultipart(ResourceMethod resourceInfo) {
        return this.containsMediaType(resourceInfo.getConsumes(), List.of("multipart/form-data"));
    }

    private boolean producesXml(ResourceMethod resourceInfo) {
        return this.containsMediaType(resourceInfo.getProduces(), XML_TYPES);
    }

    private boolean producesMultipart(ResourceMethod resourceInfo) {
        return this.containsMediaType(resourceInfo.getProduces(), List.of("multipart/form-data"));
    }

    private boolean containsMediaType(String[] types, List<String> mediaTypes) {
        if (types != null) {
            for (String type : types) {
                for (String mediaType : mediaTypes) {
                    if (!type.toLowerCase(Locale.ROOT).contains(mediaType)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private List<String> toClasses(Collection<ClassInfo> classesInfo) {
        ArrayList<String> classes = new ArrayList<String>();
        for (ClassInfo classInfo : classesInfo) {
            classes.add(classInfo.toString());
        }
        return classes;
    }

    private boolean isParameterBody(MethodParameterInfo parameter, ResourceMethod resourceInfo) {
        for (MethodParameter parameterInfo : resourceInfo.getParameters()) {
            if (parameterInfo.name == null || !parameterInfo.name.equals(parameter.name())) continue;
            return parameterInfo.parameterType == ParameterType.BODY;
        }
        return false;
    }

    private boolean isCollectionType(Type type) {
        return type.name().equals((Object)ResteasyReactiveDotNames.SET) || type.name().equals((Object)ResteasyReactiveDotNames.COLLECTION) || type.name().equals((Object)ResteasyReactiveDotNames.LIST);
    }

    private boolean isMapType(Type type) {
        return type.name().equals((Object)ResteasyReactiveDotNames.MAP);
    }

    private boolean isContainerType(Type type) {
        return type.name().equals((Object)ResteasyReactiveDotNames.REST_RESPONSE) || type.name().equals((Object)ResteasyReactiveDotNames.UNI) || type.name().equals((Object)ResteasyReactiveDotNames.COMPLETABLE_FUTURE) || type.name().equals((Object)ResteasyReactiveDotNames.COMPLETION_STAGE) || type.name().equals((Object)ResteasyReactiveDotNames.REST_MULTI) || type.name().equals((Object)ResteasyReactiveDotNames.MULTI);
    }

    private boolean isTypeCompatibleWithJaxb(Type type) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return true;
        }
        if (type.kind() == Type.Kind.ARRAY || this.isCollectionType(type) || this.isMapType(type)) {
            return false;
        }
        if (this.isContainerType(type)) {
            if (type.kind() != Type.Kind.PARAMETERIZED_TYPE) {
                return true;
            }
            return this.isTypeCompatibleWithJaxb((Type)type.asParameterizedType().arguments().get(0));
        }
        return true;
    }
}

