/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.deployment.GeneratedClassGizmo2Adaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveRecorder;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.processor.HashUtil;
import org.jboss.resteasy.reactive.server.processor.EndpointInvokerFactory;
import org.jboss.resteasy.reactive.server.spi.EndpointInvoker;

public class QuarkusInvokerFactory
implements EndpointInvokerFactory {
    private final Predicate<String> applicationClassPredicate;
    final BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer;
    final ResteasyReactiveRecorder recorder;
    private final Map<String, Supplier<EndpointInvoker>> generatedInvokers = new HashMap<String, Supplier<EndpointInvoker>>();

    public QuarkusInvokerFactory(Predicate<String> applicationClassPredicate, BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, ResteasyReactiveRecorder recorder) {
        this.applicationClassPredicate = applicationClassPredicate;
        this.generatedClassBuildItemBuildProducer = generatedClassBuildItemBuildProducer;
        this.recorder = recorder;
    }

    public Supplier<EndpointInvoker> create(ResourceMethod method, ClassInfo currentClassInfo, MethodInfo info) {
        String endpointIdentifier = info.toString() + method.getHttpMethod() + method.getPath() + Arrays.toString(method.getConsumes()) + Arrays.toString(method.getProduces());
        String baseName = String.valueOf(currentClassInfo.name()) + "$quarkusrestinvoker$" + method.getName() + "_" + HashUtil.sha1((String)endpointIdentifier);
        if (this.generatedInvokers.containsKey(baseName)) {
            return this.generatedInvokers.get(baseName);
        }
        GeneratedClassGizmo2Adaptor classOutput = new GeneratedClassGizmo2Adaptor(this.generatedClassBuildItemBuildProducer, null, this.applicationClassPredicate.test(currentClassInfo.name().toString()));
        Gizmo g = Gizmo.create((ClassOutput)classOutput);
        g.class_(baseName, cc -> {
            cc.defaultConstructor();
            cc.implements_(EndpointInvoker.class);
            cc.method("invoke", mc -> {
                ParamVar resourceParam = mc.parameter("resource", Object.class);
                ParamVar resourceMethodArgsParam = mc.parameter("args", Object[].class);
                mc.returning(Object.class);
                mc.body(bc -> {
                    ArrayList<Assignable> args = new ArrayList<Assignable>(method.getParameters().length);
                    for (int i = 0; i < method.getParameters().length; ++i) {
                        args.add(resourceMethodArgsParam.elem(i));
                    }
                    Expr res = Modifier.isInterface(currentClassInfo.flags()) ? bc.invokeInterface(Jandex2Gizmo.methodDescOf((MethodInfo)info), (Expr)resourceParam, args) : bc.invokeVirtual(Jandex2Gizmo.methodDescOf((MethodInfo)info), (Expr)resourceParam, args);
                    if (info.returnType().kind() == Type.Kind.VOID) {
                        bc.returnNull();
                    } else {
                        bc.return_(res);
                    }
                });
            });
        });
        Supplier result = this.recorder.invoker(baseName);
        this.generatedInvokers.put(baseName, result);
        return result;
    }
}

