/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.properties;

import io.quarkus.rest.data.panache.MethodProperties;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.utils.ResourceName;
import jakarta.annotation.security.RolesAllowed;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

public class ResourcePropertiesProvider {
    private static final DotName RESOURCE_PROPERTIES_ANNOTATION = DotName.createSimple((String)io.quarkus.rest.data.panache.ResourceProperties.class.getName());
    private static final DotName METHOD_PROPERTIES_ANNOTATION = DotName.createSimple((String)MethodProperties.class.getName());
    private static final List<String> ANNOTATIONS_TO_COPY = List.of(RolesAllowed.class.getPackageName(), "io.quarkus.resteasy.reactive.server");
    private final IndexView index;

    public ResourcePropertiesProvider(IndexView index) {
        this.index = index;
    }

    public ResourceProperties getFromClass(String resourceClass) {
        DotName resourceClassName = DotName.createSimple((String)resourceClass);
        AnnotationInstance annotation = this.findResourcePropertiesAnnotation(resourceClassName);
        return new ResourceProperties(this.isExposed(annotation), this.getPath(annotation, resourceClass), this.isPaged(annotation), this.isHal(annotation), this.getHalCollectionName(annotation, resourceClass), this.getRolesAllowed(annotation), this.collectAnnotationsToCopy(resourceClassName), this.collectMethodProperties(resourceClassName));
    }

    private Collection<AnnotationInstance> collectAnnotationsToCopy(DotName className) {
        HashSet<AnnotationInstance> annotations = new HashSet<AnnotationInstance>();
        ClassInfo classInfo = this.index.getClassByName(className);
        if (classInfo == null) {
            return annotations;
        }
        for (AnnotationInstance annotation : classInfo.declaredAnnotations()) {
            if (!ANNOTATIONS_TO_COPY.stream().anyMatch(annotation.name().toString()::startsWith)) continue;
            annotations.add(annotation);
        }
        if (classInfo.superName() != null) {
            annotations.addAll(this.collectAnnotationsToCopy(classInfo.superName()));
        }
        return annotations;
    }

    private AnnotationInstance findResourcePropertiesAnnotation(DotName className) {
        ClassInfo classInfo = this.index.getClassByName(className);
        if (classInfo == null) {
            return null;
        }
        if (classInfo.declaredAnnotation(RESOURCE_PROPERTIES_ANNOTATION) != null) {
            return classInfo.declaredAnnotation(RESOURCE_PROPERTIES_ANNOTATION);
        }
        if (classInfo.superName() != null) {
            return this.findResourcePropertiesAnnotation(classInfo.superName());
        }
        return null;
    }

    private Map<String, io.quarkus.rest.data.panache.deployment.properties.MethodProperties> collectMethodProperties(DotName className) {
        HashMap<String, io.quarkus.rest.data.panache.deployment.properties.MethodProperties> methodProperties = new HashMap<String, io.quarkus.rest.data.panache.deployment.properties.MethodProperties>();
        ClassInfo classInfo = this.index.getClassByName(className);
        if (classInfo == null) {
            return methodProperties;
        }
        for (MethodInfo method : classInfo.methods()) {
            AnnotationInstance annotation = method.annotation(METHOD_PROPERTIES_ANNOTATION);
            HashSet<AnnotationInstance> annotationsToCopy = new HashSet<AnnotationInstance>();
            for (AnnotationInstance ann : method.annotations()) {
                if (!ANNOTATIONS_TO_COPY.stream().anyMatch(ann.name().toString()::startsWith)) continue;
                annotationsToCopy.add(ann);
            }
            if (methodProperties.containsKey(method.name()) || annotation == null && annotationsToCopy.isEmpty()) continue;
            methodProperties.put(method.name(), this.getMethodProperties(annotation, annotationsToCopy));
        }
        if (classInfo.superName() != null) {
            methodProperties.putAll(this.collectMethodProperties(classInfo.superName()));
        }
        return methodProperties;
    }

    private io.quarkus.rest.data.panache.deployment.properties.MethodProperties getMethodProperties(AnnotationInstance annotation, Set<AnnotationInstance> annotationsToCopy) {
        return new io.quarkus.rest.data.panache.deployment.properties.MethodProperties(this.isExposed(annotation), this.getPath(annotation), this.getRolesAllowed(annotation), annotationsToCopy);
    }

    private boolean isHal(AnnotationInstance annotation) {
        return annotation != null && annotation.value("hal") != null && annotation.value("hal").asBoolean();
    }

    private boolean isPaged(AnnotationInstance annotation) {
        return annotation == null || annotation.value("paged") == null || annotation.value("paged").asBoolean();
    }

    private boolean isExposed(AnnotationInstance annotation) {
        return annotation == null || annotation.value("exposed") == null || annotation.value("exposed").asBoolean();
    }

    private String getPath(AnnotationInstance annotation) {
        if (annotation != null && annotation.value("path") != null) {
            return annotation.value("path").asString();
        }
        return "";
    }

    private String getPath(AnnotationInstance annotation, String resourceClass) {
        if (annotation != null && annotation.value("path") != null) {
            return annotation.value("path").asString();
        }
        return ResourceName.fromClass(resourceClass);
    }

    private String getHalCollectionName(AnnotationInstance annotation, String resourceClass) {
        if (annotation != null && annotation.value("halCollectionName") != null) {
            return annotation.value("halCollectionName").asString();
        }
        return ResourceName.fromClass(resourceClass);
    }

    private String[] getRolesAllowed(AnnotationInstance annotation) {
        if (annotation != null && annotation.value("rolesAllowed") != null) {
            return annotation.value("rolesAllowed").asStringArray();
        }
        return new String[0];
    }
}

